/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public abstract class AbstractEdmSchema
implements EdmSchema {
    protected final String namespace;
    private final String alias;
    private List<EdmEnumType> enumTypes;
    private List<EdmEntityType> entityTypes;
    private List<EdmComplexType> complexTypes;
    private List<EdmAction> actions;
    private List<EdmFunction> functions;
    private List<EdmTypeDefinition> typeDefinitions;
    private List<EdmTerm> terms;
    private List<EdmAnnotations> annotationGroups;
    private List<EdmAnnotation> annotations;
    private EdmEntityContainer entityContainer;

    public AbstractEdmSchema(String namespace, String alias) {
        this.namespace = namespace;
        this.alias = alias;
    }

    protected abstract EdmEntityContainer createEntityContainer();

    protected abstract List<EdmEnumType> createEnumTypes();

    protected abstract List<EdmEntityType> createEntityTypes();

    protected abstract List<EdmComplexType> createComplexTypes();

    protected abstract List<EdmAction> createActions();

    protected abstract List<EdmFunction> createFunctions();

    protected abstract List<EdmTypeDefinition> createTypeDefinitions();

    protected abstract List<EdmTerm> createTerms();

    protected abstract List<EdmAnnotations> createAnnotationGroups();

    protected abstract List<EdmAnnotation> createAnnotations();

    public List<EdmEnumType> getEnumTypes() {
        if (this.enumTypes == null) {
            this.enumTypes = this.createEnumTypes();
        }
        return this.enumTypes;
    }

    public List<EdmEntityType> getEntityTypes() {
        if (this.entityTypes == null) {
            this.entityTypes = this.createEntityTypes();
        }
        return this.entityTypes;
    }

    public List<EdmComplexType> getComplexTypes() {
        if (this.complexTypes == null) {
            this.complexTypes = this.createComplexTypes();
        }
        return this.complexTypes;
    }

    public List<EdmAction> getActions() {
        if (this.actions == null) {
            this.actions = this.createActions();
        }
        return this.actions;
    }

    public List<EdmFunction> getFunctions() {
        if (this.functions == null) {
            this.functions = this.createFunctions();
        }
        return this.functions;
    }

    public List<EdmTypeDefinition> getTypeDefinitions() {
        if (this.typeDefinitions == null) {
            this.typeDefinitions = this.createTypeDefinitions();
        }
        return this.typeDefinitions;
    }

    public List<EdmTerm> getTerms() {
        if (this.terms == null) {
            this.terms = this.createTerms();
        }
        return this.terms;
    }

    public List<EdmAnnotations> getAnnotationGroups() {
        if (this.annotationGroups == null) {
            this.annotationGroups = this.createAnnotationGroups();
        }
        return this.annotationGroups;
    }

    public List<EdmAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.createAnnotations();
        }
        return this.annotations;
    }

    public EdmEntityContainer getEntityContainer() {
        if (this.entityContainer == null) {
            this.entityContainer = this.createEntityContainer();
        }
        return this.entityContainer;
    }

    public List<EdmEntityContainer> getEntityContainers() {
        if (this.getEntityContainer() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getEntityContainer());
    }

    public EdmEntityContainer getEntityContainer(FullQualifiedName name) {
        return this.getEntityContainer() == null ? null : (name == null ? this.getEntityContainer() : (name.equals((Object)this.getEntityContainer().getFullQualifiedName()) ? this.getEntityContainer() : null));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAlias() {
        return this.alias;
    }
}

