/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmNamedImpl;

public abstract class AbstractEdmTypeDefinition
extends EdmNamedImpl
implements EdmTypeDefinition {
    private final String namespace;

    public AbstractEdmTypeDefinition(Edm edm, FullQualifiedName typeDefinitionName) {
        super(edm, typeDefinitionName.getName());
        this.namespace = typeDefinitionName.getNamespace();
    }

    public abstract EdmPrimitiveType getUnderlyingType();

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return this.getUnderlyingType().isCompatible(primitiveType);
    }

    public Class<?> getDefaultType() {
        return this.getUnderlyingType().getDefaultType();
    }

    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return this.getUnderlyingType().validate(value, isNullable, maxLength, precision, scale, isUnicode);
    }

    public <T> T valueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        return (T)this.getUnderlyingType().valueOfString(value, isNullable, maxLength, precision, scale, isUnicode, returnType);
    }

    public String valueToString(Object value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        return this.getUnderlyingType().valueToString(value, isNullable, maxLength, precision, scale, isUnicode);
    }

    public String toUriLiteral(String literal) {
        return this.getUnderlyingType().toUriLiteral(literal);
    }

    public String fromUriLiteral(String literal) throws EdmPrimitiveTypeException {
        return this.getUnderlyingType().fromUriLiteral(literal);
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName(this.getNamespace(), this.getName());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public EdmTypeKind getKind() {
        return EdmTypeKind.DEFINITION;
    }

    public abstract Integer getMaxLength();

    public abstract Integer getPrecision();

    public abstract Integer getScale();

    public abstract Boolean isUnicode();

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.TypeDefinition;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }

    public String getAnnotationsTargetPath() {
        return null;
    }
}

