/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class FunctionMapKey {
    private final FullQualifiedName functionName;
    private final FullQualifiedName bindingParameterTypeName;
    private final Boolean isBindingParameterCollection;
    private final List<String> parameterNames;

    public FunctionMapKey(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        this.functionName = functionName;
        if (bindingParameterTypeName != null && isBindingParameterCollection == null) {
            throw new EdmException("Indicator that the bindingparameter is a collection must not be null if its an bound function.");
        }
        this.bindingParameterTypeName = bindingParameterTypeName;
        this.isBindingParameterCollection = isBindingParameterCollection;
        this.parameterNames = new ArrayList<String>();
        if (parameterNames != null) {
            this.parameterNames.addAll(parameterNames);
            Collections.sort(this.parameterNames);
        }
    }

    public int hashCode() {
        String hash = this.functionName.toString();
        hash = this.bindingParameterTypeName != null ? hash + this.bindingParameterTypeName.toString() : hash + "typeNull";
        hash = this.isBindingParameterCollection != null ? hash + this.isBindingParameterCollection.toString() : hash + "collectionNull";
        if (!this.parameterNames.isEmpty()) {
            for (String name : this.parameterNames) {
                hash = hash + name;
            }
        } else {
            hash = hash + "parameterNamesEmpty";
        }
        return hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FunctionMapKey)) {
            return false;
        }
        FunctionMapKey other = (FunctionMapKey)obj;
        if (this.functionName.equals((Object)other.functionName) && this.bindingParameterTypeName == null && other.bindingParameterTypeName == null || this.bindingParameterTypeName != null && this.bindingParameterTypeName.equals((Object)other.bindingParameterTypeName) && this.isBindingParameterCollection == null && other.isBindingParameterCollection == null || this.isBindingParameterCollection != null && this.isBindingParameterCollection.equals(other.isBindingParameterCollection)) {
            if (this.parameterNames == null && other.parameterNames == null) {
                return true;
            }
            if (this.parameterNames.size() == other.parameterNames.size()) {
                for (String name : this.parameterNames) {
                    if (other.parameterNames.contains(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

