/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDateTime
extends SingletonPrimitiveType {
    public static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
    };
    private static final EdmDateTime INSTANCE = new EdmDateTime();

    public static EdmDateTime getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Timestamp.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Date date;
        String[] dateParts = value.split("\\.");
        try {
            date = DATE_FORMAT.get().parse(dateParts[0]);
        }
        catch (ParseException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", (Exception)e);
        }
        TimeZone timezone = null;
        String decimals = null;
        if (dateParts.length > 1) {
            int idx = dateParts[1].indexOf(43);
            if (idx == -1) {
                idx = dateParts[1].indexOf(45);
            }
            if (idx == -1) {
                decimals = dateParts[1];
            } else {
                timezone = TimeZone.getTimeZone(dateParts[1].substring(idx));
                decimals = dateParts[1].substring(0, idx);
            }
        }
        Calendar calendar = timezone == null ? Calendar.getInstance() : Calendar.getInstance(timezone);
        calendar.setTime(date);
        Timestamp timestamp = new Timestamp(date.getTime());
        if (decimals != null) {
            if (decimals.length() > (precision == null ? 0 : precision)) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
            }
            String milliSeconds = decimals.length() > 3 ? decimals.substring(0, 3) : decimals + "000".substring(decimals.length());
            calendar.set(14, Short.parseShort(milliSeconds));
            if (!decimals.isEmpty()) {
                int nanos = Integer.parseInt(decimals.length() > 9 ? decimals.substring(0, 9) : decimals + "000000000".substring(decimals.length()));
                timestamp.setNanos(nanos);
            }
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            return returnType.cast(calendar);
        }
        if (returnType.isAssignableFrom(Timestamp.class)) {
            return returnType.cast(timestamp);
        }
        throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            Date date = calendar.getTime();
            Integer fractionalSecs = calendar.get(14);
            StringBuilder result = new StringBuilder().append(DATE_FORMAT.get().format(date));
            EdmDateTimeOffset.appendMilliseconds(result, fractionalSecs, precision);
            return result.toString();
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            Date date = new Date(timestamp.getTime());
            Integer fractionalSecs = timestamp.getNanos();
            StringBuilder result = new StringBuilder().append(DATE_FORMAT.get().format(date));
            EdmDateTimeOffset.appendFractionalSeconds(result, fractionalSecs, precision);
            return result.toString();
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

