/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmStream
extends SingletonPrimitiveType {
    private static final EdmStream INSTANCE = new EdmStream();

    public static EdmStream getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return URI.class;
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        if (value == null) {
            return isNullable == null || isNullable != false;
        }
        try {
            new URI(value);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        URI stream = null;
        try {
            stream = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", (Exception)e);
        }
        if (returnType.isAssignableFrom(URI.class)) {
            return returnType.cast(stream);
        }
        throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof URI) {
            return ((URI)value).toASCIIString();
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

