/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.domain.ODataPropertyType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.serialization.ODataDeserializer;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.data.AnnotationImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.data.LinkedComplexValueImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.JsonEntityDeserializer;
import org.apache.olingo.commons.core.serialization.JsonEntitySetDeserializer;
import org.apache.olingo.commons.core.serialization.JsonGeoValueDeserializer;
import org.apache.olingo.commons.core.serialization.JsonODataErrorDeserializer;
import org.apache.olingo.commons.core.serialization.JsonPropertyDeserializer;

public class JsonDeserializer
implements ODataDeserializer {
    protected final Pattern CUSTOM_ANNOTATION = Pattern.compile("(.+)@(.+)\\.(.+)");
    protected final ODataServiceVersion version;
    protected final boolean serverMode;
    protected String jsonType;
    protected String jsonId;
    protected String jsonETag;
    protected String jsonReadLink;
    protected String jsonEditLink;
    protected String jsonMediaEditLink;
    protected String jsonMediaReadLink;
    protected String jsonMediaContentType;
    protected String jsonMediaETag;
    protected String jsonAssociationLink;
    protected String jsonNavigationLink;
    protected String jsonCount;
    protected String jsonNextLink;
    protected String jsonDeltaLink;
    protected String jsonError;
    private JsonGeoValueDeserializer geoDeserializer;
    private JsonParser parser;

    public JsonDeserializer(ODataServiceVersion version, boolean serverMode) {
        this.version = version;
        this.serverMode = serverMode;
        this.jsonType = version.getJsonName(ODataServiceVersion.JsonKey.TYPE);
        this.jsonId = version.getJsonName(ODataServiceVersion.JsonKey.ID);
        this.jsonETag = version.getJsonName(ODataServiceVersion.JsonKey.ETAG);
        this.jsonReadLink = version.getJsonName(ODataServiceVersion.JsonKey.READ_LINK);
        this.jsonEditLink = version.getJsonName(ODataServiceVersion.JsonKey.EDIT_LINK);
        this.jsonMediaReadLink = version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_READ_LINK);
        this.jsonMediaEditLink = version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_EDIT_LINK);
        this.jsonMediaContentType = version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_CONTENT_TYPE);
        this.jsonMediaETag = version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_ETAG);
        this.jsonAssociationLink = version.getJsonName(ODataServiceVersion.JsonKey.ASSOCIATION_LINK);
        this.jsonNavigationLink = version.getJsonName(ODataServiceVersion.JsonKey.NAVIGATION_LINK);
        this.jsonCount = version.getJsonName(ODataServiceVersion.JsonKey.COUNT);
        this.jsonNextLink = version.getJsonName(ODataServiceVersion.JsonKey.NEXT_LINK);
        this.jsonDeltaLink = version.getJsonName(ODataServiceVersion.JsonKey.DELTA_LINK);
        this.jsonError = version.getJsonName(ODataServiceVersion.JsonKey.ERROR);
    }

    private JsonGeoValueDeserializer getGeoDeserializer() {
        if (this.geoDeserializer == null) {
            this.geoDeserializer = new JsonGeoValueDeserializer(this.version);
        }
        return this.geoDeserializer;
    }

    protected String getJSONAnnotation(String string) {
        return StringUtils.prependIfMissing((String)string, (CharSequence)"@", (CharSequence[])new CharSequence[0]);
    }

    protected String getTitle(Map.Entry<String, JsonNode> entry) {
        return entry.getKey().substring(0, entry.getKey().indexOf(64));
    }

    protected String setInline(String name, String suffix, JsonNode tree, ObjectCodec codec, LinkImpl link) throws IOException {
        String entityNamePrefix = name.substring(0, name.indexOf(suffix));
        if (tree.has(entityNamePrefix)) {
            JsonNode inline = tree.path(entityNamePrefix);
            JsonEntityDeserializer entityDeserializer = new JsonEntityDeserializer(this.version, this.serverMode);
            if (inline instanceof ObjectNode) {
                link.setType(ODataLinkType.ENTITY_NAVIGATION.toString());
                link.setInlineEntity((Entity)entityDeserializer.doDeserialize(inline.traverse(codec)).getPayload());
            } else if (inline instanceof ArrayNode) {
                link.setType(ODataLinkType.ENTITY_SET_NAVIGATION.toString());
                EntitySetImpl entitySet = new EntitySetImpl();
                Iterator entries = inline.elements();
                while (entries.hasNext()) {
                    entitySet.getEntities().add(entityDeserializer.doDeserialize(((JsonNode)entries.next()).traverse(codec)).getPayload());
                }
                link.setInlineEntitySet(entitySet);
            }
        }
        return entityNamePrefix;
    }

    protected void links(Map.Entry<String, JsonNode> field, Linked linked, Set<String> toRemove, JsonNode tree, ObjectCodec codec) throws IOException {
        if (this.serverMode) {
            this.serverLinks(field, linked, toRemove, tree, codec);
        } else {
            this.clientLinks(field, linked, toRemove, tree, codec);
        }
    }

    private void clientLinks(Map.Entry<String, JsonNode> field, Linked linked, Set<String> toRemove, JsonNode tree, ObjectCodec codec) throws IOException {
        if (field.getKey().endsWith(this.jsonNavigationLink)) {
            LinkImpl link = new LinkImpl();
            link.setTitle(this.getTitle(field));
            link.setRel(this.version.getNamespace(ODataServiceVersion.NamespaceKey.NAVIGATION_LINK_REL) + this.getTitle(field));
            if (field.getValue().isValueNode()) {
                link.setHref(field.getValue().textValue());
                link.setType(ODataLinkType.ENTITY_NAVIGATION.toString());
            }
            linked.getNavigationLinks().add(link);
            toRemove.add(field.getKey());
            toRemove.add(this.setInline(field.getKey(), this.jsonNavigationLink, tree, codec, link));
        } else if (field.getKey().endsWith(this.jsonAssociationLink)) {
            LinkImpl link = new LinkImpl();
            link.setTitle(this.getTitle(field));
            link.setRel(this.version.getNamespace(ODataServiceVersion.NamespaceKey.ASSOCIATION_LINK_REL) + this.getTitle(field));
            link.setHref(field.getValue().textValue());
            link.setType(ODataLinkType.ASSOCIATION.toString());
            linked.getAssociationLinks().add(link);
            toRemove.add(field.getKey());
        }
    }

    private void serverLinks(Map.Entry<String, JsonNode> field, Linked linked, Set<String> toRemove, JsonNode tree, ObjectCodec codec) throws IOException {
        if (field.getKey().endsWith("@odata.bind") || field.getKey().endsWith(this.jsonNavigationLink)) {
            if (field.getValue().isValueNode()) {
                String suffix = field.getKey().replaceAll("^.*@", "@");
                LinkImpl link = new LinkImpl();
                link.setTitle(this.getTitle(field));
                link.setRel(this.version.getNamespace(ODataServiceVersion.NamespaceKey.NAVIGATION_LINK_REL) + this.getTitle(field));
                link.setHref(field.getValue().textValue());
                link.setType(ODataLinkType.ENTITY_NAVIGATION.toString());
                linked.getNavigationLinks().add(link);
                toRemove.add(this.setInline(field.getKey(), suffix, tree, codec, link));
            } else if (field.getValue().isArray()) {
                Iterator itor = field.getValue().elements();
                while (itor.hasNext()) {
                    JsonNode node = (JsonNode)itor.next();
                    LinkImpl link = new LinkImpl();
                    link.setTitle(this.getTitle(field));
                    link.setRel(this.version.getNamespace(ODataServiceVersion.NamespaceKey.NAVIGATION_LINK_REL) + this.getTitle(field));
                    link.setHref(node.asText());
                    link.setType(ODataLinkType.ENTITY_SET_NAVIGATION.toString());
                    linked.getNavigationLinks().add(link);
                    toRemove.add(this.setInline(field.getKey(), "@odata.bind", tree, codec, link));
                }
            }
            toRemove.add(field.getKey());
        }
    }

    private Map.Entry<ODataPropertyType, EdmTypeInfo> guessPropertyType(JsonNode node) {
        ODataPropertyType type;
        EdmTypeInfo typeInfo = null;
        if (node.isValueNode() || node.isNull()) {
            type = ODataPropertyType.PRIMITIVE;
            EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.String;
            if (node.isShort()) {
                kind = EdmPrimitiveTypeKind.Int16;
            } else if (node.isInt()) {
                kind = EdmPrimitiveTypeKind.Int32;
            } else if (node.isLong()) {
                kind = EdmPrimitiveTypeKind.Int64;
            } else if (node.isBoolean()) {
                kind = EdmPrimitiveTypeKind.Boolean;
            } else if (node.isFloat()) {
                kind = EdmPrimitiveTypeKind.Single;
            } else if (node.isDouble()) {
                kind = EdmPrimitiveTypeKind.Double;
            } else if (node.isBigDecimal()) {
                kind = EdmPrimitiveTypeKind.Decimal;
            }
            typeInfo = new EdmTypeInfo.Builder().setTypeExpression(kind.getFullQualifiedName().toString()).build();
        } else if (node.isArray()) {
            type = ODataPropertyType.COLLECTION;
        } else if (node.isObject()) {
            if (node.has("type")) {
                type = ODataPropertyType.PRIMITIVE;
                typeInfo = new EdmTypeInfo.Builder().setTypeExpression("Edm.Geography" + node.get("type").asText()).build();
            } else {
                type = ODataPropertyType.COMPLEX;
            }
        } else {
            type = ODataPropertyType.EMPTY;
        }
        return new AbstractMap.SimpleEntry<ODataPropertyType, Object>(type, typeInfo);
    }

    protected void populate(Annotatable annotatable, List<Property> properties, ObjectNode tree, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        String type = null;
        AnnotationImpl annotation = null;
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            Matcher customAnnotation = this.CUSTOM_ANNOTATION.matcher((CharSequence)field.getKey());
            if (((String)field.getKey()).charAt(0) == '@') {
                AnnotationImpl entityAnnot = new AnnotationImpl();
                entityAnnot.setTerm(((String)field.getKey()).substring(1));
                this.value(entityAnnot, (JsonNode)field.getValue(), codec);
                if (annotatable == null) continue;
                annotatable.getAnnotations().add(entityAnnot);
                continue;
            }
            if (type == null && ((String)field.getKey()).endsWith(this.getJSONAnnotation(this.jsonType))) {
                type = ((JsonNode)field.getValue()).asText();
                continue;
            }
            if (annotation == null && customAnnotation.matches() && !"odata".equals(customAnnotation.group(2))) {
                annotation = new AnnotationImpl();
                annotation.setTerm(customAnnotation.group(2) + "." + customAnnotation.group(3));
                this.value(annotation, (JsonNode)field.getValue(), codec);
                continue;
            }
            PropertyImpl property = new PropertyImpl();
            property.setName((String)field.getKey());
            property.setType(type == null ? null : new EdmTypeInfo.Builder().setTypeExpression(type).build().internal());
            type = null;
            this.value(property, (JsonNode)field.getValue(), codec);
            properties.add(property);
            if (annotation == null) continue;
            property.getAnnotations().add(annotation);
            annotation = null;
        }
    }

    private Object fromPrimitive(JsonNode node, EdmTypeInfo typeInfo) throws EdmPrimitiveTypeException {
        return node.isNull() ? null : (typeInfo == null ? node.asText() : (typeInfo.getPrimitiveTypeKind().isGeospatial() ? this.getGeoDeserializer().deserialize(node, typeInfo) : ((EdmPrimitiveType)typeInfo.getType()).valueOfString(node.asText(), Boolean.valueOf(true), null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, Boolean.valueOf(true), ((EdmPrimitiveType)typeInfo.getType()).getDefaultType())));
    }

    private Object fromComplex(ObjectNode node, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        if (this.version.compareTo((Enum)ODataServiceVersion.V40) < 0) {
            ArrayList<Property> properties = new ArrayList<Property>();
            this.populate(null, properties, node, codec);
            return properties;
        }
        LinkedComplexValueImpl linkComplexValue = new LinkedComplexValueImpl();
        HashSet<String> toRemove = new HashSet<String>();
        Iterator itor = node.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            this.links(field, (Linked)linkComplexValue, toRemove, (JsonNode)node, codec);
        }
        node.remove(toRemove);
        this.populate((Annotatable)linkComplexValue, linkComplexValue.getValue(), node, codec);
        return linkComplexValue;
    }

    private void fromCollection(Valuable valuable, Iterator<JsonNode> nodeItor, EdmTypeInfo typeInfo, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo type;
        ArrayList<Object> values = new ArrayList<Object>();
        ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
        EdmTypeInfo edmTypeInfo = type = typeInfo == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeInfo.getFullQualifiedName().toString()).build();
        while (nodeItor.hasNext()) {
            Object value;
            JsonNode child = nodeItor.next();
            if (child.isValueNode()) {
                if (typeInfo == null || typeInfo.isPrimitiveType()) {
                    value = this.fromPrimitive(child, type);
                    valueType = value instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
                    values.add(value);
                    continue;
                }
                valueType = ValueType.COLLECTION_ENUM;
                values.add(child.asText());
                continue;
            }
            if (!child.isContainerNode()) continue;
            if (child.has(this.jsonType)) {
                ((ObjectNode)child).remove(this.jsonType);
            }
            valueType = (value = this.fromComplex((ObjectNode)child, codec)) instanceof LinkedComplexValue ? ValueType.COLLECTION_LINKED_COMPLEX : ValueType.COLLECTION_COMPLEX;
            values.add(value);
        }
        valuable.setValue(valueType, values);
    }

    protected void value(Valuable valuable, JsonNode node, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo typeInfo = StringUtils.isBlank((CharSequence)valuable.getType()) ? null : new EdmTypeInfo.Builder().setTypeExpression(valuable.getType()).build();
        Map.Entry<ODataPropertyType, EdmTypeInfo> guessed = this.guessPropertyType(node);
        if (typeInfo == null) {
            typeInfo = guessed.getValue();
        }
        ODataPropertyType propType = typeInfo == null ? guessed.getKey() : (typeInfo.isCollection() ? ODataPropertyType.COLLECTION : (typeInfo.isPrimitiveType() ? ODataPropertyType.PRIMITIVE : (node.isValueNode() ? ODataPropertyType.ENUM : ODataPropertyType.COMPLEX)));
        switch (propType) {
            case COLLECTION: {
                this.fromCollection(valuable, node.elements(), typeInfo, codec);
                break;
            }
            case COMPLEX: {
                Object value;
                if (node.has(this.jsonType)) {
                    valuable.setType(node.get(this.jsonType).asText());
                    ((ObjectNode)node).remove(this.jsonType);
                }
                valuable.setValue((value = this.fromComplex((ObjectNode)node, codec)) instanceof LinkedComplexValue ? ValueType.LINKED_COMPLEX : ValueType.COMPLEX, value);
                break;
            }
            case ENUM: {
                valuable.setValue(ValueType.ENUM, (Object)node.asText());
                break;
            }
            case PRIMITIVE: {
                Object primitiveValue;
                if (valuable.getType() == null && typeInfo != null) {
                    valuable.setType(typeInfo.getFullQualifiedName().toString());
                }
                valuable.setValue((primitiveValue = this.fromPrimitive(node, typeInfo)) instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, primitiveValue);
                break;
            }
            default: {
                valuable.setValue(ValueType.PRIMITIVE, (Object)"");
            }
        }
    }

    public ResWrap<EntitySet> toEntitySet(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return new JsonEntitySetDeserializer(this.version, this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }

    public ResWrap<Entity> toEntity(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return new JsonEntityDeserializer(this.version, this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }

    public ResWrap<Property> toProperty(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return new JsonPropertyDeserializer(this.version, this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }

    public ODataError toError(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return new JsonODataErrorDeserializer(this.version, this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

