/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.v3.LinkCollection;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.data.v3.LinkCollectionImpl;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class JsonLinkCollectionDeserializer
extends JsonDeserializer {
    public JsonLinkCollectionDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<LinkCollection> doDeserialize(JsonParser parser) throws IOException {
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        LinkCollectionImpl links = new LinkCollectionImpl();
        if (tree.hasNonNull("odata.metadata")) {
            links.setMetadata(URI.create(tree.get("odata.metadata").textValue()));
        }
        if (tree.hasNonNull("url")) {
            links.getLinks().add(URI.create(tree.get("url").textValue()));
        }
        if (tree.hasNonNull("value")) {
            for (JsonNode item : tree.get("value")) {
                URI uri = URI.create(item.get("url").textValue());
                links.getLinks().add(uri);
            }
        }
        if (tree.hasNonNull(this.jsonNextLink)) {
            links.setNext(URI.create(tree.get(this.jsonNextLink).textValue()));
        }
        return new ResWrap((URI)null, null, (Object)links);
    }

    public ResWrap<LinkCollection> toLinkCollection(InputStream input) throws ODataDeserializerException {
        try {
            JsonParser parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return this.doDeserialize(parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

