/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.serialization.JsonEntitySerializer;
import org.apache.olingo.commons.core.serialization.JsonEntitySetSerializer;
import org.apache.olingo.commons.core.serialization.JsonGeoValueSerializer;
import org.apache.olingo.commons.core.serialization.JsonPropertySerializer;

public class JsonSerializer
implements ODataSerializer {
    private static final EdmPrimitiveTypeKind[] NUMBER_TYPES = new EdmPrimitiveTypeKind[]{EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Decimal};
    private final JsonGeoValueSerializer geoSerializer = new JsonGeoValueSerializer();
    protected ODataServiceVersion version;
    protected boolean serverMode;
    protected ODataFormat format;

    public JsonSerializer(ODataServiceVersion version, boolean serverMode) {
        this(version, serverMode, ODataFormat.JSON_FULL_METADATA);
    }

    public JsonSerializer(ODataServiceVersion version, boolean serverMode, ODataFormat format) {
        this.version = version;
        this.serverMode = serverMode;
        this.format = format;
    }

    public <T> void write(Writer writer, T obj) throws ODataSerializerException {
        try {
            JsonGenerator json = new JsonFactory().createGenerator(writer);
            if (obj instanceof EntitySet) {
                new JsonEntitySetSerializer(this.version, this.serverMode).doSerialize((EntitySet)obj, json);
            } else if (obj instanceof Entity) {
                new JsonEntitySerializer(this.version, this.serverMode, this.format).doSerialize((Entity)obj, json);
            } else if (obj instanceof Property) {
                new JsonPropertySerializer(this.version, this.serverMode).doSerialize((Property)obj, json);
            } else if (obj instanceof Link) {
                this.link((Link)obj, json);
            }
            json.flush();
        }
        catch (IOException e) {
            throw new ODataSerializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataSerializerException((Throwable)e);
        }
    }

    public <T> void write(Writer writer, ResWrap<T> container) throws ODataSerializerException {
        Object obj = container == null ? null : container.getPayload();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(writer);
            if (obj instanceof EntitySet) {
                new JsonEntitySetSerializer(this.version, this.serverMode).doContainerSerialize(container, json);
            } else if (obj instanceof Entity) {
                new JsonEntitySerializer(this.version, this.serverMode).doContainerSerialize(container, json);
            } else if (obj instanceof Property) {
                new JsonPropertySerializer(this.version, this.serverMode).doContainerSerialize(container, json);
            } else if (obj instanceof Link) {
                this.link((Link)obj, json);
            }
            json.flush();
        }
        catch (IOException e) {
            throw new ODataSerializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataSerializerException((Throwable)e);
        }
    }

    protected void link(Link link, JsonGenerator jgen) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("url", link.getHref());
        jgen.writeEndObject();
    }

    protected void links(Linked linked, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        if (this.serverMode) {
            this.serverLinks(linked, jgen);
        } else {
            this.clientLinks(linked, jgen);
        }
    }

    protected void clientLinks(Linked linked, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        HashMap entitySetLinks = new HashMap();
        for (Link link : linked.getNavigationLinks()) {
            for (Annotation annotation : link.getAnnotations()) {
                this.valuable(jgen, (Valuable)annotation, link.getTitle() + "@" + annotation.getTerm());
            }
            ODataLinkType type = null;
            try {
                type = ODataLinkType.fromString((ODataServiceVersion)this.version, (String)link.getRel(), (String)link.getType());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (type == ODataLinkType.ENTITY_SET_NAVIGATION) {
                List<String> uris;
                if (entitySetLinks.containsKey(link.getTitle())) {
                    uris = (List)entitySetLinks.get(link.getTitle());
                } else {
                    uris = new ArrayList();
                    entitySetLinks.put(link.getTitle(), uris);
                }
                if (StringUtils.isNotBlank((CharSequence)link.getHref())) {
                    uris.add(link.getHref());
                }
            } else if (StringUtils.isNotBlank((CharSequence)link.getHref())) {
                jgen.writeStringField(link.getTitle() + "@odata.bind", link.getHref());
            }
            if (link.getInlineEntity() != null) {
                jgen.writeFieldName(link.getTitle());
                new JsonEntitySerializer(this.version, this.serverMode).doSerialize(link.getInlineEntity(), jgen);
                continue;
            }
            if (link.getInlineEntitySet() == null) continue;
            jgen.writeArrayFieldStart(link.getTitle());
            JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.version, this.serverMode);
            for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                entitySerializer.doSerialize(subEntry, jgen);
            }
            jgen.writeEndArray();
        }
        for (Map.Entry entry : entitySetLinks.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            jgen.writeArrayFieldStart((String)entry.getKey() + "@odata.bind");
            for (String uri : (List)entry.getValue()) {
                jgen.writeString(uri);
            }
            jgen.writeEndArray();
        }
    }

    protected void serverLinks(Linked linked, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        if (linked instanceof Entity) {
            for (Link link : ((Entity)linked).getMediaEditLinks()) {
                if (!StringUtils.isNotBlank((CharSequence)link.getHref())) continue;
                jgen.writeStringField(link.getTitle() + StringUtils.prependIfMissing((String)this.version.getJsonName(ODataServiceVersion.JsonKey.MEDIA_EDIT_LINK), (CharSequence)"@", (CharSequence[])new CharSequence[0]), link.getHref());
            }
        }
        for (Link link : linked.getAssociationLinks()) {
            if (!StringUtils.isNotBlank((CharSequence)link.getHref())) continue;
            jgen.writeStringField(link.getTitle() + this.version.getJsonName(ODataServiceVersion.JsonKey.ASSOCIATION_LINK), link.getHref());
        }
        for (Link link : linked.getNavigationLinks()) {
            for (Annotation annotation : link.getAnnotations()) {
                this.valuable(jgen, (Valuable)annotation, link.getTitle() + "@" + annotation.getTerm());
            }
            if (StringUtils.isNotBlank((CharSequence)link.getHref())) {
                jgen.writeStringField(link.getTitle() + this.version.getJsonName(ODataServiceVersion.JsonKey.NAVIGATION_LINK), link.getHref());
            }
            if (link.getInlineEntity() != null) {
                jgen.writeFieldName(link.getTitle());
                new JsonEntitySerializer(this.version, this.serverMode).doSerialize(link.getInlineEntity(), jgen);
                continue;
            }
            if (link.getInlineEntitySet() == null) continue;
            jgen.writeArrayFieldStart(link.getTitle());
            JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.version, this.serverMode);
            for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                entitySerializer.doSerialize(subEntry, jgen);
            }
            jgen.writeEndArray();
        }
    }

    private void collection(JsonGenerator jgen, EdmTypeInfo typeInfo, ValueType valueType, List<?> value) throws IOException, EdmPrimitiveTypeException {
        jgen.writeStartArray();
        for (Object item : value) {
            EdmTypeInfo itemTypeInfo = typeInfo == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeInfo.getFullQualifiedName().toString()).build();
            switch (valueType) {
                case COLLECTION_PRIMITIVE: {
                    this.primitiveValue(jgen, itemTypeInfo, item);
                    break;
                }
                case COLLECTION_GEOSPATIAL: {
                    jgen.writeStartObject();
                    this.geoSerializer.serialize(jgen, (Geospatial)item);
                    jgen.writeEndObject();
                    break;
                }
                case COLLECTION_ENUM: {
                    jgen.writeString(item.toString());
                    break;
                }
                case COLLECTION_COMPLEX: {
                    List complexItem = (List)item;
                    this.complexValue(jgen, itemTypeInfo, complexItem, null);
                    break;
                }
                case COLLECTION_LINKED_COMPLEX: {
                    LinkedComplexValue complexItem2 = (LinkedComplexValue)item;
                    this.complexValue(jgen, itemTypeInfo, complexItem2.getValue(), (Linked)complexItem2);
                    break;
                }
            }
        }
        jgen.writeEndArray();
    }

    protected void primitiveValue(JsonGenerator jgen, EdmTypeInfo typeInfo, Object value) throws IOException, EdmPrimitiveTypeException {
        boolean isBoolean;
        boolean isNumber;
        EdmPrimitiveTypeKind kind = typeInfo == null ? null : typeInfo.getPrimitiveTypeKind();
        boolean bl = isNumber = kind == null ? value instanceof Number : ArrayUtils.contains((Object[])NUMBER_TYPES, (Object)kind);
        boolean bl2 = kind == null ? value instanceof Boolean : (isBoolean = kind == EdmPrimitiveTypeKind.Boolean);
        if (value == null) {
            jgen.writeNull();
        } else if (isBoolean) {
            jgen.writeBoolean(((Boolean)value).booleanValue());
        } else {
            String serialized;
            String string = serialized = kind == null ? value.toString() : EdmPrimitiveTypeFactory.getInstance(kind).valueToString(value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null);
            if (isNumber) {
                jgen.writeNumber(serialized);
            } else {
                jgen.writeString(serialized);
            }
        }
    }

    private void complexValue(JsonGenerator jgen, EdmTypeInfo typeInfo, List<Property> value, Linked linked) throws IOException, EdmPrimitiveTypeException {
        jgen.writeStartObject();
        if (typeInfo != null && this.format != ODataFormat.JSON_NO_METADATA) {
            jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.TYPE), typeInfo.external(this.version));
        }
        for (Property property : value) {
            this.valuable(jgen, (Valuable)property, property.getName());
        }
        if (linked != null) {
            this.links(linked, jgen);
        }
        jgen.writeEndObject();
    }

    private void value(JsonGenerator jgen, String type, Valuable value) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo typeInfo;
        EdmTypeInfo edmTypeInfo = typeInfo = type == null ? null : new EdmTypeInfo.Builder().setTypeExpression(type).build();
        if (value.isNull()) {
            jgen.writeNull();
        } else if (value.isPrimitive()) {
            this.primitiveValue(jgen, typeInfo, value.asPrimitive());
        } else if (value.isEnum()) {
            jgen.writeString(value.asEnum().toString());
        } else if (value.isGeospatial()) {
            jgen.writeStartObject();
            this.geoSerializer.serialize(jgen, value.asGeospatial());
            jgen.writeEndObject();
        } else if (value.isCollection()) {
            this.collection(jgen, typeInfo, value.getValueType(), value.asCollection());
        } else if (value.isLinkedComplex()) {
            this.complexValue(jgen, typeInfo, value.asLinkedComplex().getValue(), (Linked)value.asLinkedComplex());
        } else if (value.isComplex()) {
            this.complexValue(jgen, typeInfo, value.asComplex(), null);
        }
    }

    protected void valuable(JsonGenerator jgen, Valuable valuable, String name) throws IOException, EdmPrimitiveTypeException {
        if (!("value".equals(name) || valuable instanceof Annotation || valuable.isComplex() || valuable.isLinkedComplex())) {
            String type = valuable.getType();
            if (StringUtils.isBlank((CharSequence)type) && valuable.isPrimitive() || valuable.isNull()) {
                type = EdmPrimitiveTypeKind.String.getFullQualifiedName().toString();
            }
            if (StringUtils.isNotBlank((CharSequence)type) && this.format != ODataFormat.JSON_NO_METADATA) {
                jgen.writeFieldName(name + StringUtils.prependIfMissing((String)this.version.getJsonName(ODataServiceVersion.JsonKey.TYPE), (CharSequence)"@", (CharSequence[])new CharSequence[0]));
                jgen.writeString(new EdmTypeInfo.Builder().setTypeExpression(type).build().external(this.version));
            }
        }
        if (valuable instanceof Annotatable) {
            for (Annotation annotation : ((Annotatable)valuable).getAnnotations()) {
                this.valuable(jgen, (Valuable)annotation, name + "@" + annotation.getTerm());
            }
        }
        jgen.writeFieldName(name);
        this.value(jgen, valuable.getType(), valuable);
    }
}

