/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmParameterImpl
extends AbstractEdmNamed
implements EdmParameter,
EdmElement {
    private final CsdlParameter parameter;
    private final EdmTypeInfo typeInfo;
    private EdmType typeImpl;

    public EdmParameterImpl(Edm edm, CsdlParameter parameter) {
        super(edm, parameter.getName(), (CsdlAnnotatable)parameter);
        this.parameter = parameter;
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(parameter.getType()).build();
    }

    public boolean isCollection() {
        return this.parameter.isCollection();
    }

    public EdmMapping getMapping() {
        return this.parameter.getMapping();
    }

    public boolean isNullable() {
        return this.parameter.isNullable();
    }

    public Integer getMaxLength() {
        return this.parameter.getMaxLength();
    }

    public Integer getPrecision() {
        return this.parameter.getPrecision();
    }

    public Integer getScale() {
        return this.parameter.getScale();
    }

    public SRID getSrid() {
        return this.parameter.getSrid();
    }

    public EdmType getType() {
        if (this.typeImpl == null) {
            this.typeImpl = this.typeInfo.getType();
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
        }
        return this.typeImpl;
    }
}

