/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ErrorHandler;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ODataHttpHandlerImpl;
import org.apache.olingo.server.core.ServiceDispatcher;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.legacy.ProcessorServiceHandler;

public class OData4HttpHandler
extends ODataHttpHandlerImpl {
    private ServiceHandler handler;
    private final ServiceMetadata serviceMetadata;
    private final OData odata;
    private CustomContentTypeSupport customContentTypeSupport;

    public OData4HttpHandler(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
        this.handler = new ProcessorServiceHandler();
        this.handler.init(odata, serviceMetadata);
    }

    public void process(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        ODataRequest request = null;
        ODataResponse response = new ODataResponse();
        try {
            request = this.createODataRequest(httpRequest, 0);
            this.validateODataVersion(request, response);
            ServiceDispatcher dispatcher = new ServiceDispatcher(this.odata, this.serviceMetadata, this.handler, this.customContentTypeSupport);
            dispatcher.execute(request, response);
        }
        catch (Exception e) {
            ErrorHandler handler = new ErrorHandler(this.odata, this.serviceMetadata, this.customContentTypeSupport);
            handler.handleException(e, request, response);
        }
        OData4HttpHandler.convertToHttp((HttpServletResponse)httpResponse, (ODataResponse)response);
    }

    ODataRequest createODataRequest(HttpServletRequest httpRequest, int split) throws ODataTranslatedException {
        try {
            ODataRequest odRequest = new ODataRequest();
            odRequest.setBody((InputStream)httpRequest.getInputStream());
            OData4HttpHandler.extractHeaders((ODataRequest)odRequest, (HttpServletRequest)httpRequest);
            OData4HttpHandler.extractMethod((ODataRequest)odRequest, (HttpServletRequest)httpRequest);
            OData4HttpHandler.extractUri((ODataRequest)odRequest, (HttpServletRequest)httpRequest, (int)split);
            return odRequest;
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataHandlerException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, (ODataTranslatedException.MessageKey)ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, new String[]{maxVersion});
        }
    }

    public void register(Processor processor) {
        if (processor instanceof ServiceHandler) {
            this.handler = (ServiceHandler)processor;
            this.handler.init(this.odata, this.serviceMetadata);
        }
        if (this.handler instanceof ProcessorServiceHandler) {
            ((ProcessorServiceHandler)this.handler).register(processor);
        }
    }

    public void register(CustomContentTypeSupport customContentTypeSupport) {
        this.customContentTypeSupport = customContentTypeSupport;
    }
}

