/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.requests;

import java.io.InputStream;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.requests.OperationRequest;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;

public class ActionRequest
extends OperationRequest {
    private UriResourceAction uriResourceAction;

    public ActionRequest(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
    }

    @Override
    public void execute(ServiceHandler handler, ODataResponse response) throws ODataTranslatedException, ODataApplicationException {
        if (!this.allowedMethod()) {
            this.methodNotAllowed();
        }
        if (!this.hasReturnType()) {
            handler.invoke(this, this.getETag(), new NoContentResponse(this.getServiceMetaData(), response));
        } else if (this.isReturnTypePrimitive() || this.isReturnTypeComplex()) {
            handler.invoke(this, this.getETag(), PropertyResponse.getInstance(this, response, this.getReturnType().getType(), this.getContextURL(this.odata), this.isCollection()));
        } else if (this.isCollection()) {
            handler.invoke(this, this.getETag(), EntitySetResponse.getInstance(this, this.getContextURL(this.odata), false, response));
        } else {
            handler.invoke(this, this.getETag(), EntityResponse.getInstance(this, this.getContextURL(this.odata), false, response));
        }
    }

    @Override
    public boolean allowedMethod() {
        return this.isPOST();
    }

    @Override
    public <T> T getSerializerOptions(Class<T> serilizerOptions, ContextURL contextUrl, boolean references) throws ContentNegotiatorException {
        if (this.hasReturnType() && serilizerOptions.isAssignableFrom(PrimitiveSerializerOptions.class)) {
            return (T)PrimitiveSerializerOptions.with().contextURL(contextUrl).nullable(Boolean.valueOf(this.getReturnType().isNullable())).maxLength(this.getReturnType().getMaxLength()).precision(this.getReturnType().getPrecision()).scale(this.getReturnType().getScale()).unicode(null).build();
        }
        return super.getSerializerOptions(serilizerOptions, contextUrl, references);
    }

    public UriResourceAction getUriResourceAction() {
        return this.uriResourceAction;
    }

    public void setUriResourceAction(UriResourceAction uriResourceAction) {
        this.uriResourceAction = uriResourceAction;
    }

    @Override
    public boolean isBound() {
        return this.uriResourceAction.getActionImport() != null;
    }

    public EdmAction getAction() {
        return this.uriResourceAction.getAction();
    }

    @Override
    public boolean isCollection() {
        assert (this.hasReturnType());
        return this.getAction().getReturnType().isCollection();
    }

    @Override
    public EdmReturnType getReturnType() {
        assert (this.hasReturnType());
        return this.getAction().getReturnType();
    }

    @Override
    public boolean hasReturnType() {
        return this.getAction().getReturnType() != null;
    }

    public InputStream getPayload() {
        return this.getODataRequest().getBody();
    }
}

