/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.requests;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ErrorHandler;
import org.apache.olingo.server.core.ServiceDispatcher;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.batchhandler.referenceRewriting.BatchReferenceRewriter;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;

public class BatchRequest
extends ServiceRequest {
    private static final String PREFERENCE_CONTINUE_ON_ERROR = "odata.continue-on-error";
    private final BatchReferenceRewriter rewriter = new BatchReferenceRewriter();

    public BatchRequest(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
    }

    @Override
    public void execute(ServiceHandler handler, ODataResponse response) throws ODataTranslatedException, ODataApplicationException {
        if (!this.allowedMethod()) {
            this.methodNotAllowed();
        }
        this.validateContentType();
        boolean continueOnError = this.isContinueOnError();
        String boundary = this.extractBoundary(this.getRequestContentType());
        BatchOptions options = BatchOptions.with().rawBaseUri(this.request.getRawBaseUri()).rawServiceResolutionUri(this.request.getRawServiceResolutionUri()).build();
        List parts = this.odata.createFixedFormatDeserializer().parseBatchRequest(this.request.getBody(), boundary, options);
        ODataResponsePart partResponse = null;
        ArrayList<ODataResponsePart> responseParts = new ArrayList<ODataResponsePart>();
        for (BatchRequestPart part : parts) {
            if (part.isChangeSet()) {
                String txnId = null;
                try {
                    txnId = handler.startTransaction();
                    partResponse = this.processChangeSet(part, handler);
                    if (((ODataResponse)partResponse.getResponses().get(0)).getStatusCode() > 400) {
                        handler.rollback(txnId);
                    }
                    handler.commit(txnId);
                }
                catch (ODataTranslatedException e) {
                    if (txnId != null) {
                        handler.rollback(txnId);
                    }
                    throw e;
                }
                catch (ODataApplicationException e) {
                    if (txnId != null) {
                        handler.rollback(txnId);
                    }
                    throw e;
                }
            } else {
                ODataRequest partRequest = (ODataRequest)part.getRequests().get(0);
                partResponse = this.process(partRequest, handler);
            }
            responseParts.add(partResponse);
            int statusCode = ((ODataResponse)partResponse.getResponses().get(0)).getStatusCode();
            if (statusCode < 400 || statusCode > 600 || continueOnError) continue;
            break;
        }
        String responseBoundary = "batch_" + UUID.randomUUID().toString();
        InputStream responseContent = this.odata.createFixedFormatSerializer().batchResponse(responseParts, responseBoundary);
        response.setHeader("Content-Type", ContentType.MULTIPART_MIXED + ";boundary=" + responseBoundary);
        response.setContent(responseContent);
        response.setStatusCode(HttpStatusCode.ACCEPTED.getStatusCode());
    }

    ODataResponsePart process(ODataRequest partRequest, ServiceHandler serviceHandler) {
        ODataResponse partResponse = this.executeSingleRequest(partRequest, serviceHandler);
        this.addContentID(partRequest, partResponse);
        return new ODataResponsePart(partResponse, false);
    }

    ODataResponsePart processChangeSet(BatchRequestPart partRequest, ServiceHandler serviceHandler) throws BatchDeserializerException {
        ArrayList<ODataResponse> changeSetResponses = new ArrayList<ODataResponse>();
        for (ODataRequest changeSetPartRequest : partRequest.getRequests()) {
            this.rewriter.replaceReference(changeSetPartRequest);
            ODataResponse partResponse = this.executeSingleRequest(changeSetPartRequest, serviceHandler);
            this.rewriter.addMapping(changeSetPartRequest, partResponse);
            this.addContentID(changeSetPartRequest, partResponse);
            if (partResponse.getStatusCode() < 400) {
                changeSetResponses.add(partResponse);
                continue;
            }
            return new ODataResponsePart(partResponse, false);
        }
        return new ODataResponsePart(changeSetResponses, true);
    }

    ODataResponse executeSingleRequest(ODataRequest singleRequest, ServiceHandler handler) {
        ServiceDispatcher dispatcher = new ServiceDispatcher(this.odata, this.serviceMetadata, handler, this.customContentType);
        ODataResponse res = new ODataResponse();
        try {
            dispatcher.execute(singleRequest, res);
        }
        catch (Exception e) {
            ErrorHandler ehandler = new ErrorHandler(this.odata, this.serviceMetadata, this.getCustomContentTypeSupport());
            ehandler.handleException(e, singleRequest, res);
        }
        return res;
    }

    private void addContentID(ODataRequest batchPartRequest, ODataResponse batchPartResponse) {
        String contentId = batchPartRequest.getHeader("Content-Id");
        if (contentId != null) {
            batchPartResponse.setHeader("Content-Id", contentId);
        }
    }

    @Override
    public boolean allowedMethod() {
        return this.isPOST();
    }

    private void validateContentType() throws ODataApplicationException {
        String contentType = this.getRequestContentType().toContentTypeString();
        if (contentType == null || !BatchParserCommon.PATTERN_MULTIPART_BOUNDARY.matcher(contentType).matches()) {
            throw new ODataApplicationException("Invalid content type", HttpStatusCode.PRECONDITION_FAILED.getStatusCode(), Locale.getDefault());
        }
    }

    @Override
    public ContentType getResponseContentType() throws ContentNegotiatorException {
        return null;
    }

    private boolean isContinueOnError() {
        List preferValues = this.request.getHeaders("Prefer");
        if (preferValues != null) {
            for (String preference : preferValues) {
                if (!PREFERENCE_CONTINUE_ON_ERROR.equals(preference)) continue;
                return true;
            }
        }
        return false;
    }

    private String extractBoundary(ContentType contentType) throws BatchDeserializerException {
        return BatchParserCommon.getBoundary((String)contentType.toContentTypeString(), (int)0);
    }
}

