/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Map;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class EntitySetResponse
extends ServiceResponse {
    private final ODataSerializer serializer;
    private final EntityCollectionSerializerOptions options;
    private final ContentType responseContentType;

    private EntitySetResponse(ServiceMetadata metadata, ODataResponse response, ODataSerializer serializer, EntityCollectionSerializerOptions options, ContentType responseContentType, Map<String, String> preferences) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.options = options;
        this.responseContentType = responseContentType;
    }

    public static EntitySetResponse getInstance(ServiceRequest request, ContextURL contextURL, boolean referencesOnly, ODataResponse response) throws ContentNegotiatorException, SerializerException {
        EntityCollectionSerializerOptions options = request.getSerializerOptions(EntityCollectionSerializerOptions.class, contextURL, referencesOnly);
        return new EntitySetResponse(request.getServiceMetaData(), response, request.getSerializer(), options, request.getResponseContentType(), request.getPreferences());
    }

    public void writeReadEntitySet(EdmEntityType entityType, EntityCollection entitySet) throws SerializerException {
        assert (!this.isClosed());
        if (entitySet == null) {
            this.writeNotFound(true);
            return;
        }
        this.response.setContent(this.serializer.entityCollection(this.metadata, entityType, entitySet, this.options).getContent());
        this.writeOK(this.responseContentType.toContentTypeString());
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataTranslatedException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writeError(ClientServerError error) {
        try {
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }
}

