/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Map;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class MetadataResponse
extends ServiceResponse {
    private final ODataSerializer serializer;
    private final ContentType responseContentType;

    public static MetadataResponse getInstance(ServiceRequest request, ODataResponse response) throws ContentNegotiatorException, SerializerException {
        return new MetadataResponse(request.getServiceMetaData(), response, request.getSerializer(), request.getResponseContentType(), request.getPreferences());
    }

    private MetadataResponse(ServiceMetadata metadata, ODataResponse response, ODataSerializer serializer, ContentType responseContentType, Map<String, String> preferences) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.responseContentType = responseContentType;
    }

    public void writeMetadata() throws ODataTranslatedException {
        assert (!this.isClosed());
        this.response.setContent(this.serializer.metadataDocument(this.metadata).getContent());
        this.writeOK(this.responseContentType.toContentTypeString());
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataTranslatedException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writeError(ClientServerError error) {
        try {
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }
}

