/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Collections;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class NoContentResponse
extends ServiceResponse {
    public NoContentResponse(ServiceMetadata metadata, ODataResponse response) {
        super(metadata, response, Collections.<String, String>emptyMap());
    }

    public void writeOK() {
        this.response.setStatusCode(HttpStatusCode.OK.getStatusCode());
        this.close();
    }

    public void writeCreated() {
        this.response.setStatusCode(HttpStatusCode.CREATED.getStatusCode());
        this.close();
    }

    public void writeAccepted() {
        this.response.setStatusCode(HttpStatusCode.ACCEPTED.getStatusCode());
        this.close();
    }

    public void writeNoContent() {
        this.writeNoContent(true);
    }

    public void writeNotModified() {
        this.response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        this.close();
    }

    public void writeNotFound() {
        this.writeNotFound(true);
    }

    public void writeNotImplemented() {
        this.response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
        this.close();
    }

    public void writeMethodNotAllowed() {
        this.response.setStatusCode(HttpStatusCode.METHOD_NOT_ALLOWED.getStatusCode());
        this.close();
    }

    public void writeGone() {
        this.response.setStatusCode(HttpStatusCode.GONE.getStatusCode());
        this.close();
    }

    public void writePreConditionFailed() {
        this.response.setStatusCode(HttpStatusCode.PRECONDITION_FAILED.getStatusCode());
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataTranslatedException, ODataApplicationException {
        visitor.visit(this);
    }
}

