/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.processor.ActionComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionComplexProcessor;
import org.apache.olingo.server.api.processor.ActionEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionEntityProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveProcessor;
import org.apache.olingo.server.api.processor.ActionVoidProcessor;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.CountPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.MediaEntityProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.processor.ReferenceCollectionProcessor;
import org.apache.olingo.server.api.processor.ReferenceProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.DefaultRedirectProcessor;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.RedirectProcessor;
import org.apache.olingo.server.core.batchhandler.BatchHandler;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class ODataHandler {
    private final OData odata;
    private final ServiceMetadata serviceMetadata;
    private List<Processor> processors = new LinkedList<Processor>();
    private CustomContentTypeSupport customContentTypeSupport = null;
    private UriInfo uriInfo;

    public ODataHandler(OData server, ServiceMetadata serviceMetadata) {
        this.odata = server;
        this.serviceMetadata = serviceMetadata;
        this.register(new DefaultRedirectProcessor());
        this.register((Processor)new DefaultProcessor());
    }

    public ODataResponse process(ODataRequest request) {
        ODataResponse response = new ODataResponse();
        try {
            this.processInternal(request, response);
        }
        catch (UriValidationException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (UriParserSemanticException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (UriParserSyntaxException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (UriParserException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (ContentNegotiatorException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (SerializerException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (DeserializerException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (ODataHandlerException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (ODataApplicationException e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError);
        }
        catch (Exception e) {
            ClientServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError);
        }
        return response;
    }

    private void processInternal(ODataRequest request, ODataResponse response) throws ODataHandlerException, UriParserException, UriValidationException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        this.validateODataVersion(request, response);
        this.uriInfo = new Parser().parseUri(request.getRawODataPath(), request.getRawQueryPath(), null, this.serviceMetadata.getEdm());
        HttpMethod method = request.getMethod();
        new UriValidator().validate(this.uriInfo, method);
        switch (this.uriInfo.getKind()) {
            case metadata: {
                this.checkMethod(method, HttpMethod.GET);
                ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.METADATA);
                this.selectProcessor(MetadataProcessor.class).readMetadata(request, response, this.uriInfo, requestedContentType);
                break;
            }
            case service: {
                this.checkMethod(method, HttpMethod.GET);
                if ("".equals(request.getRawODataPath())) {
                    this.selectProcessor(RedirectProcessor.class).redirect(request, response);
                    break;
                }
                ContentType serviceContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.SERVICE);
                this.selectProcessor(ServiceDocumentProcessor.class).readServiceDocument(request, response, this.uriInfo, serviceContentType);
                break;
            }
            case resource: {
                this.handleResourceDispatching(request, response);
                break;
            }
            case batch: {
                this.checkMethod(method, HttpMethod.POST);
                new BatchHandler(this, this.selectProcessor(BatchProcessor.class)).process(request, response, true);
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    public void handleException(ODataRequest request, ODataResponse response, ClientServerError serverError) {
        ContentType requestedContentType;
        ErrorProcessor exceptionProcessor;
        try {
            exceptionProcessor = this.selectProcessor(ErrorProcessor.class);
        }
        catch (ODataHandlerException e) {
            exceptionProcessor = new DefaultProcessor();
        }
        try {
            requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo == null ? null : this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ERROR);
        }
        catch (ContentNegotiatorException e) {
            requestedContentType = ODataFormat.JSON.getContentType();
        }
        exceptionProcessor.processError(request, response, serverError, requestedContentType);
    }

    private void handleResourceDispatching(ODataRequest request, ODataResponse response) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        int lastPathSegmentIndex = this.uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case action: {
                this.checkMethod(request.getMethod(), HttpMethod.POST);
                this.handleActionDispatching(request, response, (UriResourceAction)lastPathSegment);
                break;
            }
            case function: {
                this.checkMethod(request.getMethod(), HttpMethod.GET);
                this.handleFunctionDispatching(request, response, (UriResourceFunction)lastPathSegment);
                break;
            }
            case entitySet: 
            case navigationProperty: {
                this.handleEntityDispatching(request, response, ((UriResourcePartTyped)lastPathSegment).isCollection(), this.isMedia(lastPathSegment));
                break;
            }
            case count: {
                this.checkMethod(request.getMethod(), HttpMethod.GET);
                this.handleCountDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            case primitiveProperty: {
                this.handlePrimitiveDispatching(request, response, ((UriResourceProperty)lastPathSegment).isCollection());
                break;
            }
            case complexProperty: {
                this.handleComplexDispatching(request, response, ((UriResourceProperty)lastPathSegment).isCollection());
                break;
            }
            case value: {
                this.handleValueDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            case ref: {
                this.handleReferenceDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleFunctionDispatching(ODataRequest request, ODataResponse response, UriResourceFunction uriResourceFunction) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        EdmFunction function = uriResourceFunction.getFunction();
        if (function == null) {
            function = (EdmFunction)uriResourceFunction.getFunctionImport().getUnboundFunctions().get(0);
        }
        EdmReturnType returnType = function.getReturnType();
        switch (returnType.getType().getKind()) {
            case ENTITY: {
                this.handleEntityDispatching(request, response, returnType.isCollection() && uriResourceFunction.getKeyPredicates().isEmpty(), false);
                break;
            }
            case PRIMITIVE: {
                this.handlePrimitiveDispatching(request, response, returnType.isCollection());
                break;
            }
            case COMPLEX: {
                this.handleComplexDispatching(request, response, returnType.isCollection());
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleActionDispatching(ODataRequest request, ODataResponse response, UriResourceAction uriResourceAction) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        EdmAction action = uriResourceAction.getAction();
        EdmReturnType returnType = action.getReturnType();
        ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
        this.checkContentTypeSupport(requestFormat, RepresentationType.ACTION_PARAMETERS);
        if (returnType == null) {
            this.selectProcessor(ActionVoidProcessor.class).processActionVoid(request, response, this.uriInfo, requestFormat);
        } else {
            boolean isCollection = returnType.isCollection();
            ContentType responseFormat = null;
            switch (returnType.getType().getKind()) {
                case ENTITY: {
                    responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, isCollection ? RepresentationType.COLLECTION_ENTITY : RepresentationType.ENTITY);
                    if (isCollection) {
                        this.selectProcessor(ActionEntityCollectionProcessor.class).processActionEntityCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                        break;
                    }
                    this.selectProcessor(ActionEntityProcessor.class).processActionEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                    break;
                }
                case PRIMITIVE: {
                    responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, isCollection ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE);
                    if (isCollection) {
                        this.selectProcessor(ActionPrimitiveCollectionProcessor.class).processActionPrimitiveCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                        break;
                    }
                    this.selectProcessor(ActionPrimitiveProcessor.class).processActionPrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
                    break;
                }
                case COMPLEX: {
                    responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, isCollection ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX);
                    if (isCollection) {
                        this.selectProcessor(ActionComplexCollectionProcessor.class).processActionComplexCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                        break;
                    }
                    this.selectProcessor(ActionComplexProcessor.class).processActionComplex(request, response, this.uriInfo, requestFormat, responseFormat);
                    break;
                }
                default: {
                    throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleReferenceDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        HttpMethod method = request.getMethod();
        if (((UriResourcePartTyped)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1)).isCollection()) {
            if (method == HttpMethod.GET) {
                ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.COLLECTION_REFERENCE);
                this.selectProcessor(ReferenceCollectionProcessor.class).readReferenceCollection(request, response, this.uriInfo, responseFormat);
                return;
            } else {
                if (method != HttpMethod.POST) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
                ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
                this.checkContentTypeSupport(requestFormat, RepresentationType.REFERENCE);
                this.selectProcessor(ReferenceProcessor.class).createReference(request, response, this.uriInfo, requestFormat);
            }
            return;
        } else if (method == HttpMethod.GET) {
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.REFERENCE);
            this.selectProcessor(ReferenceProcessor.class).readReference(request, response, this.uriInfo, responseFormat);
            return;
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, RepresentationType.REFERENCE);
            this.selectProcessor(ReferenceProcessor.class).updateReference(request, response, this.uriInfo, requestFormat);
            return;
        } else {
            if (method != HttpMethod.DELETE) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            this.selectProcessor(ReferenceProcessor.class).deleteReference(request, response, this.uriInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleValueDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        HttpMethod method = request.getMethod();
        UriResource resource = (UriResource)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1);
        if (resource instanceof UriResourceProperty || resource instanceof UriResourceFunction && ((UriResourceFunction)resource).getType().getKind() == EdmTypeKind.PRIMITIVE) {
            RepresentationType valueRepresentationType;
            EdmType type = resource instanceof UriResourceProperty ? ((UriResourceProperty)resource).getType() : ((UriResourceFunction)resource).getType();
            RepresentationType representationType = valueRepresentationType = type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Binary) ? RepresentationType.BINARY : RepresentationType.VALUE;
            if (method == HttpMethod.GET) {
                ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, valueRepresentationType);
                this.selectProcessor(PrimitiveValueProcessor.class).readPrimitiveValue(request, response, this.uriInfo, requestedContentType);
                return;
            } else if (method == HttpMethod.PUT && resource instanceof UriResourceProperty) {
                ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
                this.checkContentTypeSupport(requestFormat, valueRepresentationType);
                ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, valueRepresentationType);
                this.selectProcessor(PrimitiveValueProcessor.class).updatePrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
                return;
            } else {
                if (method != HttpMethod.DELETE || !(resource instanceof UriResourceProperty)) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
                this.selectProcessor(PrimitiveValueProcessor.class).deletePrimitive(request, response, this.uriInfo);
            }
            return;
        } else if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.MEDIA);
            this.selectProcessor(MediaEntityProcessor.class).readMediaEntity(request, response, this.uriInfo, requestedContentType);
            return;
        } else if (method == HttpMethod.PUT && resource instanceof UriResourceEntitySet) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(MediaEntityProcessor.class).updateMediaEntity(request, response, this.uriInfo, requestFormat, responseFormat);
            return;
        } else {
            if (method != HttpMethod.DELETE || !(resource instanceof UriResourceEntitySet)) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            this.selectProcessor(MediaEntityProcessor.class).deleteEntity(request, response, this.uriInfo);
        }
    }

    private void handleComplexDispatching(ODataRequest request, ODataResponse response, boolean isCollection) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        RepresentationType complexRepresentationType;
        HttpMethod method = request.getMethod();
        RepresentationType representationType = complexRepresentationType = isCollection ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX;
        if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, complexRepresentationType);
            if (isCollection) {
                this.selectProcessor(ComplexCollectionProcessor.class).readComplexCollection(request, response, this.uriInfo, requestedContentType);
            } else {
                this.selectProcessor(ComplexProcessor.class).readComplex(request, response, this.uriInfo, requestedContentType);
            }
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, complexRepresentationType);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, complexRepresentationType);
            if (isCollection) {
                this.selectProcessor(ComplexCollectionProcessor.class).updateComplexCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.selectProcessor(ComplexProcessor.class).updateComplex(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.DELETE) {
            if (isCollection) {
                this.selectProcessor(ComplexCollectionProcessor.class).deleteComplexCollection(request, response, this.uriInfo);
            } else {
                this.selectProcessor(ComplexProcessor.class).deleteComplex(request, response, this.uriInfo);
            }
        } else {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
    }

    private void handlePrimitiveDispatching(ODataRequest request, ODataResponse response, boolean isCollection) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        RepresentationType representationType;
        HttpMethod method = request.getMethod();
        RepresentationType representationType2 = representationType = isCollection ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE;
        if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, representationType);
            if (isCollection) {
                this.selectProcessor(PrimitiveCollectionProcessor.class).readPrimitiveCollection(request, response, this.uriInfo, requestedContentType);
            } else {
                this.selectProcessor(PrimitiveProcessor.class).readPrimitive(request, response, this.uriInfo, requestedContentType);
            }
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, representationType);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, representationType);
            if (isCollection) {
                this.selectProcessor(PrimitiveCollectionProcessor.class).updatePrimitiveCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.selectProcessor(PrimitiveProcessor.class).updatePrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.DELETE) {
            if (isCollection) {
                this.selectProcessor(PrimitiveCollectionProcessor.class).deletePrimitiveCollection(request, response, this.uriInfo);
            } else {
                this.selectProcessor(PrimitiveProcessor.class).deletePrimitive(request, response, this.uriInfo);
            }
        } else {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
    }

    private void handleCountDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataHandlerException, ODataApplicationException, SerializerException {
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.GET) {
            UriResource resource = (UriResource)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1);
            if (resource instanceof UriResourceEntitySet || resource instanceof UriResourceNavigation || resource instanceof UriResourceFunction && ((UriResourceFunction)resource).getType().getKind() == EdmTypeKind.ENTITY) {
                this.selectProcessor(CountEntityCollectionProcessor.class).countEntityCollection(request, response, this.uriInfo);
            } else if (resource instanceof UriResourcePrimitiveProperty || resource instanceof UriResourceFunction && ((UriResourceFunction)resource).getType().getKind() == EdmTypeKind.PRIMITIVE) {
                this.selectProcessor(CountPrimitiveCollectionProcessor.class).countPrimitiveCollection(request, response, this.uriInfo);
            } else {
                this.selectProcessor(CountComplexCollectionProcessor.class).countComplexCollection(request, response, this.uriInfo);
            }
        } else {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed for count.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntityDispatching(ODataRequest request, ODataResponse response, boolean isCollection, boolean isMedia) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        HttpMethod method = request.getMethod();
        if (isCollection) {
            if (method == HttpMethod.GET) {
                ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.COLLECTION_ENTITY);
                this.selectProcessor(EntityCollectionProcessor.class).readEntityCollection(request, response, this.uriInfo, requestedContentType);
                return;
            } else {
                if (method != HttpMethod.POST) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
                ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
                ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
                if (isMedia) {
                    this.selectProcessor(MediaEntityProcessor.class).createMediaEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                    return;
                } else {
                    this.checkContentTypeSupport(requestFormat, RepresentationType.ENTITY);
                    this.selectProcessor(EntityProcessor.class).createEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                }
            }
            return;
        } else if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(EntityProcessor.class).readEntity(request, response, this.uriInfo, requestedContentType);
            return;
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, RepresentationType.ENTITY);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(EntityProcessor.class).updateEntity(request, response, this.uriInfo, requestFormat, responseFormat);
            return;
        } else {
            if (method != HttpMethod.DELETE) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            ((EntityProcessor)this.selectProcessor(isMedia ? MediaEntityProcessor.class : EntityProcessor.class)).deleteEntity(request, response, this.uriInfo);
        }
    }

    private void checkMethod(HttpMethod requestMethod, HttpMethod allowedMethod) throws ODataHandlerException {
        if (requestMethod != allowedMethod) {
            throw new ODataHandlerException("HTTP method " + requestMethod + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, requestMethod.toString());
        }
    }

    private void checkContentTypeSupport(ContentType requestFormat, RepresentationType representationType) throws ODataHandlerException, ContentNegotiatorException {
        ContentNegotiator.checkSupport(requestFormat, this.customContentTypeSupport, representationType);
    }

    private void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataHandlerException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, maxVersion);
        }
    }

    private boolean isMedia(UriResource pathSegment) {
        return pathSegment instanceof UriResourceEntitySet && ((UriResourceEntitySet)pathSegment).getEntityType().hasStream() || pathSegment instanceof UriResourceNavigation && ((EdmEntityType)((UriResourceNavigation)pathSegment).getType()).hasStream();
    }

    private <T extends Processor> T selectProcessor(Class<T> cls) throws ODataHandlerException {
        for (Processor processor : this.processors) {
            if (!cls.isAssignableFrom(processor.getClass())) continue;
            processor.init(this.odata, this.serviceMetadata);
            return (T)((Processor)cls.cast(processor));
        }
        throw new ODataHandlerException("Processor: " + cls.getSimpleName() + " not registered.", ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, cls.getSimpleName());
    }

    public void register(Processor processor) {
        this.processors.add(0, processor);
    }

    public void register(CustomContentTypeSupport customContentTypeSupport) {
        this.customContentTypeSupport = customContentTypeSupport;
    }
}

