/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.HeaderField;

public class BatchTransformatorCommon {
    public static void validateContentType(Header headers, Pattern pattern) throws BatchDeserializerException {
        List<String> contentTypes = headers.getHeaders("Content-Type");
        if (contentTypes.size() == 0) {
            throw new BatchDeserializerException("Missing content type", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TYPE, headers.getLineNumber());
        }
        if (!headers.isHeaderMatching("Content-Type", pattern)) {
            throw new BatchDeserializerException("Invalid content type", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TYPE, new String[]{"multipart/mixed or application/http"});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateContentTransferEncoding(Header headers) throws BatchDeserializerException {
        HeaderField contentTransferField = headers.getHeaderField("Content-Transfer-Encoding");
        if (contentTransferField == null) throw new BatchDeserializerException("Missing mandatory content transfer encoding", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TRANSFER_ENCODING, headers.getLineNumber());
        List<String> contentTransferValues = contentTransferField.getValues();
        if (contentTransferValues.size() != 1) throw new BatchDeserializerException("Invalid header", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_HEADER, headers.getLineNumber());
        String encoding = contentTransferValues.get(0);
        if ("binary".equalsIgnoreCase(encoding)) return;
        throw new BatchDeserializerException("Invalid content transfer encoding", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TRANSFER_ENCODING, headers.getLineNumber());
    }

    public static int getContentLength(Header headers) throws BatchDeserializerException {
        HeaderField contentLengthField = headers.getHeaderField("Content-Length");
        if (contentLengthField != null && contentLengthField.getValues().size() == 1) {
            List<String> contentLengthValues = contentLengthField.getValues();
            try {
                int contentLength = Integer.parseInt(contentLengthValues.get(0));
                if (contentLength < 0) {
                    throw new BatchDeserializerException("Invalid content length", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_LENGTH, contentLengthField.getLineNumber());
                }
                return contentLength;
            }
            catch (NumberFormatException e) {
                throw new BatchDeserializerException("Invalid header", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_HEADER, contentLengthField.getLineNumber());
            }
        }
        return -1;
    }
}

