/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.xml.MetadataDocumentXmlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataXmlSerializerImpl
implements ODataSerializer {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(ODataXmlSerializerImpl.class);

    public SerializerResultImpl serviceDocument(Edm edm, String serviceRoot) throws SerializerException {
        throw new SerializerException("Service Document not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult metadataDocument(ServiceMetadata serviceMetadata) throws SerializerException {
        XMLStreamWriter xmlStreamWriter = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(buffer.getOutputStream(), DEFAULT_CHARSET);
            MetadataDocumentXmlSerializer serializer = new MetadataDocumentXmlSerializer(serviceMetadata);
            serializer.writeMetadataDocument(xmlStreamWriter);
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
            SerializerResult serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
            return serializerResult;
        }
        catch (XMLStreamException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                }
            }
        }
    }

    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EntitySerializerOptions options) throws SerializerException {
        throw new SerializerException("Entity serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, EntityCollection entitySet, EntityCollectionSerializerOptions options) throws SerializerException {
        throw new SerializerException("Entityset serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult error(ClientServerError error) throws SerializerException {
        throw new SerializerException("error serialization not implemented for XML format", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult primitive(EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        throw new SerializerException("Serialization not implemented for XML format.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult complex(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        throw new SerializerException("Serialization not implemented for XML format.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult primitiveCollection(EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        throw new SerializerException("Serialization not implemented for XML format.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        throw new SerializerException("Serialization not implemented for XML format.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }
}

