/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;

public class UriHelperImpl
implements UriHelper {
    public String buildContextURLSelectList(EdmStructuredType type, ExpandOption expand, SelectOption select) throws SerializerException {
        return ContextURLHelper.buildSelectList(type, expand, select);
    }

    public String buildContextURLKeyPredicate(List<UriParameter> keys) throws SerializerException {
        return ContextURLHelper.buildKeyPredicate(keys);
    }

    public String buildCanonicalURL(EdmEntitySet edmEntitySet, Entity entity) throws SerializerException {
        return edmEntitySet.getName() + '(' + this.buildKeyPredicate(edmEntitySet.getEntityType(), entity) + ')';
    }

    public String buildKeyPredicate(EdmEntityType edmEntityType, Entity entity) throws SerializerException {
        StringBuilder result = new StringBuilder();
        List keyNames = edmEntityType.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode((String)keyName)).append('=');
            }
            EdmProperty edmProperty = edmEntityType.getStructuralProperty(keyName);
            EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
            Object propertyValue = entity.getProperty(keyName).getValue();
            try {
                String value = type.toUriLiteral(type.valueToString(propertyValue, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode())));
                result.append(Encoder.encode((String)value));
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong key value!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), propertyValue.toString()});
            }
        }
        return result.toString();
    }

    public List<UriParameter> getKeyPredicatesFromEntityLink(Edm edm, String entityLink, String rawServiceRoot) throws DeserializerException {
        String oDataPath = entityLink;
        if (rawServiceRoot != null && entityLink.startsWith(rawServiceRoot)) {
            oDataPath = entityLink.substring(rawServiceRoot.length());
        }
        oDataPath = oDataPath.startsWith("/") ? oDataPath : "/" + oDataPath;
        try {
            List uriResourceParts = new Parser().parseUri(oDataPath, null, null, edm).getUriResourceParts();
            if (uriResourceParts.size() == 1 && ((UriResource)uriResourceParts.get(0)).getKind() == UriResourceKind.entitySet) {
                UriResourceEntitySet entityUriResource = (UriResourceEntitySet)uriResourceParts.get(0);
                return entityUriResource.getKeyPredicates();
            }
            throw new DeserializerException("Invalid entity binding link", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY_BINDING_LINK, new String[]{entityLink});
        }
        catch (UriParserException e) {
            throw new DeserializerException("Invalid entity binding link", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY_BINDING_LINK, new String[]{entityLink});
        }
    }
}

