/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import org.apache.olingo.commons.api.format.ContentType;

public enum ODataFormat {
    JSON_NO_METADATA(ContentType.create(ContentType.APPLICATION_JSON, "odata.metadata=none")),
    JSON(ContentType.create(ContentType.APPLICATION_JSON, "odata.metadata=minimal")),
    JSON_FULL_METADATA(ContentType.create(ContentType.APPLICATION_JSON, "odata.metadata=full")),
    XML(ContentType.APPLICATION_XML),
    ATOM(ContentType.APPLICATION_ATOM_XML),
    APPLICATION_XML(ContentType.APPLICATION_XML),
    APPLICATION_ATOM_XML(ContentType.APPLICATION_ATOM_XML),
    APPLICATION_XHTML_XML(ContentType.APPLICATION_XHTML_XML),
    APPLICATION_SVG_XML(ContentType.APPLICATION_SVG_XML),
    APPLICATION_JSON(ContentType.APPLICATION_JSON),
    APPLICATION_FORM_URLENCODED(ContentType.APPLICATION_FORM_URLENCODED),
    MULTIPART_FORM_DATA(ContentType.MULTIPART_FORM_DATA),
    APPLICATION_OCTET_STREAM(ContentType.APPLICATION_OCTET_STREAM),
    TEXT_PLAIN(ContentType.TEXT_PLAIN),
    TEXT_XML(ContentType.TEXT_XML),
    TEXT_HTML(ContentType.TEXT_HTML);

    private final ContentType contentType;

    private ODataFormat(ContentType contentType) {
        this.contentType = contentType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String toString() {
        if (this.contentType == null) {
            throw new UnsupportedOperationException();
        }
        return this.contentType.toContentTypeString();
    }

    public static ODataFormat fromContentType(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_ATOM_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_SVC)) {
            return ATOM;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_XML)) {
            return XML;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            String jsonVariant = contentType.getParameters().get("odata.metadata");
            if (jsonVariant != null) {
                if ("none".equals(jsonVariant)) {
                    return JSON_NO_METADATA;
                }
                if ("minimal".equals(jsonVariant)) {
                    return JSON;
                }
                if ("full".equals(jsonVariant)) {
                    return JSON_FULL_METADATA;
                }
            }
            return JSON;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_OCTET_STREAM)) {
            return APPLICATION_OCTET_STREAM;
        }
        if (contentType.isCompatible(ContentType.TEXT_PLAIN)) {
            return TEXT_PLAIN;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_XHTML_XML)) {
            return APPLICATION_XHTML_XML;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_SVG_XML)) {
            return APPLICATION_SVG_XML;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_FORM_URLENCODED)) {
            return APPLICATION_FORM_URLENCODED;
        }
        if (contentType.isCompatible(ContentType.MULTIPART_FORM_DATA)) {
            return MULTIPART_FORM_DATA;
        }
        if (contentType.isCompatible(ContentType.TEXT_XML)) {
            return TEXT_XML;
        }
        if (contentType.isCompatible(ContentType.TEXT_HTML)) {
            return TEXT_HTML;
        }
        throw new IllegalArgumentException("Unsupported content Type: " + contentType);
    }

    public static ODataFormat fromString(String contentType) {
        return contentType == null ? null : ODataFormat.fromContentType(ContentType.parse(contentType));
    }
}

