/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api;

import java.util.List;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.edmx.EdmxReference;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;

public abstract class OData {
    private static final String IMPLEMENTATION = "org.apache.olingo.server.core.ODataImpl";

    public static OData newInstance() {
        try {
            Class<?> clazz = Class.forName(IMPLEMENTATION);
            Object object = clazz.newInstance();
            return (OData)object;
        }
        catch (Exception e) {
            throw new ODataRuntimeException(e);
        }
    }

    public abstract ODataSerializer createSerializer(ODataFormat var1) throws SerializerException;

    public abstract FixedFormatSerializer createFixedFormatSerializer();

    public abstract FixedFormatDeserializer createFixedFormatDeserializer();

    public abstract ODataHttpHandler createHandler(ServiceMetadata var1);

    public abstract ServiceMetadata createServiceMetadata(CsdlEdmProvider var1, List<EdmxReference> var2);

    public abstract UriHelper createUriHelper();

    public abstract ODataDeserializer createDeserializer(ODataFormat var1) throws DeserializerException;

    public abstract EdmPrimitiveType createPrimitiveTypeInstance(EdmPrimitiveTypeKind var1);
}

