/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotatable;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.core.edm.EdmAnnotationImpl;

public abstract class AbstractEdmAnnotatable
implements EdmAnnotatable {
    private final CsdlAnnotatable annotatable;
    private List<EdmAnnotation> annotations;
    protected final Edm edm;

    public AbstractEdmAnnotatable(Edm edm, CsdlAnnotatable annotatable) {
        this.edm = edm;
        this.annotatable = annotatable;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        EdmAnnotation result = null;
        for (EdmAnnotation annotation : this.getAnnotations()) {
            if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
            result = annotation;
        }
        return result;
    }

    public List<EdmAnnotation> getAnnotations() {
        if (this.annotations == null) {
            ArrayList<EdmAnnotationImpl> annotationsLocal = new ArrayList<EdmAnnotationImpl>();
            if (this.annotatable != null) {
                for (CsdlAnnotation annotation : this.annotatable.getAnnotations()) {
                    annotationsLocal.add(new EdmAnnotationImpl(this.edm, annotation));
                }
                this.annotations = Collections.unmodifiableList(annotationsLocal);
            }
        }
        return this.annotations;
    }
}

