/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.core.edm.EdmActionImpl;
import org.apache.olingo.commons.core.edm.EdmAnnotationImpl;
import org.apache.olingo.commons.core.edm.EdmAnnotationsImpl;
import org.apache.olingo.commons.core.edm.EdmComplexTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEntityContainerImpl;
import org.apache.olingo.commons.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImpl;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.apache.olingo.commons.core.edm.EdmTermImpl;
import org.apache.olingo.commons.core.edm.EdmTypeDefinitionImpl;

public class EdmSchemaImpl
implements EdmSchema {
    private final CsdlSchema schema;
    private final EdmProviderImpl edm;
    private final CsdlEdmProvider provider;
    protected final String namespace;
    private final String alias;
    private List<EdmEnumType> enumTypes;
    private List<EdmEntityType> entityTypes;
    private List<EdmComplexType> complexTypes;
    private List<EdmAction> actions;
    private List<EdmFunction> functions;
    private List<EdmTypeDefinition> typeDefinitions;
    private List<EdmTerm> terms;
    private List<EdmAnnotations> annotationGroups;
    private List<EdmAnnotation> annotations;
    private EdmEntityContainer entityContainer;

    public EdmSchemaImpl(EdmProviderImpl edm, CsdlEdmProvider provider, CsdlSchema schema) {
        this.edm = edm;
        this.provider = provider;
        this.schema = schema;
        this.namespace = schema.getNamespace();
        this.alias = schema.getAlias();
        if (this.alias != null) {
            edm.cacheAliasNamespaceInfo(this.alias, this.namespace);
        }
        this.enumTypes = this.createEnumTypes();
        this.typeDefinitions = this.createTypeDefinitions();
        this.entityTypes = this.createEntityTypes();
        this.complexTypes = this.createComplexTypes();
        this.actions = this.createActions();
        this.functions = this.createFunctions();
        this.entityContainer = this.createEntityContainer();
        this.annotationGroups = this.createAnnotationGroups();
        this.annotations = this.createAnnotations();
        this.terms = this.createTerms();
    }

    public List<EdmEnumType> getEnumTypes() {
        return Collections.unmodifiableList(this.enumTypes);
    }

    public List<EdmEntityType> getEntityTypes() {
        return Collections.unmodifiableList(this.entityTypes);
    }

    public List<EdmComplexType> getComplexTypes() {
        return Collections.unmodifiableList(this.complexTypes);
    }

    public List<EdmAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public List<EdmFunction> getFunctions() {
        return Collections.unmodifiableList(this.functions);
    }

    public List<EdmTypeDefinition> getTypeDefinitions() {
        return Collections.unmodifiableList(this.typeDefinitions);
    }

    public List<EdmTerm> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    public List<EdmAnnotations> getAnnotationGroups() {
        return Collections.unmodifiableList(this.annotationGroups);
    }

    public List<EdmAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public EdmEntityContainer getEntityContainer() {
        return this.entityContainer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAlias() {
        return this.alias;
    }

    protected EdmEntityContainer createEntityContainer() {
        if (this.schema.getEntityContainer() != null) {
            FullQualifiedName containerFQN = new FullQualifiedName(this.namespace, this.schema.getEntityContainer().getName());
            EdmEntityContainerImpl impl = new EdmEntityContainerImpl(this.edm, this.provider, containerFQN, this.schema.getEntityContainer());
            this.edm.cacheEntityContainer(containerFQN, impl);
            this.edm.cacheEntityContainer(null, impl);
            return impl;
        }
        return null;
    }

    protected List<EdmTypeDefinition> createTypeDefinitions() {
        ArrayList<EdmTypeDefinition> typeDefinitions = new ArrayList<EdmTypeDefinition>();
        List providerTypeDefinitions = this.schema.getTypeDefinitions();
        if (providerTypeDefinitions != null) {
            for (CsdlTypeDefinition def : providerTypeDefinitions) {
                FullQualifiedName typeDefName = new FullQualifiedName(this.namespace, def.getName());
                EdmTypeDefinitionImpl typeDefImpl = new EdmTypeDefinitionImpl((Edm)this.edm, typeDefName, def);
                typeDefinitions.add(typeDefImpl);
                this.edm.cacheTypeDefinition(typeDefName, typeDefImpl);
            }
        }
        return typeDefinitions;
    }

    protected List<EdmEnumType> createEnumTypes() {
        ArrayList<EdmEnumType> enumTypes = new ArrayList<EdmEnumType>();
        List providerEnumTypes = this.schema.getEnumTypes();
        if (providerEnumTypes != null) {
            for (CsdlEnumType enumType : providerEnumTypes) {
                FullQualifiedName enumName = new FullQualifiedName(this.namespace, enumType.getName());
                EdmEnumTypeImpl enumTypeImpl = new EdmEnumTypeImpl((Edm)this.edm, enumName, enumType);
                enumTypes.add(enumTypeImpl);
                this.edm.cacheEnumType(enumName, enumTypeImpl);
            }
        }
        return enumTypes;
    }

    protected List<EdmEntityType> createEntityTypes() {
        ArrayList<EdmEntityType> entityTypes = new ArrayList<EdmEntityType>();
        List providerEntityTypes = this.schema.getEntityTypes();
        if (providerEntityTypes != null) {
            for (CsdlEntityType entityType : providerEntityTypes) {
                FullQualifiedName entityTypeName = new FullQualifiedName(this.namespace, entityType.getName());
                EdmEntityTypeImpl entityTypeImpl = new EdmEntityTypeImpl((Edm)this.edm, entityTypeName, entityType);
                entityTypes.add(entityTypeImpl);
                this.edm.cacheEntityType(entityTypeName, entityTypeImpl);
            }
        }
        return entityTypes;
    }

    protected List<EdmComplexType> createComplexTypes() {
        ArrayList<EdmComplexType> complexTypes = new ArrayList<EdmComplexType>();
        List providerComplexTypes = this.schema.getComplexTypes();
        if (providerComplexTypes != null) {
            for (CsdlComplexType complexType : providerComplexTypes) {
                FullQualifiedName comlexTypeName = new FullQualifiedName(this.namespace, complexType.getName());
                EdmComplexTypeImpl complexTypeImpl = new EdmComplexTypeImpl((Edm)this.edm, comlexTypeName, complexType);
                complexTypes.add(complexTypeImpl);
                this.edm.cacheComplexType(comlexTypeName, complexTypeImpl);
            }
        }
        return complexTypes;
    }

    protected List<EdmAction> createActions() {
        ArrayList<EdmAction> actions = new ArrayList<EdmAction>();
        List providerActions = this.schema.getActions();
        if (providerActions != null) {
            for (CsdlAction action : providerActions) {
                FullQualifiedName actionName = new FullQualifiedName(this.namespace, action.getName());
                EdmActionImpl edmActionImpl = new EdmActionImpl((Edm)this.edm, actionName, action);
                actions.add(edmActionImpl);
                this.edm.cacheAction(actionName, edmActionImpl);
            }
        }
        return actions;
    }

    protected List<EdmFunction> createFunctions() {
        ArrayList<EdmFunction> functions = new ArrayList<EdmFunction>();
        List providerFunctions = this.schema.getFunctions();
        if (providerFunctions != null) {
            for (CsdlFunction function : providerFunctions) {
                FullQualifiedName functionName = new FullQualifiedName(this.namespace, function.getName());
                EdmFunctionImpl functionImpl = new EdmFunctionImpl((Edm)this.edm, functionName, function);
                functions.add(functionImpl);
                this.edm.cacheFunction(functionName, functionImpl);
            }
        }
        return functions;
    }

    protected List<EdmTerm> createTerms() {
        ArrayList<EdmTerm> terms = new ArrayList<EdmTerm>();
        List providerTerms = this.schema.getTerms();
        if (providerTerms != null) {
            for (CsdlTerm term : providerTerms) {
                FullQualifiedName termName = new FullQualifiedName(this.namespace, term.getName());
                EdmTermImpl termImpl = new EdmTermImpl((Edm)this.edm, this.getNamespace(), term);
                terms.add(termImpl);
                this.edm.cacheTerm(termName, termImpl);
            }
        }
        return terms;
    }

    protected List<EdmAnnotations> createAnnotationGroups() {
        ArrayList<EdmAnnotations> annotationGroups = new ArrayList<EdmAnnotations>();
        List providerAnnotations = this.schema.getAnnotationGroups();
        if (providerAnnotations != null) {
            for (CsdlAnnotations annotationGroup : providerAnnotations) {
                FullQualifiedName annotationsGroupName = annotationGroup.getTarget().contains(".") ? new FullQualifiedName(annotationGroup.getTarget()) : new FullQualifiedName(this.namespace, annotationGroup.getTarget());
                EdmAnnotationsImpl annotationsImpl = new EdmAnnotationsImpl(this.edm, this, annotationGroup);
                annotationGroups.add(annotationsImpl);
                this.edm.cacheAnnotationGroup(annotationsGroupName, annotationsImpl);
            }
        }
        return annotationGroups;
    }

    protected List<EdmAnnotation> createAnnotations() {
        ArrayList<EdmAnnotation> annotations = new ArrayList<EdmAnnotation>();
        List providerAnnotations = this.schema.getAnnotations();
        if (providerAnnotations != null) {
            for (CsdlAnnotation annotation : providerAnnotations) {
                EdmAnnotationImpl annotationImpl = new EdmAnnotationImpl((Edm)this.edm, annotation);
                annotations.add(annotationImpl);
            }
        }
        return annotations;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        EdmAnnotation result = null;
        for (EdmAnnotation annotation : this.getAnnotations()) {
            if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
            result = annotation;
        }
        return result;
    }
}

