/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.core.serialization.JsonEntityDeserializer;

public class JsonEntitySetDeserializer
extends JsonDeserializer {
    public JsonEntitySetDeserializer(boolean serverMode) {
        super(serverMode);
    }

    protected ResWrap<EntityCollection> doDeserialize(JsonParser parser) throws IOException {
        String metadataETag;
        URI contextURL;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        if (!tree.has("value")) {
            return null;
        }
        EntityCollection entitySet = new EntityCollection();
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        if (contextURL != null) {
            entitySet.setBaseURI(StringUtils.substringBefore((String)contextURL.toASCIIString(), (String)"$metadata"));
        }
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull("@odata.count")) {
            entitySet.setCount(Integer.valueOf(tree.get("@odata.count").asInt()));
            tree.remove("@odata.count");
        }
        if (tree.hasNonNull("@odata.nextLink")) {
            entitySet.setNext(URI.create(tree.get("@odata.nextLink").textValue()));
            tree.remove("@odata.nextLink");
        }
        if (tree.hasNonNull("@odata.deltaLink")) {
            entitySet.setDeltaLink(URI.create(tree.get("@odata.deltaLink").textValue()));
            tree.remove("@odata.deltaLink");
        }
        if (tree.hasNonNull("value")) {
            JsonEntityDeserializer entityDeserializer = new JsonEntityDeserializer(this.serverMode);
            for (JsonNode jsonNode : tree.get("value")) {
                entitySet.getEntities().add(entityDeserializer.doDeserialize(jsonNode.traverse(parser.getCodec())).getPayload());
            }
            tree.remove("value");
        }
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            if (((String)field.getKey()).charAt(0) != '@') continue;
            Annotation annotation = new Annotation();
            annotation.setTerm(((String)field.getKey()).substring(1));
            try {
                this.value((Valuable)annotation, (JsonNode)field.getValue(), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            entitySet.getAnnotations().add(annotation);
        }
        return new ResWrap(contextURL, metadataETag, (Object)entitySet);
    }
}

