/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.serialization.JsonEntitySerializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class JsonEntitySetSerializer
extends JsonSerializer {
    public JsonEntitySetSerializer(boolean serverMode) {
        super(serverMode);
    }

    protected void doSerialize(EntityCollection entitySet, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize((ResWrap<EntityCollection>)new ResWrap(null, null, (Object)entitySet), jgen);
    }

    protected void doContainerSerialize(ResWrap<EntityCollection> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        EntityCollection entitySet = (EntityCollection)container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode) {
            if (container.getContextURL() != null) {
                jgen.writeStringField("@odata.context", container.getContextURL().toASCIIString());
            }
            if (StringUtils.isNotBlank((CharSequence)container.getMetadataETag())) {
                jgen.writeStringField("@odata.metadataEtag", container.getMetadataETag());
            }
        }
        if (entitySet.getId() != null) {
            jgen.writeStringField("@odata.id", entitySet.getId().toASCIIString());
        }
        jgen.writeNumberField("@odata.count", entitySet.getCount() == null ? entitySet.getEntities().size() : entitySet.getCount().intValue());
        if (this.serverMode) {
            if (entitySet.getNext() != null) {
                jgen.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
            }
            if (entitySet.getDeltaLink() != null) {
                jgen.writeStringField("@odata.deltaLink", entitySet.getDeltaLink().toASCIIString());
            }
        }
        for (Annotation annotation : entitySet.getAnnotations()) {
            this.valuable(jgen, (Valuable)annotation, "@" + annotation.getTerm());
        }
        jgen.writeArrayFieldStart("value");
        JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.serverMode);
        for (Entity entity : entitySet.getEntities()) {
            entitySerializer.doSerialize(entity, jgen);
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

