/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class StreamResponse
extends ServiceResponse {
    public StreamResponse(ServiceMetadata metadata, ODataResponse response) {
        super(metadata, response, Collections.<String, String>emptyMap());
    }

    public void writeStreamResponse(InputStream streamContent, ContentType contentType) {
        this.response.setContent(streamContent);
        this.writeOK(contentType.toContentTypeString());
        this.close();
    }

    public void writeBinaryResponse(byte[] streamContent, ContentType contentType) {
        this.response.setContent((InputStream)new ByteArrayInputStream(streamContent));
        this.writeOK(contentType.toContentTypeString());
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataTranslatedException, ODataApplicationException {
        visitor.visit(this);
    }
}

