/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.batchhandler;

import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ODataHandler;
import org.apache.olingo.server.core.batchhandler.BatchFascadeImpl;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;

public class BatchHandler {
    private final BatchProcessor batchProcessor;
    private final ODataHandler oDataHandler;

    public BatchHandler(ODataHandler oDataHandler, BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
        this.oDataHandler = oDataHandler;
    }

    public void process(ODataRequest request, ODataResponse response, boolean isStrict) throws DeserializerException, SerializerException {
        this.validateRequest(request);
        BatchFascadeImpl operation = new BatchFascadeImpl(this.oDataHandler, request, this.batchProcessor, isStrict);
        this.batchProcessor.processBatch((BatchFacade)operation, request, response);
    }

    private void validateRequest(ODataRequest request) throws BatchDeserializerException {
        this.validateHttpMethod(request);
        this.validateContentType(request);
    }

    private void validateContentType(ODataRequest request) throws BatchDeserializerException {
        String contentType = request.getHeader("Content-Type");
        if (contentType == null || !BatchParserCommon.PATTERN_MULTIPART_BOUNDARY.matcher(contentType).matches()) {
            throw new BatchDeserializerException("Invalid content type", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TYPE, 0);
        }
    }

    private void validateHttpMethod(ODataRequest request) throws BatchDeserializerException {
        if (request.getMethod() != HttpMethod.POST) {
            throw new BatchDeserializerException("Invalid HTTP method", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_METHOD, 0);
        }
    }
}

