/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.ODataError;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.json.ODataErrorSerializer;
import org.apache.olingo.server.core.serializer.json.ServiceDocumentJsonSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataJsonSerializer
implements ODataSerializer {
    private static final Logger log = LoggerFactory.getLogger(ODataJsonSerializer.class);
    private final ODataFormat format;

    public ODataJsonSerializer(ODataFormat format) {
        this.format = format;
    }

    public SerializerResult serviceDocument(Edm edm, String serviceRoot) throws SerializerException {
        JsonGenerator gen = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            gen = new JsonFactory().createGenerator(buffer.getOutputStream()).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            new ServiceDocumentJsonSerializer(edm, serviceRoot).writeServiceDocument(gen);
            gen.close();
            SerializerResult serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
            return serializerResult;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            if (gen != null) {
                try {
                    gen.close();
                }
                catch (IOException e) {
                    throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                }
            }
        }
    }

    public SerializerResult metadataDocument(ServiceMetadata serviceMetadata) throws SerializerException {
        throw new SerializerException("Metadata in JSON format not supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.JSON_METADATA, new String[0]);
    }

    public SerializerResult error(ClientServerError error) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            new ODataErrorSerializer().writeErrorDocument(json, (ODataError)error);
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, EntityCollection entitySet, EntityCollectionSerializerOptions options) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (options != null && options.getCount() != null && options.getCount().getValue() && entitySet.getCount() != null) {
                json.writeNumberField("@odata.count", entitySet.getCount().intValue());
            }
            json.writeFieldName("value");
            if (options == null) {
                this.writeEntitySet(metadata, entityType, entitySet, null, null, false, json);
            } else {
                this.writeEntitySet(metadata, entityType, entitySet, options.getExpand(), options.getSelect(), options.onlyReferences(), json);
            }
            if (entitySet.getNext() != null) {
                json.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
            }
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EntitySerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            this.writeEntity(metadata, entityType, entity, contextURL, options == null ? null : options.getExpand(), options == null ? null : options.getSelect(), options == null ? false : options.onlyReferences(), json);
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    private ContextURL checkContextURL(ContextURL contextURL) throws SerializerException {
        if (this.format == ODataFormat.JSON_NO_METADATA) {
            return null;
        }
        if (contextURL == null) {
            throw new SerializerException("ContextURL null!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        return contextURL;
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, EntityCollection entitySet, ExpandOption expand, SelectOption select, boolean onlyReference, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        for (Entity entity : entitySet.getEntities()) {
            if (onlyReference) {
                json.writeStartObject();
                json.writeStringField("@odata.id", entity.getId().toASCIIString());
                json.writeEndObject();
                continue;
            }
            this.writeEntity(metadata, entityType, entity, null, expand, select, false, json);
        }
        json.writeEndArray();
    }

    protected void writeEntity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, ContextURL contextURL, ExpandOption expand, SelectOption select, boolean onlyReference, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        if (this.format != ODataFormat.JSON_NO_METADATA) {
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (entity.getETag() != null) {
                json.writeStringField("@odata.etag", entity.getETag());
            }
            if (entityType.hasStream()) {
                if (entity.getMediaETag() != null) {
                    json.writeStringField("@odata.mediaEtag", entity.getMediaETag());
                }
                if (entity.getMediaContentType() != null) {
                    json.writeStringField("@odata.mediaContentType", entity.getMediaContentType());
                }
                if (entity.getMediaContentSource() != null) {
                    json.writeStringField("@odata.mediaReadLink", entity.getMediaContentSource().toString());
                }
                if (entity.getMediaEditLinks() != null && !entity.getMediaEditLinks().isEmpty()) {
                    json.writeStringField("@odata.mediaEditLink", ((Link)entity.getMediaEditLinks().get(0)).getHref());
                }
            }
        }
        if (onlyReference) {
            json.writeStringField("@odata.id", entity.getId().toASCIIString());
        } else {
            EdmEntityType resolvedType = this.resolveEntityType(metadata, entityType, entity.getType());
            if (!resolvedType.equals(entityType)) {
                json.writeStringField("@odata.type", "#" + entity.getType());
            }
            this.writeProperties((EdmStructuredType)resolvedType, entity.getProperties(), select, json);
            this.writeNavigationProperties(metadata, (EdmStructuredType)resolvedType, (Linked)entity, expand, json);
            json.writeEndObject();
        }
    }

    protected EdmEntityType resolveEntityType(ServiceMetadata metadata, EdmEntityType baseType, String derivedTypeName) throws SerializerException {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmEntityType derivedType = metadata.getEdm().getEntityType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("EntityType not found", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNKNOWN_TYPE, new String[]{derivedTypeName});
        }
        for (EdmEntityType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().getFullQualifiedNameAsString().equals(baseType.getFullQualifiedName().getFullQualifiedNameAsString())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_BASE_TYPE, new String[]{derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    protected EdmComplexType resolveComplexType(ServiceMetadata metadata, EdmComplexType baseType, String derivedTypeName) throws SerializerException {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmComplexType derivedType = metadata.getEdm().getComplexType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("Complex Type not found", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNKNOWN_TYPE, new String[]{derivedTypeName});
        }
        for (EdmComplexType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().getFullQualifiedNameAsString().equals(baseType.getFullQualifiedName().getFullQualifiedNameAsString())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_BASE_TYPE, new String[]{derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    protected void writeProperties(EdmStructuredType type, List<Property> properties, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        boolean all = ExpandSelectHelper.isAll(select);
        Set<String> selected = all ? null : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String propertyName : type.getPropertyNames()) {
            if (!all && !selected.contains(propertyName)) continue;
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Property property = this.findProperty(propertyName, properties);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(edmProperty, property, selectedPaths, json);
        }
    }

    protected void writeNavigationProperties(ServiceMetadata metadata, EdmStructuredType type, Linked linked, ExpandOption expand, JsonGenerator json) throws SerializerException, IOException {
        if (ExpandSelectHelper.hasExpand(expand)) {
            boolean expandAll = ExpandSelectHelper.isExpandAll(expand);
            Set<String> expanded = expandAll ? null : ExpandSelectHelper.getExpandedPropertyNames(expand.getExpandItems());
            for (String propertyName : type.getNavigationPropertyNames()) {
                ExpandItem innerOptions;
                if (!expandAll && !expanded.contains(propertyName)) continue;
                EdmNavigationProperty property = type.getNavigationProperty(propertyName);
                Link navigationLink = linked.getNavigationLink(property.getName());
                ExpandItem expandItem = innerOptions = expandAll ? null : ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName);
                if (innerOptions != null && (innerOptions.isRef() || innerOptions.getLevelsOption() != null)) {
                    throw new SerializerException("Expand options $ref and $levels are not supported.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
                this.writeExpandedNavigationProperty(metadata, property, navigationLink, innerOptions == null ? null : innerOptions.getExpandOption(), innerOptions == null ? null : innerOptions.getSelectOption(), json);
            }
        }
    }

    protected void writeExpandedNavigationProperty(ServiceMetadata metadata, EdmNavigationProperty property, Link navigationLink, ExpandOption innerExpand, SelectOption innerSelect, JsonGenerator json) throws IOException, SerializerException {
        json.writeFieldName(property.getName());
        if (property.isCollection()) {
            if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                json.writeStartArray();
                json.writeEndArray();
            } else {
                this.writeEntitySet(metadata, property.getType(), navigationLink.getInlineEntitySet(), innerExpand, innerSelect, false, json);
            }
        } else if (navigationLink == null || navigationLink.getInlineEntity() == null) {
            json.writeNull();
        } else {
            this.writeEntity(metadata, property.getType(), navigationLink.getInlineEntity(), null, innerExpand, innerSelect, false, json);
        }
    }

    protected void writeProperty(EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeFieldName(edmProperty.getName());
        if (property == null || property.isNull()) {
            if (edmProperty.isNullable() == Boolean.FALSE.booleanValue()) {
                throw new SerializerException("Non-nullable property not present!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.MISSING_PROPERTY, new String[]{edmProperty.getName()});
            }
            json.writeNull();
        } else {
            this.writePropertyValue(edmProperty, property, selectedPaths, json);
        }
    }

    private void writePropertyValue(EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        block8: {
            try {
                if (edmProperty.isPrimitive()) {
                    if (edmProperty.isCollection()) {
                        this.writePrimitiveCollection((EdmPrimitiveType)edmProperty.getType(), property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    } else {
                        this.writePrimitive((EdmPrimitiveType)edmProperty.getType(), property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    }
                    break block8;
                }
                if (edmProperty.isCollection()) {
                    this.writeComplexCollection((EdmComplexType)edmProperty.getType(), property, selectedPaths, json);
                    break block8;
                }
                if (property.isComplex()) {
                    this.writeComplexValue((EdmComplexType)edmProperty.getType(), property.asComplex().getValue(), selectedPaths, json);
                    break block8;
                }
                if (property.isEnum()) {
                    this.writePrimitive((EdmPrimitiveType)edmProperty.getType(), property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    break block8;
                }
                throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), property.getValue().toString()});
            }
        }
    }

    private void writePrimitiveCollection(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, SerializerException {
        json.writeStartArray();
        block5: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: {
                    this.writePrimitiveValue(type, value, isNullable, maxLength, precision, scale, isUnicode, json);
                    continue block5;
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
                }
                case COLLECTION_ENUM: {
                    json.writeString(value.toString());
                    continue block5;
                }
            }
            throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
        }
        json.writeEndArray();
    }

    private void writeComplexCollection(EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, SerializerException {
        json.writeStartArray();
        block3: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_COMPLEX: {
                    this.writeComplexValue(type, ((ComplexValue)value).getValue(), selectedPaths, json);
                    continue block3;
                }
            }
            throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(type, property.asPrimitive(), isNullable, maxLength, precision, scale, isUnicode, json);
        } else {
            if (property.isGeospatial()) {
                throw new SerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
            }
            if (property.isEnum()) {
                this.writePrimitiveValue(type, property.asEnum(), isNullable, maxLength, precision, scale, isUnicode, json);
            } else {
                throw new SerializerException("Inconsistent property type!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, new String[]{property.getName()});
            }
        }
    }

    protected void writePrimitiveValue(EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int64) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Single)) {
            json.writeNumber(value);
        } else {
            json.writeString(value);
        }
    }

    protected void writeComplexValue(EdmComplexType type, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, SerializerException {
        json.writeStartObject();
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, propertyName)) continue;
            this.writeProperty((EdmProperty)type.getProperty(propertyName), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, propertyName), json);
        }
        json.writeEndObject();
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public SerializerResult primitive(EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (property.isNull()) {
                throw new SerializerException("Property value can not be null.", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.NULL_INPUT, new String[0]);
            }
            json.writeFieldName("value");
            this.writePrimitive(type, property, options.isNullable(), options.getMaxLength(), options.getPrecision(), options.getScale(), options.isUnicode(), json);
            json.writeEndObject();
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    public SerializerResult complex(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            EdmComplexType resolvedType;
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (!(resolvedType = this.resolveComplexType(metadata, type, property.getType())).equals(type)) {
                json.writeStringField("@odata.type", "#" + property.getType());
            }
            List values = property.isNull() ? Collections.emptyList() : property.asComplex().getValue();
            this.writeProperties((EdmStructuredType)type, values, options == null ? null : options.getSelect(), json);
            if (!property.isNull() && property.isComplex()) {
                this.writeNavigationProperties(metadata, (EdmStructuredType)type, (Linked)property.asComplex(), options == null ? null : options.getExpand(), json);
            }
            json.writeEndObject();
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    public SerializerResult primitiveCollection(EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            json.writeFieldName("value");
            this.writePrimitiveCollection(type, property, options.isNullable(), options.getMaxLength(), options.getPrecision(), options.getScale(), options.isUnicode(), json);
            json.writeEndObject();
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            json.writeFieldName("value");
            this.writeComplexCollection(type, property, null, json);
            json.writeEndObject();
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }
}

