/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGuid;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.types.DataTypeManager;

public class ODataTypeManager {
    private static HashMap<String, SingletonPrimitiveType> teiidkeyed = new HashMap();
    private static HashMap<SingletonPrimitiveType, String> odatakeyed = new HashMap();

    public static String teiidType(SingletonPrimitiveType odataType, boolean array) {
        String type = odatakeyed.get(odataType);
        if (array) {
            type = type + "[]";
        }
        return type;
    }

    public static SingletonPrimitiveType odataType(String teiidType) {
        if (DataTypeManager.isArrayType((String)teiidType)) {
            return ODataTypeManager.odataType(DataTypeManager.getComponentType((String)teiidType));
        }
        return teiidkeyed.get(teiidType);
    }

    public static Object convertToTeiidRuntimeType(Class<?> type, Object value) {
        if (value == null) {
            return null;
        }
        if (DataTypeManager.getAllDataTypeClasses().contains(value.getClass())) {
            return value;
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            Object array = Array.newInstance(type.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        return value;
    }

    static {
        teiidkeyed.put("string", (SingletonPrimitiveType)EdmString.getInstance());
        teiidkeyed.put("boolean", (SingletonPrimitiveType)EdmBoolean.getInstance());
        teiidkeyed.put("byte", (SingletonPrimitiveType)EdmByte.getInstance());
        teiidkeyed.put("short", (SingletonPrimitiveType)EdmInt16.getInstance());
        teiidkeyed.put("char", (SingletonPrimitiveType)EdmString.getInstance());
        teiidkeyed.put("integer", (SingletonPrimitiveType)EdmInt32.getInstance());
        teiidkeyed.put("long", (SingletonPrimitiveType)EdmInt64.getInstance());
        teiidkeyed.put("biginteger", (SingletonPrimitiveType)EdmInt64.getInstance());
        teiidkeyed.put("float", (SingletonPrimitiveType)EdmSingle.getInstance());
        teiidkeyed.put("double", (SingletonPrimitiveType)EdmDouble.getInstance());
        teiidkeyed.put("bigdecimal", (SingletonPrimitiveType)EdmDecimal.getInstance());
        teiidkeyed.put("date", (SingletonPrimitiveType)EdmDate.getInstance());
        teiidkeyed.put("time", (SingletonPrimitiveType)EdmTimeOfDay.getInstance());
        teiidkeyed.put("timestamp", (SingletonPrimitiveType)EdmDateTimeOffset.getInstance());
        teiidkeyed.put("object", (SingletonPrimitiveType)EdmStream.getInstance());
        teiidkeyed.put("blob", (SingletonPrimitiveType)EdmStream.getInstance());
        teiidkeyed.put("clob", (SingletonPrimitiveType)EdmStream.getInstance());
        teiidkeyed.put("xml", (SingletonPrimitiveType)EdmStream.getInstance());
        teiidkeyed.put("varbinary", (SingletonPrimitiveType)EdmBinary.getInstance());
        odatakeyed.put((SingletonPrimitiveType)EdmString.getInstance(), "string");
        odatakeyed.put((SingletonPrimitiveType)EdmBoolean.getInstance(), "boolean");
        odatakeyed.put((SingletonPrimitiveType)EdmByte.getInstance(), "short");
        odatakeyed.put((SingletonPrimitiveType)EdmSByte.getInstance(), "byte");
        odatakeyed.put((SingletonPrimitiveType)EdmInt16.getInstance(), "short");
        odatakeyed.put((SingletonPrimitiveType)EdmInt32.getInstance(), "integer");
        odatakeyed.put((SingletonPrimitiveType)EdmInt64.getInstance(), "long");
        odatakeyed.put((SingletonPrimitiveType)EdmSingle.getInstance(), "float");
        odatakeyed.put((SingletonPrimitiveType)EdmDouble.getInstance(), "double");
        odatakeyed.put((SingletonPrimitiveType)EdmDecimal.getInstance(), "bigdecimal");
        odatakeyed.put((SingletonPrimitiveType)EdmDate.getInstance(), "date");
        odatakeyed.put((SingletonPrimitiveType)EdmTimeOfDay.getInstance(), "time");
        odatakeyed.put((SingletonPrimitiveType)EdmDateTimeOffset.getInstance(), "timestamp");
        odatakeyed.put((SingletonPrimitiveType)EdmStream.getInstance(), "blob");
        odatakeyed.put((SingletonPrimitiveType)EdmGuid.getInstance(), "string");
        odatakeyed.put((SingletonPrimitiveType)EdmBinary.getInstance(), "varbinary");
    }
}

