/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.teiid.odata.api.QueryResponse;
import org.teiid.olingo.ComplexReturnType;
import org.teiid.olingo.service.CrossJoinResource;
import org.teiid.olingo.service.EntityList;
import org.teiid.olingo.service.EntityResource;

public class CrossJoinResult
implements QueryResponse {
    private final String invalidCharacterReplacement;
    private String nextToken;
    private CrossJoinResource resource;
    private List<List<ComplexReturnType>> out = new ArrayList<List<ComplexReturnType>>();

    public CrossJoinResult(String invalidCharacterReplacement, CrossJoinResource context) {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
        this.resource = context;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        ArrayList<ComplexReturnType> row = new ArrayList<ComplexReturnType>();
        Entity entity = EntityList.createEntity(rs, this.resource.getEdmEntityType(), this.resource.getAllProjectedColumns(), this.invalidCharacterReplacement);
        row.add(new ComplexReturnType(this.resource.getTable().getName(), this.resource.getEdmEntityType(), entity, this.resource.hasExpand()));
        for (EntityResource er : this.resource.getSibilings()) {
            Entity sibiling = EntityList.createEntity(rs, er.getEdmEntityType(), er.getAllProjectedColumns(), this.invalidCharacterReplacement);
            row.add(new ComplexReturnType(er.getTable().getName(), this.resource.getEdmEntityType(), sibiling, ((CrossJoinResource)er).hasExpand()));
        }
        this.out.add(row);
    }

    public CrossJoinResource getResource() {
        return this.resource;
    }

    public List<List<ComplexReturnType>> getResults() {
        return this.out;
    }

    @Override
    public long size() {
        return this.out.size();
    }

    @Override
    public void setCount(long count) {
    }

    @Override
    public void setNextToken(String token) {
        this.nextToken = token;
    }

    @Override
    public String getNextToken() {
        return this.nextToken;
    }
}

