/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.odata.api.QueryResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.service.EntityResource;
import org.teiid.olingo.service.ExpandResource;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;

public class EntityList
extends EntityCollection
implements QueryResponse {
    private final String invalidCharacterReplacement;
    private String nextToken;
    private Entity currentEntity;
    private EntityResource resource;

    public EntityList(String invalidCharacterReplacement, EntityResource resource) {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
        this.resource = resource;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        Entity entity = null;
        boolean add = true;
        if (this.currentEntity == null) {
            this.currentEntity = entity = EntityList.createEntity(rs, this.resource.getEdmEntityType(), this.resource.getAllProjectedColumns(), this.invalidCharacterReplacement);
        } else if (this.isSameRow(rs, this.resource.getAllProjectedColumns(), this.resource.getEdmEntityType(), this.currentEntity)) {
            entity = this.currentEntity;
            add = false;
        }
        if (this.resource.getExpands() != null && !this.resource.getExpands().isEmpty()) {
            for (EntityResource resource : this.resource.getExpands()) {
                ExpandResource expandResource = (ExpandResource)resource;
                Entity expand = EntityList.createEntity(rs, expandResource.getEdmEntityType(), expandResource.getProjectedColumns(), this.invalidCharacterReplacement);
                Link link = entity.getNavigationLink(expandResource.getNavigationName());
                if (expandResource.isCollection()) {
                    if (link.getInlineEntitySet() == null) {
                        link.setInlineEntitySet(new EntityCollection());
                    }
                    link.getInlineEntitySet().getEntities().add(expand);
                    continue;
                }
                link.setInlineEntity(expand);
            }
        } else if (!add) {
            EntityList.updateEntity(rs, entity, this.resource.getEdmEntityType(), this.resource.getAllProjectedColumns(), this.invalidCharacterReplacement);
        }
        if (add) {
            this.getEntities().add(entity);
        }
    }

    private boolean isSameRow(ResultSet rs, List<ProjectedColumn> projected, EdmEntityType entityType, Entity other) throws SQLException {
        for (String name : entityType.getKeyPredicateNames()) {
            ProjectedColumn pc = this.getProjectedColumn(name, projected);
            if (rs.getObject(pc.getOrdinal()).equals(other.getProperty(name).getValue())) continue;
            return false;
        }
        return true;
    }

    private ProjectedColumn getProjectedColumn(String name, List<ProjectedColumn> projected) {
        for (ProjectedColumn pc : projected) {
            String propertyName = Symbol.getShortName((Expression)pc.getExpression());
            if (!name.equals(propertyName)) continue;
            return pc;
        }
        return null;
    }

    static Entity createEntity(ResultSet rs, EdmEntityType entityType, List<ProjectedColumn> projected, String invalidChar) throws SQLException {
        LinkedHashMap<String, Link> streamProperties = new LinkedHashMap<String, Link>();
        Entity entity = new Entity();
        entity.setType(entityType.getFullQualifiedName().getFullQualifiedNameAsString());
        for (ProjectedColumn column : projected) {
            String propertyName = Symbol.getShortName((Expression)column.getExpression());
            Object value = rs.getObject(column.getOrdinal());
            try {
                SingletonPrimitiveType type = (SingletonPrimitiveType)column.getEdmType();
                if (type instanceof EdmStream) {
                    EntityList.buildStreamLink(streamProperties, value, propertyName);
                    continue;
                }
                Property property = EntityList.buildPropery(propertyName, type, column.isCollection(), value, invalidChar);
                entity.addProperty(property);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            catch (TransformationException e) {
                throw new SQLException(e);
            }
        }
        try {
            String id = EntityList.buildId(entity, entityType);
            entity.setId(new URI(id));
            for (String name : streamProperties.keySet()) {
                Link link = streamProperties.get(name);
                link.setHref(id + "/" + name);
                entity.getMediaEditLinks().add(link);
            }
            for (String name : entityType.getNavigationPropertyNames()) {
                Link navLink = new Link();
                navLink.setTitle(name);
                navLink.setHref(id + "/" + name);
                navLink.setRel("http://docs.oasis-open.org/odata/ns/related/" + name);
                entity.getNavigationLinks().add(navLink);
                Link assosiationLink = new Link();
                assosiationLink.setTitle(name);
                assosiationLink.setHref(id + "/" + name + "/$ref");
                assosiationLink.setRel("http://docs.oasis-open.org/odata/ns/relatedlinks/" + name);
                entity.getAssociationLinks().add(assosiationLink);
            }
        }
        catch (URISyntaxException e) {
            throw new SQLException(e);
        }
        return entity;
    }

    private static void updateEntity(ResultSet rs, Entity entity, EdmEntityType entityType, List<ProjectedColumn> projected, String invalidChar) throws SQLException {
        for (ProjectedColumn column : projected) {
            String propertyName = Symbol.getShortName((Expression)column.getExpression());
            if (entityType.getKeyPredicateNames().contains(propertyName)) continue;
            Object value = rs.getObject(propertyName);
            try {
                SingletonPrimitiveType type = (SingletonPrimitiveType)column.getEdmType();
                if (!column.isCollection()) continue;
                Property previousProperty = entity.getProperty(propertyName);
                Property property = EntityList.buildPropery(propertyName, type, column.isCollection(), value, invalidChar);
                property = EntityList.mergeProperties(propertyName, type, previousProperty, property);
                entity.getProperties().remove(previousProperty);
                entity.addProperty(property);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            catch (TransformationException e) {
                throw new SQLException(e);
            }
        }
    }

    private static Property mergeProperties(String propName, SingletonPrimitiveType type, Property one, Property two) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(one.asCollection());
        values.addAll(two.asCollection());
        return EntityList.createCollection(propName, (EdmPrimitiveType)type, values);
    }

    private static void buildStreamLink(LinkedHashMap<String, Link> streamProperties, Object value, String propName) {
        if (value != null) {
            Link streamLink = new Link();
            streamLink.setTitle(propName);
            if (value instanceof SQLXML) {
                streamLink.setType("application/xml");
            } else if (value instanceof Clob) {
                streamLink.setType("application/json");
            } else if (value instanceof Blob) {
                streamLink.setType("application/octet-stream");
            }
            streamLink.setRel("http://docs.oasis-open.org/odata/ns/mediaresource/" + propName);
            streamProperties.put(propName, streamLink);
        }
    }

    static Property buildPropery(String propName, SingletonPrimitiveType type, boolean isArray, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        if (value instanceof java.sql.Array) {
            value = ((java.sql.Array)value).getArray();
            int length = Array.getLength(value);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                if (o != null && o.getClass().isArray()) {
                    throw new TransformationException((BundleUtil.Event)ODataPlugin.Event.TEIID16029, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16029, new Object[]{propName}));
                }
                Object p = EntityList.getPropertyValue(type, isArray, o, invalidCharacterReplacement);
                values.add(p);
            }
            return EntityList.createCollection(propName, (EdmPrimitiveType)type, values);
        }
        if (isArray) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(EntityList.getPropertyValue(type, isArray, value, invalidCharacterReplacement));
            return EntityList.createCollection(propName, (EdmPrimitiveType)type, values);
        }
        return EntityList.createPrimitive(propName, (EdmPrimitiveType)type, EntityList.getPropertyValue(type, isArray, value, invalidCharacterReplacement));
    }

    private static Property createPrimitive(String name, EdmPrimitiveType type, Object value) {
        return new Property(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, ValueType.PRIMITIVE, value);
    }

    private static Property createCollection(String name, EdmPrimitiveType type, ArrayList<Object> values) {
        return new Property(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, ValueType.COLLECTION_PRIMITIVE, values);
    }

    static Object getPropertyValue(SingletonPrimitiveType expectedType, boolean isArray, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        Class targetType;
        if (value == null) {
            return null;
        }
        Class sourceType = DataTypeManager.getRuntimeType(value.getClass());
        if (sourceType != (targetType = DataTypeManager.getDataTypeClass((String)ODataTypeManager.teiidType(expectedType, isArray)))) {
            Transform t = DataTypeManager.getTransform((Class)sourceType, (Class)targetType);
            if (t == null && BlobType.class == targetType) {
                if (sourceType == ClobType.class) {
                    return ClobType.getString((Clob)((Clob)value)).getBytes();
                }
                if (sourceType == SQLXML.class) {
                    return ((SQLXML)value).getString().getBytes();
                }
            }
            value = t != null ? t.transform(value, targetType) : value;
            value = EntityList.replaceInvalidCharacters((EdmPrimitiveType)expectedType, value, invalidCharacterReplacement);
            return value;
        }
        value = EntityList.replaceInvalidCharacters((EdmPrimitiveType)expectedType, value, invalidCharacterReplacement);
        return value;
    }

    static Object replaceInvalidCharacters(EdmPrimitiveType expectedType, Object value, String invalidCharacterReplacement) {
        if (!(expectedType instanceof EdmString) || invalidCharacterReplacement == null) {
            return value;
        }
        if (value instanceof Character) {
            value = value.toString();
        }
        String s = (String)value;
        StringBuilder result = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= ' ' && c != ' ' && c != '\n' && c != '\t' && c != '\r') {
                if (result == null) {
                    result = new StringBuilder();
                    result.append(s.substring(0, i));
                }
                result.append(invalidCharacterReplacement);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        if (result == null) {
            return value;
        }
        return result.toString();
    }

    @Override
    public long size() {
        return this.getEntities().size();
    }

    @Override
    public void setCount(long count) {
        super.setCount(Integer.valueOf((int)count));
    }

    @Override
    public void setNextToken(String token) {
        this.nextToken = token;
    }

    @Override
    public String getNextToken() {
        return this.nextToken;
    }

    public static String buildId(Entity entity, EdmEntityType type) {
        String location = type.getName() + "(";
        int i = 0;
        boolean usename = type.getKeyPredicateNames().size() > 1;
        for (String key : type.getKeyPredicateNames()) {
            Property p;
            if (i > 0) {
                location = location + ",";
            }
            ++i;
            if (usename) {
                location = location + key + "=";
            }
            if ((p = entity.getProperty(key)).getType().equals("Edm.String")) {
                location = location + "'" + Encoder.encode((String)p.getValue().toString()) + "'";
                continue;
            }
            location = location + p.getValue().toString();
        }
        location = location + ")";
        return location;
    }
}

