/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.service.ODataExpressionToSQLVisitor;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class EntityResource {
    private Table table;
    private GroupSymbol groupSymbol;
    private EdmEntityType edmEntityType;
    private List<UriParameter> keyPredicates;
    private FromClause fromClause;
    private Criteria criteria;
    private List<ProjectedColumn> projectedColumns = new ArrayList<ProjectedColumn>();
    private List<EntityResource> sibilings = new ArrayList<EntityResource>();
    private List<EntityResource> expands = new ArrayList<EntityResource>();
    private boolean distinct;

    public static EntityResource build(EdmEntityType type, List<UriParameter> keyPredicates, MetadataStore metadata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, boolean useAlias, UriInfo uriInfo, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        EntityResource resource = new EntityResource();
        return EntityResource.build(resource, type, keyPredicates, metadata, nameGenerator, useAlias, uriInfo, parseService);
    }

    public static EntityResource build(EntityResource resource, EdmEntityType type, List<UriParameter> keyPredicates, MetadataStore metadata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, boolean useAlias, UriInfo uriInfo, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        Table table = EntityResource.findTable(type, metadata);
        GroupSymbol gs = null;
        gs = useAlias ? new GroupSymbol(nameGenerator.getNextGroup(), table.getFullName()) : new GroupSymbol(table.getFullName());
        resource.setTable(table);
        resource.setGroupSymbol(gs);
        resource.setEdmEntityType(type);
        resource.setKeyPredicates(keyPredicates);
        resource.setFromClause((FromClause)new UnaryFromClause(gs));
        if (keyPredicates != null && !keyPredicates.isEmpty()) {
            Criteria criteria = EntityResource.buildEntityKeyCriteria(resource, uriInfo, metadata, nameGenerator, parseService);
            resource.setCriteria(criteria);
        }
        return resource;
    }

    static Table findTable(EdmEntityType entityType, MetadataStore store) {
        FullQualifiedName fqn = entityType.getFullQualifiedName();
        String withoutVDB = fqn.getNamespace().substring(fqn.getNamespace().lastIndexOf(46) + 1);
        Schema schema = store.getSchema(withoutVDB);
        return schema.getTable(entityType.getName());
    }

    static Table findTable(EdmEntitySet entitySet, MetadataStore store) {
        return EntityResource.findTable(entitySet.getEntityType(), store);
    }

    static Criteria buildEntityKeyCriteria(EntityResource resource, UriInfo uriInfo, MetadataStore store, TeiidServiceHandler.UniqueNameGenerator nameGenerator, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        KeyRecord pk = resource.getTable().getPrimaryKey();
        if (resource.getKeyPredicates().size() == 1) {
            if (pk.getColumns().size() != 1) {
                throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16015, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{resource.getTable().getFullName()}));
            }
            Column column = (Column)resource.getTable().getPrimaryKey().getColumns().get(0);
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, uriInfo, store, nameGenerator, null, parseService);
            return new CompareCriteria((Expression)new ElementSymbol(column.getName(), resource.getGroupSymbol()), 1, visitor.getExpression(resource.getKeyPredicates().get(0).getExpression()));
        }
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        if (pk.getColumns().size() != resource.getKeyPredicates().size()) {
            throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16015, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{resource.getTable().getFullName()}));
        }
        for (UriParameter key : resource.getKeyPredicates()) {
            Column column = EntityResource.findColumn(resource.getTable(), key.getName());
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, uriInfo, store, nameGenerator, null, parseService);
            critList.add(new CompareCriteria((Expression)new ElementSymbol(column.getName(), resource.getGroupSymbol()), 1, visitor.getExpression(key.getExpression())));
        }
        return new CompoundCriteria(0, critList);
    }

    static Column findColumn(Table table, String propertyName) {
        return table.getColumnByName(propertyName);
    }

    public void buildEntityKeyCriteria(UriInfo uriInfo, MetadataStore metadata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        if (this.getKeyPredicates() != null && !this.getKeyPredicates().isEmpty()) {
            this.criteria = EntityResource.buildEntityKeyCriteria(this, uriInfo, metadata, nameGenerator, parseService);
        }
    }

    public EntityResource() {
    }

    public EntityResource(Table table, GroupSymbol gs, EdmEntityType type) {
        this.table = table;
        this.groupSymbol = gs;
        this.edmEntityType = type;
    }

    public Table getTable() {
        return this.table;
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public EdmEntityType getEdmEntityType() {
        return this.edmEntityType;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setGroupSymbol(GroupSymbol groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public void setEdmEntityType(EdmEntityType edmEntityType) {
        this.edmEntityType = edmEntityType;
    }

    void addAllColumns(boolean onlyPK) {
        if (onlyPK) {
            for (Column column : this.getTable().getPrimaryKey().getColumns()) {
                if (!column.isSelectable()) continue;
                this.addVisibleColumn(column.getName(), (Expression)new ElementSymbol(column.getName(), this.getGroupSymbol()));
            }
        } else {
            for (Column column : this.getTable().getColumns()) {
                if (!column.isSelectable()) continue;
                this.addVisibleColumn(column.getName(), (Expression)new ElementSymbol(column.getName(), this.getGroupSymbol()));
            }
        }
    }

    void addVisibleColumn(String columnName, Expression expr) {
        this.addProjectedColumn(columnName, expr, true);
    }

    void addProjectedColumn(String columnName, Expression expr, boolean visibility) {
        EdmPropertyImpl edmProperty = (EdmPropertyImpl)this.edmEntityType.getProperty(columnName);
        this.addProjectedColumn(expr, visibility, edmProperty.getType(), edmProperty.isCollection());
    }

    void addProjectedColumn(Expression expr, boolean visibility, EdmType type, boolean collection) {
        int i = 0;
        for (i = 0; i < this.projectedColumns.size(); ++i) {
            ProjectedColumn pc = this.projectedColumns.get(i);
            if (!pc.getExpression().equals(expr)) continue;
            this.projectedColumns.remove(i);
            break;
        }
        this.projectedColumns.add(new ProjectedColumn(expr, visibility, type, collection));
    }

    OrderBy addDefaultOrderBy() {
        OrderBy orderBy = new OrderBy();
        KeyRecord record = this.table.getPrimaryKey();
        if (record == null) {
            record = (KeyRecord)this.table.getUniqueKeys().get(0);
        }
        for (Column column : record.getColumns()) {
            ElementSymbol expr = new ElementSymbol(column.getName(), this.groupSymbol);
            orderBy.addVariable((Expression)expr);
            this.addProjectedColumn(column.getName(), (Expression)expr, false);
        }
        return orderBy;
    }

    public List<ProjectedColumn> getProjectedColumns() {
        return this.projectedColumns;
    }

    public List<ProjectedColumn> getAllProjectedColumns() {
        ArrayList<ProjectedColumn> columns = new ArrayList<ProjectedColumn>();
        columns.addAll(this.projectedColumns);
        for (EntityResource er : this.sibilings) {
            columns.addAll(er.getAllProjectedColumns());
        }
        for (EntityResource er : this.expands) {
            columns.addAll(er.getAllProjectedColumns());
        }
        return columns;
    }

    public List<UriParameter> getKeyPredicates() {
        return this.keyPredicates;
    }

    public void setKeyPredicates(List<UriParameter> keyPredicates) {
        this.keyPredicates = keyPredicates;
    }

    public void addSibiling(EntityResource resource) {
        this.sibilings.add(resource);
    }

    public List<EntityResource> getSibilings() {
        return this.sibilings;
    }

    public void addExpand(EntityResource resource) {
        this.expands.add(resource);
    }

    public List<EntityResource> getExpands() {
        return this.expands;
    }

    public Query buildQuery() {
        Select select = new Select();
        AtomicInteger ordinal = new AtomicInteger(1);
        this.addProjectedColumns(select, ordinal, this.getProjectedColumns());
        for (EntityResource sibiling : this.sibilings) {
            this.addProjectedColumns(select, ordinal, sibiling.getProjectedColumns());
        }
        for (EntityResource expand : this.expands) {
            this.addProjectedColumns(select, ordinal, expand.getProjectedColumns());
        }
        select.setDistinct(this.distinct);
        Query query = new Query();
        From from = new From();
        from.addClause(this.fromClause);
        for (EntityResource sibiling : this.sibilings) {
            from.addClause(sibiling.getFromClause());
        }
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria(this.criteria);
        return query;
    }

    private void addProjectedColumns(Select select, AtomicInteger ordinal, List<ProjectedColumn> projected) {
        for (ProjectedColumn column : projected) {
            select.addSymbol(column.getExpression());
            column.setOrdinal(ordinal.getAndIncrement());
        }
    }

    EntityResource joinTable(EntityResource joinResource, boolean isCollection, JoinType joinType) throws TeiidException {
        ForeignKey fk = null;
        fk = isCollection ? EntityResource.joinFK(joinResource.getTable(), this.getTable()) : EntityResource.joinFK(this.getTable(), joinResource.getTable());
        if (fk == null && !joinType.equals((Object)JoinType.JOIN_CROSS)) {
            throw new TeiidException("Fk not found");
        }
        Object fromClause = joinResource.getKeyPredicates() != null && joinResource.getKeyPredicates().size() > 0 ? new UnaryFromClause(joinResource.getGroupSymbol()) : EntityResource.addJoinTable(joinType, joinResource, this);
        joinResource.setFromClause((FromClause)fromClause);
        return joinResource;
    }

    static ForeignKey joinFK(Table currentTable, Table referenceTable) {
        for (ForeignKey fk : currentTable.getForeignKeys()) {
            String refSchemaName = ((Schema)((Table)fk.getReferenceKey().getParent()).getParent()).getName();
            if (!((Schema)referenceTable.getParent()).getName().equals(refSchemaName) || !referenceTable.getName().equals(fk.getReferenceTableName())) continue;
            return fk;
        }
        return null;
    }

    private static FromClause addJoinTable(JoinType joinType, EntityResource from, EntityResource to) {
        Criteria crit = null;
        if (!joinType.equals((Object)JoinType.JOIN_CROSS) && (crit = EntityResource.buildJoinCriteria(from, to)) == null) {
            crit = EntityResource.buildJoinCriteria(to, from);
        }
        return new JoinPredicate(to.getFromClause(), (FromClause)new UnaryFromClause(from.getGroupSymbol()), joinType, crit);
    }

    static Criteria buildJoinCriteria(EntityResource from, EntityResource to) {
        Criteria criteria = null;
        for (ForeignKey fk : from.getTable().getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)to.getTable())) continue;
            List<String> fkColumns = EntityResource.getColumnNames(fk.getColumns());
            if (fkColumns == null) {
                fkColumns = EntityResource.getColumnNames(from.getTable().getPrimaryKey().getColumns());
            }
            List<String> pkColumns = EntityResource.getColumnNames(to.getTable().getPrimaryKey().getColumns());
            criteria = EntityResource.buildJoinCriteria(from.getGroupSymbol(), to.getGroupSymbol(), pkColumns, fkColumns);
        }
        return criteria;
    }

    static Criteria buildJoinCriteria(GroupSymbol joinGroup, GroupSymbol entityGroup, List<String> pkColumns, List<String> refColumns) {
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        for (int i = 0; i < refColumns.size(); ++i) {
            critList.add(new CompareCriteria((Expression)new ElementSymbol(pkColumns.get(i), entityGroup), 1, (Expression)new ElementSymbol(refColumns.get(i), joinGroup)));
        }
        Criteria crit = (Criteria)critList.get(0);
        for (int i = 1; i < critList.size(); ++i) {
            crit = new CompoundCriteria(0, crit, (Criteria)critList.get(i));
        }
        return crit;
    }

    static List<String> getColumnNames(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public void addCriteria(Criteria criteria) {
        if (criteria != null) {
            this.criteria = this.criteria == null ? criteria : new CompoundCriteria(0, this.criteria, criteria);
        }
    }

    public String toString() {
        return this.table.getFullName();
    }
}

