/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;

public class OData4EntitySchemaBuilder {
    public static CsdlSchema buildMetadata(String namespace, Schema teiidSchema) {
        try {
            CsdlSchema edmSchema = new CsdlSchema();
            OData4EntitySchemaBuilder.buildEntityTypes(namespace, teiidSchema, edmSchema);
            OData4EntitySchemaBuilder.buildProcedures(teiidSchema, edmSchema);
            return edmSchema;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static CsdlEntitySet findEntitySet(CsdlSchema edmSchema, String enitityName) {
        CsdlEntityContainer entityContainter = edmSchema.getEntityContainer();
        for (CsdlEntitySet entitySet : entityContainter.getEntitySets()) {
            if (!entitySet.getName().equalsIgnoreCase(enitityName)) continue;
            return entitySet;
        }
        return null;
    }

    static CsdlSchema findSchema(Map<String, CsdlSchema> edmSchemas, String schemaName) {
        return edmSchemas.get(schemaName);
    }

    static CsdlEntityType findEntityType(Map<String, CsdlSchema> edmSchemas, String schemaName, String enitityName) {
        CsdlSchema schema = OData4EntitySchemaBuilder.findSchema(edmSchemas, schemaName);
        if (schema != null) {
            for (CsdlEntityType type : schema.getEntityTypes()) {
                if (!type.getName().equalsIgnoreCase(enitityName)) continue;
                return type;
            }
        }
        return null;
    }

    static CsdlEntityContainer findEntityContainer(Map<String, CsdlSchema> edmSchemas, String schemaName) {
        CsdlSchema schema = edmSchemas.get(schemaName);
        return schema.getEntityContainer();
    }

    static void buildEntityTypes(String namespace, Schema schema, CsdlSchema edmSchema) {
        LinkedHashMap<String, CsdlEntitySet> entitySets = new LinkedHashMap<String, CsdlEntitySet>();
        LinkedHashMap<String, CsdlEntityType> entityTypes = new LinkedHashMap<String, CsdlEntityType>();
        String fullSchemaName = namespace + "." + schema.getName();
        for (Table table : schema.getTables().values()) {
            Object c;
            KeyRecord primaryKey = OData4EntitySchemaBuilder.getIdentifier(table);
            if (primaryKey == null) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{table.getFullName()}));
                continue;
            }
            String entityTypeName = table.getName();
            CsdlEntityType entityType = new CsdlEntityType().setName(entityTypeName);
            ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
            Iterator iterator = table.getColumns().iterator();
            while (iterator.hasNext()) {
                properties.add(OData4EntitySchemaBuilder.buildProperty((Column)c, OData4EntitySchemaBuilder.isPartOfPrimaryKey(table, (c = (Column)iterator.next()).getName()) ? false : c.getNullType() == BaseColumn.NullType.Nullable));
            }
            entityType.setProperties(properties);
            if (OData4EntitySchemaBuilder.hasStream(properties)) {
                entityType.setHasStream(true);
            }
            ArrayList<CsdlPropertyRef> keyProps = new ArrayList<CsdlPropertyRef>();
            c = primaryKey.getColumns().iterator();
            while (c.hasNext()) {
                Column c2 = (Column)c.next();
                keyProps.add(new CsdlPropertyRef().setName(c2.getName()));
            }
            entityType.setKey(keyProps);
            CsdlEntitySet entitySet = new CsdlEntitySet().setName(table.getName()).setType(new FullQualifiedName(fullSchemaName, table.getName())).setIncludeInServiceDocument(true);
            entityTypes.put(entityTypeName, entityType);
            entitySets.put(entityTypeName, entitySet);
        }
        OData4EntitySchemaBuilder.buildNavigationProperties(schema, entityTypes, entitySets);
        CsdlEntityContainer entityContainer = new CsdlEntityContainer().setName(schema.getName()).setEntitySets(new ArrayList(entitySets.values()));
        edmSchema.setNamespace(fullSchemaName).setAlias(schema.getName()).setEntityTypes(new ArrayList(entityTypes.values())).setEntityContainer(entityContainer);
    }

    private static boolean hasStream(List<CsdlProperty> properties) {
        for (CsdlProperty p : properties) {
            if (!p.getType().equals(EdmPrimitiveTypeKind.Binary.getFullQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static CsdlProperty buildProperty(Column c, boolean nullable) {
        CsdlProperty property = new CsdlProperty().setName(c.getName()).setType(ODataTypeManager.odataType(c.getRuntimeType()).getFullQualifiedName()).setNullable(nullable);
        if (DataTypeManager.isArrayType((String)c.getRuntimeType())) {
            property.setCollection(true);
        }
        if (c.getRuntimeType().equals("string")) {
            property.setMaxLength(Integer.valueOf(c.getLength())).setUnicode(true);
        } else if (c.getRuntimeType().equals("double") || c.getRuntimeType().equals("float") || c.getRuntimeType().equals("bigdecimal")) {
            property.setPrecision(Integer.valueOf(c.getPrecision()));
            property.setScale(Integer.valueOf(c.getScale()));
        } else if (c.getDefaultValue() != null) {
            property.setDefaultValue(c.getDefaultValue());
        }
        return property;
    }

    static boolean isPartOfPrimaryKey(Table table, String columnName) {
        KeyRecord pk = table.getPrimaryKey();
        if (OData4EntitySchemaBuilder.hasColumn(pk, columnName)) {
            return true;
        }
        for (KeyRecord key : table.getUniqueKeys()) {
            if (!OData4EntitySchemaBuilder.hasColumn(key, columnName)) continue;
            return true;
        }
        return false;
    }

    static boolean hasColumn(KeyRecord pk, String columnName) {
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!SQLStringVisitor.getRecordName((AbstractMetadataRecord)column).equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    private static KeyRecord getIdentifier(Table table) {
        if (table.getPrimaryKey() != null) {
            return table.getPrimaryKey();
        }
        Iterator iterator = table.getUniqueKeys().iterator();
        if (iterator.hasNext()) {
            KeyRecord key = (KeyRecord)iterator.next();
            return key;
        }
        return null;
    }

    private static void buildNavigationProperties(Schema schema, Map<String, CsdlEntityType> entityTypes, Map<String, CsdlEntitySet> entitySets) {
        for (Table table : schema.getTables().values()) {
            if (OData4EntitySchemaBuilder.getIdentifier(table) == null) continue;
            for (ForeignKey fk : table.getForeignKeys()) {
                boolean onetoone = OData4EntitySchemaBuilder.sameColumnSet(OData4EntitySchemaBuilder.getIdentifier(table), (KeyRecord)fk);
                CsdlNavigationProperty navigaton = null;
                CsdlNavigationPropertyBinding navigationBinding = null;
                String entityTypeName = null;
                if (onetoone) {
                    entityTypeName = table.getName();
                    navigaton = OData4EntitySchemaBuilder.buildNavigation(fk);
                    navigationBinding = OData4EntitySchemaBuilder.buildNavigationBinding(fk);
                    navigaton.setNullable(Boolean.valueOf(false));
                } else {
                    entityTypeName = fk.getReferenceTableName();
                    navigaton = OData4EntitySchemaBuilder.buildReverseNavigation(table, fk);
                    navigationBinding = OData4EntitySchemaBuilder.buildReverseNavigationBinding(table, fk);
                    navigaton.setCollection(true);
                }
                CsdlEntityType entityType = entityTypes.get(entityTypeName);
                entityType.getNavigationProperties().add(navigaton);
                CsdlEntitySet entitySet = entitySets.get(entityTypeName);
                entitySet.getNavigationPropertyBindings().add(navigationBinding);
            }
        }
    }

    private static CsdlNavigationPropertyBinding buildNavigationBinding(ForeignKey fk) {
        CsdlNavigationPropertyBinding navigationBinding = new CsdlNavigationPropertyBinding();
        navigationBinding.setPath(fk.getName());
        navigationBinding.setTarget(fk.getReferenceTableName());
        return navigationBinding;
    }

    private static CsdlNavigationPropertyBinding buildReverseNavigationBinding(Table table, ForeignKey fk) {
        CsdlNavigationPropertyBinding navigationBinding = new CsdlNavigationPropertyBinding();
        navigationBinding.setPath(table.getName() + "_" + fk.getName());
        navigationBinding.setTarget(table.getName());
        return navigationBinding;
    }

    private static CsdlNavigationProperty buildNavigation(ForeignKey fk) {
        String refSchemaName = ((Schema)((Table)fk.getReferenceKey().getParent()).getParent()).getName();
        CsdlNavigationProperty navigaton = new CsdlNavigationProperty();
        navigaton.setName(fk.getName()).setType(new FullQualifiedName(refSchemaName, fk.getReferenceTableName()));
        ArrayList constrainsts = new ArrayList();
        for (int i = 0; i < fk.getColumns().size(); ++i) {
            Column c = (Column)fk.getColumns().get(i);
            String refColumn = (String)fk.getReferenceColumns().get(i);
            CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
            constraint.setProperty(c.getName());
            constraint.setReferencedProperty(refColumn);
        }
        navigaton.setReferentialConstraints(constrainsts);
        return navigaton;
    }

    private static CsdlNavigationProperty buildReverseNavigation(Table table, ForeignKey fk) {
        String refSchemaName = ((Schema)table.getParent()).getName();
        CsdlNavigationProperty navigaton = new CsdlNavigationProperty();
        navigaton.setName(table.getName() + "_" + fk.getName()).setType(new FullQualifiedName(refSchemaName, table.getName()));
        ArrayList constrainsts = new ArrayList();
        for (int i = 0; i < fk.getColumns().size(); ++i) {
            Column c = (Column)fk.getColumns().get(i);
            String refColumn = (String)fk.getReferenceColumns().get(i);
            CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
            constraint.setProperty(refColumn);
            constraint.setReferencedProperty(c.getName());
        }
        navigaton.setReferentialConstraints(constrainsts);
        return navigaton;
    }

    static void buildProcedures(Schema schema, CsdlSchema edmSchema) {
        ArrayList<CsdlComplexType> complexTypes = new ArrayList<CsdlComplexType>();
        ArrayList<CsdlFunction> functions = new ArrayList<CsdlFunction>();
        ArrayList<CsdlFunctionImport> functionImports = new ArrayList<CsdlFunctionImport>();
        ArrayList<CsdlAction> actions = new ArrayList<CsdlAction>();
        ArrayList<CsdlActionImport> actionImports = new ArrayList<CsdlActionImport>();
        for (Procedure proc : schema.getProcedures().values()) {
            if (!OData4EntitySchemaBuilder.allowedProcedure(proc)) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16032, new Object[]{proc.getFullName()}));
                continue;
            }
            if (OData4EntitySchemaBuilder.isFuntion(proc)) {
                OData4EntitySchemaBuilder.buildFunction(schema.getName(), proc, complexTypes, functions, functionImports);
                continue;
            }
            OData4EntitySchemaBuilder.buildAction(schema.getName(), proc, complexTypes, actions, actionImports);
        }
        edmSchema.setComplexTypes(complexTypes);
        edmSchema.setFunctions(functions);
        edmSchema.setActions(actions);
        edmSchema.getEntityContainer().setFunctionImports(functionImports);
        edmSchema.getEntityContainer().setActionImports(actionImports);
    }

    private static boolean doesProcedureReturn(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            return true;
        }
        return proc.getResultSet() != null;
    }

    private static boolean allowedProcedure(Procedure proc) {
        int inouts = 0;
        int lobs = 0;
        int outs = 0;
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType().equals((Object)ProcedureParameter.Type.In) || pp.getType().equals((Object)ProcedureParameter.Type.InOut)) {
                ++inouts;
                if (DataTypeManager.isLOB((String)pp.getRuntimeType())) {
                    ++lobs;
                }
            }
            if (pp.getType().equals((Object)ProcedureParameter.Type.Out) || pp.getType().equals((Object)ProcedureParameter.Type.InOut)) {
                return false;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            ++outs;
        }
        if (proc.getResultSet() != null) {
            ++outs;
        }
        if (outs > 1) {
            return false;
        }
        return inouts <= true || lobs < true;
    }

    private static boolean isInputParameterLob(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue) || !DataTypeManager.isLOB((String)pp.getRuntimeType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFuntion(Procedure proc) {
        return OData4EntitySchemaBuilder.doesProcedureReturn(proc) && proc.getUpdateCount() == 0 && !OData4EntitySchemaBuilder.isInputParameterLob(proc);
    }

    static void buildFunction(String schemaName, Procedure proc, ArrayList<CsdlComplexType> complexTypes, ArrayList<CsdlFunction> functions, ArrayList<CsdlFunctionImport> functionImports) {
        SingletonPrimitiveType odataType;
        CsdlFunction edmFunction = new CsdlFunction();
        edmFunction.setName(proc.getName());
        edmFunction.setBound(false);
        ArrayList<CsdlParameter> params = new ArrayList<CsdlParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            odataType = ODataTypeManager.odataType(pp.getRuntimeType());
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) {
                edmFunction.setReturnType(new CsdlReturnType().setType(odataType.getFullQualifiedName()));
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.In) && !pp.getType().equals((Object)ProcedureParameter.Type.InOut)) continue;
            params.add(OData4EntitySchemaBuilder.buildParameter(pp, odataType));
        }
        edmFunction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            List columns = returnColumns.getColumns();
            if (columns.size() == 1 && DataTypeManager.isLOB((Class)((Column)columns.get(0)).getJavaType())) {
                odataType = ODataTypeManager.odataType(((Column)columns.get(0)).getRuntimeType());
                edmFunction.setReturnType(new CsdlReturnType().setType(odataType.getFullQualifiedName()));
            } else {
                CsdlComplexType complexType = OData4EntitySchemaBuilder.buildComplexType(proc, (ColumnSet<Procedure>)returnColumns);
                complexTypes.add(complexType);
                FullQualifiedName odataType2 = new FullQualifiedName(schemaName, complexType.getName());
                edmFunction.setReturnType(new CsdlReturnType().setType(odataType2).setCollection(true));
            }
        }
        CsdlFunctionImport functionImport = new CsdlFunctionImport();
        functionImport.setName(proc.getName()).setFunction(new FullQualifiedName(schemaName, proc.getName()));
        functions.add(edmFunction);
        functionImports.add(functionImport);
    }

    private static CsdlParameter buildParameter(ProcedureParameter pp, SingletonPrimitiveType odatatype) {
        CsdlParameter param = new CsdlParameter();
        param.setName(pp.getName());
        param.setType(odatatype.getFullQualifiedName());
        if (DataTypeManager.isArrayType((String)pp.getRuntimeType())) {
            param.setCollection(true);
        }
        param.setNullable(pp.getNullType() == BaseColumn.NullType.Nullable);
        if (pp.getRuntimeType().equals("string")) {
            param.setMaxLength(Integer.valueOf(pp.getLength()));
        } else if (pp.getRuntimeType().equals("double") || pp.getRuntimeType().equals("float") || pp.getRuntimeType().equals("bigdecimal")) {
            param.setPrecision(Integer.valueOf(pp.getPrecision()));
            param.setScale(Integer.valueOf(pp.getScale()));
        } else if (pp.getDefaultValue() != null) {
            // empty if block
        }
        return param;
    }

    static void buildAction(String schemaName, Procedure proc, ArrayList<CsdlComplexType> complexTypes, ArrayList<CsdlAction> actions, ArrayList<CsdlActionImport> actionImports) {
        CsdlAction edmAction = new CsdlAction();
        edmAction.setName(proc.getName());
        edmAction.setBound(false);
        ArrayList<CsdlParameter> params = new ArrayList<CsdlParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            SingletonPrimitiveType odatatype = ODataTypeManager.odataType(pp.getRuntimeType());
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) {
                edmAction.setReturnType(new CsdlReturnType().setType(odatatype.getFullQualifiedName()));
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.In) && !pp.getType().equals((Object)ProcedureParameter.Type.InOut)) continue;
            params.add(OData4EntitySchemaBuilder.buildParameter(pp, odatatype));
        }
        edmAction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            List columns = returnColumns.getColumns();
            if (columns.size() == 1 && DataTypeManager.isLOB((Class)((Column)columns.get(0)).getJavaType())) {
                SingletonPrimitiveType odataType = ODataTypeManager.odataType(((Column)columns.get(0)).getRuntimeType());
                edmAction.setReturnType(new CsdlReturnType().setType(odataType.getFullQualifiedName()));
            } else {
                CsdlComplexType complexType = OData4EntitySchemaBuilder.buildComplexType(proc, (ColumnSet<Procedure>)returnColumns);
                complexTypes.add(complexType);
                edmAction.setReturnType(new CsdlReturnType().setType(new FullQualifiedName(schemaName, complexType.getName())).setCollection(true));
            }
        }
        CsdlActionImport actionImport = new CsdlActionImport();
        actionImport.setName(proc.getName()).setAction(new FullQualifiedName(schemaName, proc.getName()));
        actions.add(edmAction);
        actionImports.add(actionImport);
    }

    private static CsdlComplexType buildComplexType(Procedure proc, ColumnSet<Procedure> returnColumns) {
        CsdlComplexType complexType = new CsdlComplexType();
        String entityTypeName = proc.getName() + "_" + returnColumns.getName();
        complexType.setName(entityTypeName);
        ArrayList<CsdlProperty> props = new ArrayList<CsdlProperty>();
        Iterator iterator = returnColumns.getColumns().iterator();
        while (iterator.hasNext()) {
            Column c;
            props.add(OData4EntitySchemaBuilder.buildProperty(c, (c = (Column)iterator.next()).getNullType() == BaseColumn.NullType.Nullable));
        }
        complexType.setProperties(props);
        return complexType;
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    static boolean sameColumnSet(KeyRecord recordOne, KeyRecord recordTwo) {
        if (recordOne == null || recordTwo == null) {
            return false;
        }
        List setOne = recordOne.getColumns();
        List setTwo = recordTwo.getColumns();
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (int i = 0; i < setOne.size(); ++i) {
            Column one = (Column)setOne.get(i);
            Column two = (Column)setTwo.get(i);
            if (one.getName().equals(two.getName())) continue;
            return false;
        }
        return true;
    }
}

