/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoAll;
import org.apache.olingo.server.api.uri.UriInfoBatch;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoEntityId;
import org.apache.olingo.server.api.uri.UriInfoMetadata;
import org.apache.olingo.server.api.uri.UriInfoService;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceIt;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceRef;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.core.RequestURLHierarchyVisitor;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.olingo.service.CrossJoinResource;
import org.teiid.olingo.service.EntityResource;
import org.teiid.olingo.service.ExpandResource;
import org.teiid.olingo.service.ExpandSQLBuilder;
import org.teiid.olingo.service.ODataExpressionToSQLVisitor;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;

public class ODataSQLBuilder
extends RequestURLHierarchyVisitor {
    private final MetadataStore metadata;
    private boolean prepared = true;
    private final ArrayList<SQLParameter> params = new ArrayList();
    private final ArrayList<TeiidException> exceptions = new ArrayList();
    private EntityResource context;
    private SkipOption skipOption;
    private TopOption topOption;
    private boolean countOption;
    private OrderBy orderBy;
    private boolean selectionComplete;
    private String nextToken;
    private boolean aliasedGroups;
    private boolean countQuery = false;
    private boolean reference = false;
    private String baseURI;
    private ServiceMetadata serviceMetadata;
    private TeiidServiceHandler.UniqueNameGenerator nameGenerator;
    private ExpandOption expandOption;
    private URLParseService parseService;

    public ODataSQLBuilder(MetadataStore metadata, boolean prepared, boolean aliasedGroups, String baseURI, ServiceMetadata serviceMetadata, TeiidServiceHandler.UniqueNameGenerator nameGenerator) {
        this.metadata = metadata;
        this.prepared = prepared;
        this.aliasedGroups = aliasedGroups;
        this.baseURI = baseURI;
        this.serviceMetadata = serviceMetadata;
        this.nameGenerator = nameGenerator;
        this.parseService = new URLParseService();
    }

    public EntityResource getContext() {
        return this.context;
    }

    public boolean includeTotalSize() {
        return this.countOption;
    }

    public Integer getSkip() {
        if (this.skipOption == null) {
            return null;
        }
        return this.skipOption.getValue();
    }

    public Integer getTop() {
        if (this.topOption == null) {
            return null;
        }
        return this.topOption.getValue();
    }

    public Query selectQuery() throws TeiidException {
        if (this.expandOption != null) {
            this.processExpandOption(this.expandOption);
        }
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
        Query query = this.context.buildQuery();
        if (this.countQuery) {
            AggregateSymbol aggregateSymbol = new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null);
            Select select = new Select(Arrays.asList(aggregateSymbol));
            query.setSelect(select);
        }
        if (this.orderBy != null & !this.countQuery) {
            query.setOrderBy(this.orderBy);
        }
        return query;
    }

    private void processExpandOption(ExpandOption option) {
        if (option.getExpandItems().size() > 1) {
            this.exceptions.add(new TeiidException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16042, new Object[0])));
            return;
        }
        for (ExpandItem ei : option.getExpandItems()) {
            try {
                ExpandSQLBuilder esb = new ExpandSQLBuilder(ei);
                EdmNavigationProperty property = esb.getNavigationProperty();
                ExpandResource expandResource = ExpandResource.buildExpand(property, this.metadata, this.nameGenerator, true, this.getUriInfo(), this.parseService);
                this.context.joinTable(expandResource, property.isCollection(), JoinType.JOIN_LEFT_OUTER);
                if (ei.getFilterOption() != null) {
                    Criteria expandCriteria = this.processFilterOption(ei.getFilterOption(), expandResource);
                    expandResource.addCriteria(expandCriteria);
                }
                this.context.addCriteria(expandResource.getCriteria());
                this.context.setFromClause(expandResource.getFromClause());
                if (ei.getOrderByOption() != null) {
                    if (this.orderBy == null) {
                        this.orderBy = new OrderBy();
                    }
                    this.processOrderBy(this.orderBy, ei.getOrderByOption().getOrders(), expandResource);
                }
                this.processSelectOption(ei.getSelectOption(), expandResource, this.reference);
                this.context.addExpand(expandResource);
            }
            catch (TeiidException e) {
                this.exceptions.add(e);
            }
            if (ei.getSkipOption() == null && ei.getCountOption() == null && ei.getTopOption() == null && ei.getLevelsOption() == null) continue;
            this.exceptions.add(new TeiidException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16041, new Object[0])));
        }
    }

    private Criteria processFilterOption(FilterOption option, EntityResource resource) {
        ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, this.prepared, this.getUriInfo(), this.metadata, this.nameGenerator, this.params, this.parseService);
        Criteria filterCriteria = null;
        try {
            filterCriteria = (Criteria)visitor.getExpression(option.getExpression());
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
        return filterCriteria;
    }

    public List<SQLParameter> getParameters() {
        return this.params;
    }

    public void visit(UriResourceEntitySet info) {
        try {
            this.context = EntityResource.build(info.getEntitySet().getEntityType(), info.getKeyPredicates(), this.metadata, this.nameGenerator, this.aliasedGroups, this.getUriInfo(), this.parseService);
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(SkipOption option) {
        this.skipOption = option;
    }

    public void visit(TopOption option) {
        this.topOption = option;
    }

    public void visit(CountOption info) {
        this.countOption = info.getValue();
    }

    public void visit(SelectOption option) {
        if (this.selectionComplete) {
            return;
        }
        this.processSelectOption(option, this.context, this.reference);
    }

    private void processSelectOption(SelectOption option, EntityResource resource, boolean onlyReference) {
        if (option == null) {
            resource.addAllColumns(onlyReference);
        } else {
            for (SelectItem si : option.getSelectItems()) {
                if (si.isStar()) {
                    resource.addAllColumns(onlyReference);
                    continue;
                }
                try {
                    ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, this.getUriInfo(), this.metadata, this.nameGenerator, this.params, this.parseService);
                    ElementSymbol expr = (ElementSymbol)visitor.getExpression(si.getResourcePath());
                    resource.addVisibleColumn(expr.getShortName(), (Expression)expr);
                }
                catch (TeiidException e) {
                    this.exceptions.add(e);
                }
            }
        }
    }

    public void visit(OrderByOption option) {
        if (option == null || option.getOrders().isEmpty()) {
            this.orderBy = this.context.addDefaultOrderBy();
        } else {
            List orderBys = option.getOrders();
            this.orderBy = this.processOrderBy(new OrderBy(), orderBys, this.context);
        }
    }

    private OrderBy processOrderBy(OrderBy orderBy, List<OrderByItem> orderByItems, EntityResource resource) {
        for (OrderByItem obitem : orderByItems) {
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, this.getUriInfo(), this.metadata, this.nameGenerator, this.params, this.parseService);
            try {
                Expression expr = visitor.getExpression(obitem.getExpression());
                if (expr instanceof ElementSymbol) {
                    orderBy.addVariable(expr, !obitem.isDescending());
                    visitor.getExpresionEntityResource().addProjectedColumn(((ElementSymbol)expr).getShortName(), expr, false);
                    continue;
                }
                AliasSymbol alias = new AliasSymbol("_orderByAlias", expr);
                orderBy.addVariable((Expression)alias, !obitem.isDescending());
                visitor.getExpresionEntityResource().addProjectedColumn((Expression)alias, false, (EdmType)EdmInt32.getInstance(), false);
            }
            catch (TeiidException e) {
                this.exceptions.add(e);
            }
        }
        return orderBy;
    }

    public void visit(FilterOption info) {
        ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this.context, this.prepared, this.getUriInfo(), this.metadata, this.nameGenerator, this.params, this.parseService);
        Criteria filterCriteria = null;
        try {
            filterCriteria = (Criteria)visitor.getExpression(info.getExpression());
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
        this.context = visitor.getEntityResource();
        this.context.addCriteria(filterCriteria);
    }

    public void visit(UriResourceNavigation info) {
        EdmNavigationProperty property = info.getProperty();
        try {
            EntityResource joinResource = EntityResource.build(property.getType(), info.getKeyPredicates(), this.metadata, this.nameGenerator, true, this.getUriInfo(), this.parseService);
            this.context.joinTable(joinResource, property.isCollection(), JoinType.JOIN_INNER);
            if (joinResource.getCriteria() == null) {
                joinResource.addCriteria(this.context.getCriteria());
            }
            this.context = joinResource;
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(UriResourcePrimitiveProperty info) {
        String propertyName = info.getProperty().getName();
        ElementSymbol es = new ElementSymbol(propertyName, this.context.getGroupSymbol());
        this.context.addVisibleColumn(propertyName, (Expression)es);
        this.selectionComplete = true;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void visit(SkipTokenOption option) {
        if (option != null) {
            this.nextToken = option.getValue();
        }
    }

    public void visit(SearchOption option) {
        this.exceptions.add(new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16035, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16035, new Object[0])));
    }

    public Insert insert(EdmEntityType entityType, Entity entity, boolean prepared) {
        Table entityTable = this.findTable(entityType.getName(), this.metadata);
        EntityResource resource = new EntityResource(entityTable, new GroupSymbol(entityTable.getFullName()), entityType);
        ArrayList<Reference> referenceValues = new ArrayList<Reference>();
        ArrayList<Constant> constantValues = new ArrayList<Constant>();
        Insert insert = new Insert();
        insert.setGroup(resource.getGroupSymbol());
        int i = 0;
        for (Property prop : entity.getProperties()) {
            EdmProperty edmProp = (EdmProperty)entityType.getProperty(prop.getName());
            Column column = entityTable.getColumnByName(edmProp.getName());
            insert.addVariable(new ElementSymbol(column.getName(), resource.getGroupSymbol()));
            if (prepared) {
                referenceValues.add(new Reference(i++));
                this.params.add(ODataSQLBuilder.asParam(edmProp, prop.getValue()));
                continue;
            }
            constantValues.add(new Constant(ODataSQLBuilder.asParam(edmProp, prop.getValue()).getValue()));
        }
        if (prepared) {
            insert.setValues(referenceValues);
        } else {
            insert.setValues(constantValues);
        }
        return insert;
    }

    static SQLParameter asParam(EdmProperty edmProp, Object value) {
        String teiidType = ODataTypeManager.teiidType((SingletonPrimitiveType)edmProp.getType(), edmProp.isCollection());
        int sqlType = JDBCSQLTypeInfo.getSQLType((String)teiidType);
        if (value == null) {
            return new SQLParameter(null, sqlType);
        }
        return new SQLParameter(ODataTypeManager.convertToTeiidRuntimeType(DataTypeManager.getDataTypeClass((String)teiidType), value), sqlType);
    }

    private Table findTable(String tableName, MetadataStore store) {
        Table t;
        Schema s;
        int idx = tableName.indexOf(46);
        if (idx > 0 && (s = store.getSchema(tableName.substring(0, idx))) != null && (t = s.getTable(tableName.substring(idx + 1))) != null) {
            return t;
        }
        for (Schema s2 : store.getSchemaList()) {
            Table t2 = (Table)s2.getTables().get(tableName);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    public Query selectWithEntityKey(EdmEntityType entityType, Entity entity, Map<String, Object> generatedKeys, Set<EdmNavigationProperty> expand) throws TeiidException {
        Table table = this.findTable(entityType.getName(), this.metadata);
        EntityResource resource = new EntityResource(table, new GroupSymbol(table.getFullName()), entityType);
        resource.setFromClause((FromClause)new UnaryFromClause(new GroupSymbol(table.getFullName())));
        resource.addAllColumns(false);
        this.context = resource;
        FromClause from = resource.getFromClause();
        Criteria criteria = null;
        for (EdmNavigationProperty navProperty : expand) {
            ExpandResource joinResource = ExpandResource.buildExpand(navProperty, this.metadata, this.nameGenerator, this.aliasedGroups, this.getUriInfo(), this.parseService);
            resource.joinTable(joinResource, navProperty.isCollection(), JoinType.JOIN_INNER);
            if (joinResource.getCriteria() == null) {
                joinResource.addCriteria(resource.getCriteria());
            }
            joinResource.addAllColumns(false);
            resource = joinResource;
            this.context.addExpand(joinResource);
            from = resource.getFromClause();
            criteria = resource.getCriteria();
        }
        this.context.setFromClause(from);
        Query query = this.context.buildQuery();
        KeyRecord pk = table.getPrimaryKey();
        for (Column c : pk.getColumns()) {
            Property prop = entity.getProperty(c.getName());
            Constant right = null;
            if (prop != null) {
                right = new Constant(ODataTypeManager.convertToTeiidRuntimeType(c.getJavaType(), prop.getValue()));
            } else {
                Object value = generatedKeys.get(c.getName());
                if (value == null) {
                    if (pk.getColumns().size() == 1 && generatedKeys.size() == 1) {
                        value = generatedKeys.values().iterator().next();
                    }
                    if (value == null) {
                        throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16016, new Object[]{entityType.getName()}));
                    }
                }
                right = new Constant(value);
            }
            ElementSymbol left = new ElementSymbol(c.getName(), this.context.getGroupSymbol());
            if (criteria == null) {
                criteria = new CompareCriteria((Expression)left, 1, (Expression)right);
                continue;
            }
            CompareCriteria rightCC = new CompareCriteria((Expression)left, 1, (Expression)right);
            criteria = new CompoundCriteria(0, criteria, (Criteria)rightCC);
        }
        query.setCriteria(criteria);
        return query;
    }

    public Update update(EdmEntityType entityType, Entity entity, boolean prepared) {
        Update update = new Update();
        update.setGroup(this.context.getGroupSymbol());
        int i = 0;
        for (Property property : entity.getProperties()) {
            EdmProperty edmProperty = (EdmProperty)entityType.getProperty(property.getName());
            Column column = this.context.getTable().getColumnByName(edmProperty.getName());
            ElementSymbol symbol = new ElementSymbol(column.getName(), this.context.getGroupSymbol());
            boolean add = true;
            for (Column c : this.context.getTable().getPrimaryKey().getColumns()) {
                if (!c.getName().equals(column.getName())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            if (prepared) {
                update.addChange(symbol, (Expression)new Reference(i++));
                this.params.add(ODataSQLBuilder.asParam(edmProperty, property.getValue()));
                continue;
            }
            update.addChange(symbol, (Expression)new Constant(ODataSQLBuilder.asParam(edmProperty, property.getValue()).getValue()));
        }
        update.setCriteria(this.context.getCriteria());
        return update;
    }

    public Update updateProperty(EdmProperty edmProperty, Property property, boolean prepared) {
        Update update = new Update();
        update.setGroup(this.context.getGroupSymbol());
        Column column = this.context.getTable().getColumnByName(edmProperty.getName());
        ElementSymbol symbol = new ElementSymbol(column.getName(), this.context.getGroupSymbol());
        if (prepared) {
            update.addChange(symbol, (Expression)new Reference(0));
            this.params.add(ODataSQLBuilder.asParam(edmProperty, property.getValue()));
        } else {
            update.addChange(symbol, (Expression)new Constant(ODataSQLBuilder.asParam(edmProperty, property.getValue()).getValue()));
        }
        update.setCriteria(this.context.getCriteria());
        return update;
    }

    public Update updateStreamProperty(EdmProperty edmProperty, final InputStream content) {
        Update update = new Update();
        update.setGroup(this.context.getGroupSymbol());
        Column column = this.context.getTable().getColumnByName(edmProperty.getName());
        ElementSymbol symbol = new ElementSymbol(column.getName(), this.context.getGroupSymbol());
        update.addChange(symbol, (Expression)new Reference(0));
        Class lobType = DataTypeManager.getDataTypeClass((String)column.getDatatype().getRuntimeTypeName());
        int sqlType = JDBCSQLTypeInfo.getSQLType((String)column.getDatatype().getRuntimeTypeName());
        if (content == null) {
            this.params.add(new SQLParameter(null, sqlType));
        } else {
            SQLXMLImpl value = null;
            InputStreamFactory isf = new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return content;
                }
            };
            if (lobType.isAssignableFrom(SQLXML.class)) {
                value = new SQLXMLImpl(isf);
            } else if (lobType.isAssignableFrom(Clob.class)) {
                value = new ClobImpl(isf, -1L);
            } else if (lobType.isAssignableFrom(Blob.class)) {
                value = new BlobImpl(isf);
            } else {
                this.exceptions.add(new TeiidException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16031, new Object[]{column.getName()})));
            }
            this.params.add(new SQLParameter(value, sqlType));
        }
        update.setCriteria(this.context.getCriteria());
        return update;
    }

    public Delete delete() {
        Delete delete = new Delete();
        delete.setGroup(this.context.getGroupSymbol());
        delete.setCriteria(this.context.getCriteria());
        return delete;
    }

    public void visit(UriInfoService info) {
        this.exceptions.add(new TeiidException("UriInfoService NotSupported"));
    }

    public void visit(UriInfoAll info) {
        this.exceptions.add(new TeiidException("UriInfoAll NotSupported"));
    }

    public void visit(UriInfoBatch info) {
        this.exceptions.add(new TeiidException("UriInfoBatch NotSupported"));
    }

    public void visit(UriInfoCrossjoin info) {
        for (String name : info.getEntitySetNames()) {
            EdmEntitySet entitySet = this.serviceMetadata.getEdm().getEntityContainer().getEntitySet(name);
            EdmEntityType entityType = entitySet.getEntityType();
            CrossJoinResource resource = null;
            try {
                boolean hasExpand = this.hasExpand(entitySet.getName(), info.getExpandOption());
                resource = CrossJoinResource.buildCrossJoin(entityType, null, this.metadata, this.nameGenerator, this.aliasedGroups, this.getUriInfo(), this.parseService, hasExpand);
                resource.addAllColumns(!hasExpand);
                if (this.context == null) {
                    this.context = resource;
                    this.orderBy = this.context.addDefaultOrderBy();
                    continue;
                }
                this.context.addSibiling(resource);
                OrderBy orderby = resource.addDefaultOrderBy();
                int index = orderby.getVariableCount();
                for (int i = 0; i < index; ++i) {
                    this.orderBy.addVariable(orderby.getVariable(i));
                }
            }
            catch (TeiidException e) {
                this.exceptions.add(e);
            }
        }
        super.visit(info);
        this.expandOption = null;
    }

    private boolean hasExpand(String name, ExpandOption expandOption) {
        if (expandOption == null) {
            return false;
        }
        for (ExpandItem ei : expandOption.getExpandItems()) {
            String expand = ((UriResourceEntitySetImpl)ei.getResourcePath().getUriResourceParts().get(0)).getEntitySet().getName();
            if (!expand.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void visit(UriInfoMetadata info) {
        this.exceptions.add(new TeiidException("UriInfoMetadata NotSupported"));
    }

    public void visit(ExpandOption option) {
        this.expandOption = option;
    }

    public void visit(FormatOption info) {
    }

    public void visit(UriInfoEntityId info) {
        try {
            this.visit(ODataSQLBuilder.buildUriInfo(new URI(info.getIdOption().getValue()), this.baseURI, this.serviceMetadata));
        }
        catch (UriParserException e) {
            this.exceptions.add(new TeiidException((Throwable)e));
        }
        catch (URISyntaxException e) {
            this.exceptions.add(new TeiidException((Throwable)e));
        }
        this.visit(info.getSelectOption());
        if (info.getExpandOption() != null) {
            this.visit(info.getExpandOption());
        }
        if (info.getFormatOption() != null) {
            this.visit(info.getFormatOption());
        }
    }

    static UriInfo buildUriInfo(URI uri, String baseUri, ServiceMetadata serviceMetadata) throws URISyntaxException, UriParserException {
        URI servicePath = new URI(baseUri);
        String path = servicePath.getPath();
        String rawPath = uri.getPath();
        int e = rawPath.indexOf(path);
        rawPath = -1 == e ? uri.getPath() : rawPath.substring(e + path.length());
        return new Parser().parseUri(rawPath, uri.getQuery(), null, serviceMetadata.getEdm());
    }

    public void visit(UriResourceCount option) {
        if (option != null) {
            this.countQuery = true;
        }
    }

    public void visit(UriResourceRef info) {
        this.reference = true;
    }

    public void visit(UriResourceRoot info) {
        this.exceptions.add(new TeiidException("UriResourceRoot NotSupported"));
    }

    public void visit(UriResourceValue info) {
    }

    public void visit(UriResourceAction info) {
        this.exceptions.add(new TeiidException("UriResourceAction NotSupported"));
    }

    public void visit(UriResourceFunction info) {
        this.exceptions.add(new TeiidException("UriResourceFunction NotSupported"));
    }

    public void visit(UriResourceIt info) {
        this.exceptions.add(new TeiidException("UriResourceIt NotSupported"));
    }

    public void visit(UriResourceLambdaAll info) {
        this.exceptions.add(new TeiidException("UriResourceLambdaAll NotSupported"));
    }

    public void visit(UriResourceLambdaAny info) {
        this.exceptions.add(new TeiidException("UriResourceLambdaAll NotSupported"));
    }

    public void visit(UriResourceLambdaVariable info) {
        this.exceptions.add(new TeiidException("UriResourceLambdaVariable NotSupported"));
    }

    public void visit(UriResourceSingleton info) {
        this.exceptions.add(new TeiidException("UriResourceSingleton NotSupported"));
    }

    public void visit(UriResourceComplexProperty info) {
        this.exceptions.add(new TeiidException("UriResourceComplexProperty NotSupported"));
    }

    class URLParseService {
        URLParseService() {
        }

        public Query parse(String rawPath) throws TeiidException {
            try {
                rawPath = rawPath.replace("$root", "");
                UriInfo uriInfo = new Parser().parseUri(rawPath, null, null, ODataSQLBuilder.this.serviceMetadata.getEdm());
                ODataSQLBuilder visitor = new ODataSQLBuilder(ODataSQLBuilder.this.metadata, ODataSQLBuilder.this.prepared, ODataSQLBuilder.this.aliasedGroups, ODataSQLBuilder.this.baseURI, ODataSQLBuilder.this.serviceMetadata, ODataSQLBuilder.this.nameGenerator){

                    @Override
                    public void visit(OrderByOption option) {
                    }
                };
                visitor.visit(uriInfo);
                return visitor.selectQuery();
            }
            catch (UriParserException e) {
                throw new TeiidException((Throwable)e);
            }
        }
    }
}

