/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.Collections;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.OData4Impl;
import org.apache.olingo.server.core.SchemaBasedEdmProvider;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Schema;
import org.teiid.odata.api.Client;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.OData4EntitySchemaBuilder;
import org.teiid.olingo.service.TeiidServiceHandler;

public class OlingoBridge {
    private HashMap<String, ODataHttpHandler> handlers = new HashMap();

    public ODataHttpHandler getHandler(Client client, String schemaName) throws ServletException {
        if (this.handlers.get(schemaName) == null) {
            Schema teiidSchema = client.getMetadataStore().getSchema(schemaName);
            if (teiidSchema == null || !OlingoBridge.isVisible(client.getVDB(), teiidSchema)) {
                throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16022, new Object[0]));
            }
            OData odata = OData4Impl.newInstance();
            VDBMetaData vdb = client.getVDB();
            CsdlSchema schema = OData4EntitySchemaBuilder.buildMetadata(vdb.getFullName(), teiidSchema);
            SchemaBasedEdmProvider edmProvider = new SchemaBasedEdmProvider();
            edmProvider.addSchema(schema);
            ServiceMetadata metadata = odata.createServiceMetadata((CsdlEdmProvider)edmProvider, Collections.emptyList());
            ODataHttpHandler handler = odata.createHandler(metadata);
            handler.register((Processor)new TeiidServiceHandler(schemaName));
            this.handlers.put(schemaName, handler);
        }
        return this.handlers.get(schemaName);
    }

    private static boolean isVisible(VDBMetaData vdb, Schema schema) {
        String schemaName = schema.getName();
        ModelMetaData model = vdb.getModel(schemaName);
        if (model == null) {
            return true;
        }
        return model.isVisible();
    }
}

