/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.apache.olingo.server.core.requests.FunctionRequest;
import org.apache.olingo.server.core.requests.OperationRequest;
import org.teiid.core.TeiidException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.odata.api.ProcedureReturnType;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.LiteralParser;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class ProcedureSQLBuilder {
    private List<SQLParameter> sqlParameters = new ArrayList<SQLParameter>();
    private Schema teiidSchema;
    private Procedure procedure;
    private ProcedureReturn procedureReturn;
    private ParameterValueProvider parameterValueProvider;

    public ProcedureSQLBuilder(Schema schema, OperationRequest request) throws TeiidException {
        this.teiidSchema = schema;
        if (request instanceof FunctionRequest) {
            FunctionRequest functionRequest = (FunctionRequest)request;
            this.parameterValueProvider = new FunctionParameterValueProvider(functionRequest.getParameters());
            this.visit((EdmOperation)functionRequest.getFunction());
        } else {
            ActionRequest actionRequest = (ActionRequest)request;
            this.parameterValueProvider = new ActionParameterValueProvider(actionRequest.getPayload());
            this.visit((EdmOperation)actionRequest.getAction());
        }
    }

    public ProcedureReturn getReturn() {
        return this.procedureReturn;
    }

    public void visit(EdmOperation edmOperation) throws TeiidException {
        this.procedure = this.teiidSchema.getProcedure(edmOperation.getName());
        if (edmOperation.getReturnType() != null) {
            this.visit(edmOperation.getReturnType());
        }
        for (String parameterName : edmOperation.getParameterNames()) {
            this.visit(edmOperation.getParameter(parameterName));
        }
    }

    private boolean hasResultSet() {
        return this.procedure.getResultSet() != null;
    }

    private void visit(EdmReturnType returnType) {
        EdmType type = returnType.getType();
        Class teiidType = null;
        if (this.hasResultSet()) {
            Column column = this.getResultSetLobColumn();
            if (column != null) {
                teiidType = DataTypeManager.getDataTypeClass((String)column.getRuntimeType());
                Integer sqlType = JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName((Class)teiidType));
                this.procedureReturn = new ProcedureReturn(type, sqlType, true, true);
            } else {
                this.procedureReturn = new ProcedureReturn(type, null, true, false);
            }
        } else {
            ProcedureParameter parameter = this.getReturnParameter();
            teiidType = DataTypeManager.getDataTypeClass((String)parameter.getRuntimeType());
            Integer sqlType = JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName((Class)teiidType));
            this.procedureReturn = new ProcedureReturn(type, sqlType, false, false);
        }
    }

    private ProcedureParameter getReturnParameter() {
        for (ProcedureParameter parameter : this.procedure.getParameters()) {
            if (!parameter.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            return parameter;
        }
        return null;
    }

    private Column getResultSetLobColumn() {
        List columns;
        ColumnSet returnColumns = this.procedure.getResultSet();
        if (returnColumns != null && (columns = returnColumns.getColumns()).size() == 1 && DataTypeManager.isLOB((Class)((Column)columns.get(0)).getJavaType())) {
            return (Column)columns.get(0);
        }
        return null;
    }

    private void visit(EdmParameter parameter) throws TeiidException {
        Class<?> runtimeType = this.resolveParameterType(this.procedure.getName(), parameter.getName());
        Integer sqlType = JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName(runtimeType));
        Object value = this.parameterValueProvider.getValue(parameter, runtimeType);
        this.sqlParameters.add(new SQLParameter(parameter.getName(), ODataTypeManager.convertToTeiidRuntimeType(runtimeType, value), sqlType));
    }

    public String buildProcedureSQL() {
        StringBuilder sql = new StringBuilder();
        if (this.getReturn().hasResultSet()) {
            sql.append("{");
        } else {
            sql.append("{? = ");
        }
        sql.append("call ").append(SQLStringVisitor.escapeSinglePart((String)this.procedure.getFullName()));
        sql.append("(");
        boolean first = true;
        for (SQLParameter parameter : this.sqlParameters) {
            if (!first) {
                sql.append(",");
            }
            first = false;
            sql.append(SQLStringVisitor.escapeSinglePart((String)parameter.getName())).append("=>?");
        }
        sql.append(")");
        sql.append("}");
        return sql.toString();
    }

    public Class<?> resolveParameterType(String procedureName, String parameterName) {
        for (ProcedureParameter pp : this.procedure.getParameters()) {
            if (!pp.getName().equalsIgnoreCase(parameterName)) continue;
            return DataTypeManager.getDataTypeClass((String)pp.getRuntimeType());
        }
        return null;
    }

    public List<SQLParameter> getSqlParameters() {
        return this.sqlParameters;
    }

    static class FunctionParameterValueProvider
    implements ParameterValueProvider {
        private List<UriParameter> parameters;

        public FunctionParameterValueProvider(List<UriParameter> parameters) {
            this.parameters = parameters;
        }

        @Override
        public Object getValue(EdmParameter edmParameter, Class<?> runtimeType) throws TeiidException {
            for (UriParameter parameter : this.parameters) {
                if (!parameter.getName().equals(edmParameter.getName())) continue;
                return LiteralParser.parseLiteral(edmParameter, runtimeType, parameter.getText());
            }
            return null;
        }
    }

    static class ActionParameterValueProvider
    implements ParameterValueProvider {
        private InputStream payload;
        private boolean alreadyConsumed;
        private byte[] jsonPayload;

        public ActionParameterValueProvider(InputStream payload) {
            this.payload = payload;
        }

        @Override
        public Object getValue(EdmParameter edmParameter, Class<?> runtimeType) throws TeiidException {
            if (!this.alreadyConsumed) {
                this.alreadyConsumed = true;
                if (DataTypeManager.isLOB(runtimeType)) {
                    InputStreamFactory isf = new InputStreamFactory(){

                        public InputStream getInputStream() throws IOException {
                            return ActionParameterValueProvider.this.payload;
                        }
                    };
                    if (runtimeType.isAssignableFrom(XMLType.class)) {
                        return new SQLXMLImpl(isf);
                    }
                    if (runtimeType.isAssignableFrom(ClobType.class)) {
                        return new ClobImpl(isf, -1L);
                    }
                    if (runtimeType.isAssignableFrom(BlobType.class)) {
                        return new BlobImpl(isf);
                    }
                } else {
                    this.jsonPayload = this.convertToByteArray(this.payload);
                }
            }
            List<?> values = this.parseParameter(new ByteArrayInputStream(this.jsonPayload), edmParameter, runtimeType);
            if (edmParameter.isCollection()) {
                return values;
            }
            return values.get(0);
        }

        private List<?> parseParameter(InputStream stream, EdmParameter parameter, Class<?> runtimeType) throws TeiidException {
            try {
                ArrayList<Object> parsedValues = new ArrayList<Object>();
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
                JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
                ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
                JsonNode jsonNode = tree.get("value");
                if (jsonNode != null) {
                    if (jsonNode.isArray()) {
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        Iterator it = arrayNode.iterator();
                        while (it.hasNext()) {
                            String value = ((JsonNode)it.next()).get(parameter.getName()).asText();
                            parsedValues.add(LiteralParser.parseLiteral(parameter, runtimeType, value));
                        }
                    } else {
                        String value = jsonNode.asText();
                        parsedValues.add(LiteralParser.parseLiteral(parameter, runtimeType, value));
                    }
                    tree.remove("value");
                    return parsedValues;
                }
                String value = tree.get(parameter.getName()).asText();
                parsedValues.add(LiteralParser.parseLiteral(parameter, runtimeType, value));
                return parsedValues;
            }
            catch (JsonParseException e) {
                throw new TeiidException((Throwable)e);
            }
            catch (JsonMappingException e) {
                throw new TeiidException((Throwable)e);
            }
            catch (IOException e) {
                throw new TeiidException((Throwable)e);
            }
        }

        private byte[] convertToByteArray(InputStream payload) throws TeiidException {
            try {
                return ObjectConverterUtil.convertToByteArray((InputStream)payload);
            }
            catch (IOException e) {
                throw new TeiidException((Throwable)e);
            }
        }
    }

    static interface ParameterValueProvider {
        public Object getValue(EdmParameter var1, Class<?> var2) throws TeiidException;
    }

    static class ProcedureReturn
    implements ProcedureReturnType {
        private EdmType type;
        private Integer sqlType = null;
        private boolean resultSetBasedLob;
        private boolean hasResultSet;

        public ProcedureReturn(EdmType type, Integer sqlType, boolean hasResultSet, boolean resultsetLob) {
            this.type = type;
            this.sqlType = sqlType;
            this.resultSetBasedLob = resultsetLob;
            this.hasResultSet = hasResultSet;
        }

        public EdmType getReturnType() {
            return this.type;
        }

        @Override
        public boolean hasResultSet() {
            return this.hasResultSet;
        }

        @Override
        public boolean hasResultSetBasedLob() {
            return this.resultSetBasedLob;
        }

        @Override
        public Integer getSqlType() {
            return this.sqlType;
        }
    }
}

