/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.core.RequestURLHierarchyVisitor;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.teiid.core.TeiidException;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Table;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.LiteralParser;
import org.teiid.olingo.service.EntityResource;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;

public class ReferenceUpdateSQLBuilder
extends RequestURLHierarchyVisitor {
    private final MetadataStore metadata;
    private String baseURI;
    private ServiceMetadata serviceMetadata;
    private ScopedTable updateTable;
    private ScopedTable referenceTable;
    private boolean collection;
    private final ArrayList<SQLParameter> params = new ArrayList();

    public ReferenceUpdateSQLBuilder(MetadataStore metadata, String baseURI, ServiceMetadata serviceMetadata) {
        this.metadata = metadata;
        this.baseURI = baseURI;
        this.serviceMetadata = serviceMetadata;
    }

    public void visit(UriResourceEntitySet info) {
        Table table = EntityResource.findTable(info.getEntitySet(), this.metadata);
        EdmEntityType type = info.getEntitySet().getEntityType();
        List keys = info.getKeyPredicates();
        this.updateTable = new ScopedTable(table, type, keys);
    }

    public void visit(UriResourceNavigation info) {
        EdmNavigationProperty property = info.getProperty();
        this.referenceTable = new ScopedTable(EntityResource.findTable(property.getType(), this.metadata), property.getType(), info.getKeyPredicates());
        if (property.isCollection()) {
            ForeignKey fk = EntityResource.joinFK(this.referenceTable.getTable(), this.updateTable.getTable());
            this.referenceTable.setFk(fk);
            ScopedTable temp = this.updateTable;
            this.updateTable = this.referenceTable;
            this.referenceTable = temp;
            this.collection = true;
        } else {
            ForeignKey fk = EntityResource.joinFK(this.updateTable.getTable(), this.referenceTable.getTable());
            this.updateTable.setFk(fk);
        }
    }

    public Update updateReference(URI referenceId, boolean prepared, boolean delete) throws SQLException {
        try {
            if (referenceId != null) {
                UriInfo uriInfo = ODataSQLBuilder.buildUriInfo(referenceId, this.baseURI, this.serviceMetadata);
                UriResourceEntitySet uriEnitytSet = (UriResourceEntitySet)uriInfo.asUriInfoResource().getUriResourceParts().get(0);
                if (this.collection) {
                    this.updateTable.setKeyPredicates(uriEnitytSet.getKeyPredicates());
                } else {
                    this.referenceTable.setKeyPredicates(uriEnitytSet.getKeyPredicates());
                }
            }
        }
        catch (UriParserException e) {
            throw new SQLException(e);
        }
        catch (URISyntaxException e) {
            throw new SQLException(e);
        }
        try {
            Update update = new Update();
            update.setGroup(this.updateTable.getGroupSymbol());
            List<String> columnNames = EntityResource.getColumnNames(this.updateTable.getFk().getColumns());
            for (int i = 0; i < columnNames.size(); ++i) {
                Column column = (Column)this.updateTable.getFk().getColumns().get(i);
                String columnName = columnNames.get(i);
                ElementSymbol symbol = new ElementSymbol(columnName, this.updateTable.getGroupSymbol());
                EdmEntityType entityType = this.updateTable.getEdmEntityType();
                EdmProperty edmProperty = (EdmProperty)entityType.getProperty(columnName);
                Object value = null;
                if (!delete) {
                    UriParameter parameter = this.getParameter((String)this.updateTable.getFk().getReferenceColumns().get(i), this.referenceTable.getKeyPredicates());
                    value = LiteralParser.parseLiteral(edmProperty, column.getJavaType(), parameter.getText());
                }
                if (prepared) {
                    update.addChange(symbol, (Expression)new Reference(i++));
                    this.params.add(ODataSQLBuilder.asParam(edmProperty, value));
                    continue;
                }
                update.addChange(symbol, (Expression)new Constant(ODataSQLBuilder.asParam(edmProperty, value).getValue()));
            }
            KeyRecord pk = this.updateTable.getTable().getPrimaryKey();
            if (pk == null) {
                pk = (KeyRecord)this.updateTable.getTable().getUniqueKeys().get(0);
            }
            Criteria criteria = EntityResource.buildEntityKeyCriteria(this.updateTable, null, this.metadata, null, null);
            update.setCriteria(criteria);
            return update;
        }
        catch (TeiidException e) {
            throw new SQLException(e);
        }
    }

    private UriParameter getParameter(String name, List<UriParameter> keys) {
        for (UriParameter parameter : keys) {
            String propertyName = parameter.getName();
            if (!propertyName.equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public List<SQLParameter> getParameters() {
        return this.params;
    }

    static class ScopedTable
    extends EntityResource {
        private ForeignKey fk;

        public ScopedTable(Table table, EdmEntityType type, List<UriParameter> keys) {
            this.setTable(table);
            this.setEdmEntityType(type);
            this.setGroupSymbol(new GroupSymbol(table.getFullName()));
            this.setKeyPredicates(keys);
        }

        public ForeignKey getFk() {
            return this.fk;
        }

        public void setFk(ForeignKey fk) {
            this.fk = fk;
        }
    }
}

