/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class LiteralParser {
    private static final Pattern INT_PATTERN = Pattern.compile("[\\+|-]?\\d+");
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[\\+|-]?\\d+\\.\\d+((e|E) [\\+|-]? \\d+)?");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("true|false|TRUE|FALSE");
    private static final Pattern BINARY_PATTERN = Pattern.compile("^binary\\s'([a-fA-f0-9]*)'$");
    private static final Pattern DATE_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^(\\d{2}):(\\d{2}):(\\d{2})$");
    private static final Pattern DATETIME_PATTERN = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2})(:\\d{2})?(\\.\\d{1,7})?((Z)|([\\+|-]?\\d{2}:\\d{2}))?$");
    private static final Pattern DATETIMEOFFSET_PATTERN = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})(\\.\\d{1,7})?(((\\+|-)\\d{2}:\\d{2})|(Z))$");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private static final SimpleDateFormat DATETIME_WITH_SECONDS_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat DATETIME_WITH_MILLIS_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat DATETIMEOFFSET_XML = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
    private static final SimpleDateFormat DATETIMEOFFSET_WITH_MILLIS_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");

    public static Object parseLiteral(String text) {
        if (text.equals("null")) {
            return null;
        }
        if (INT_PATTERN.matcher(text = text.trim()).matches()) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return Long.parseLong(text);
            }
        }
        if (DOUBLE_PATTERN.matcher(text).matches()) {
            return Double.parseDouble(text);
        }
        if (BOOLEAN_PATTERN.matcher(text).matches()) {
            return Boolean.parseBoolean(text);
        }
        if (BINARY_PATTERN.matcher(text).matches()) {
            try {
                return Hex.decodeHex((char[])text.toCharArray());
            }
            catch (DecoderException e) {
            }
        } else if (DATE_PATTERN.matcher(text).matches()) {
            try {
                return new Date(DATE_FORMAT.parse(text).getTime());
            }
            catch (ParseException e) {
            }
        } else if (DATETIME_PATTERN.matcher(text).matches()) {
            try {
                return LiteralParser.parseDateTime(text);
            }
            catch (ParseException e) {
            }
        } else if (TIME_PATTERN.matcher(text).matches()) {
            try {
                return LiteralParser.parseTime(text);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return LiteralParser.unquote(text);
    }

    private static String unquote(String str) {
        if (str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1).replace("''", "'");
        }
        return str;
    }

    private static Timestamp parseDateTime(String value) throws ParseException {
        Matcher matcher = DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        String dateTime = matcher.group(1);
        String seconds = matcher.group(2);
        String nanoSeconds = matcher.group(3);
        String offset = matcher.group(6);
        String utc = matcher.group(5);
        if (utc != null && utc.equals("Z")) {
            offset = "+00:00";
        }
        if (seconds == null) {
            return new Timestamp(DATETIME_FORMAT.parse(dateTime).getTime());
        }
        if (nanoSeconds == null) {
            return new Timestamp(DATETIME_WITH_SECONDS_FORMAT.parse(dateTime + seconds).getTime());
        }
        if (nanoSeconds.length() <= 4) {
            if (offset == null) {
                return new Timestamp(DATETIME_WITH_MILLIS_FORMAT.parse(dateTime + seconds + nanoSeconds).getTime());
            }
            return new Timestamp(DATETIMEOFFSET_WITH_MILLIS_FORMAT.parse(dateTime + seconds + nanoSeconds + offset).getTime());
        }
        if (offset == null) {
            return new Timestamp(LiteralParser.adjustMillis(DATETIME_WITH_MILLIS_FORMAT.parse(dateTime + seconds + nanoSeconds.substring(0, 4)).getTime(), nanoSeconds));
        }
        return new Timestamp(LiteralParser.adjustMillis(DATETIME_WITH_MILLIS_FORMAT.parse(dateTime + seconds + nanoSeconds.substring(0, 4) + offset).getTime(), nanoSeconds));
    }

    private static long adjustMillis(long dateTime, String nanoSeconds) {
        return Math.round(Double.parseDouble("0." + nanoSeconds.substring(4))) == 0L ? dateTime : dateTime + 1L;
    }

    private static Time parseTime(String value) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TIME_FORMAT.parse(value));
        StringBuilder sb = new StringBuilder();
        sb.append(calendar.get(11)).append(":").append(calendar.get(12)).append(":").append(calendar.get(13));
        return Time.valueOf(sb.toString());
    }
}

