/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class ODataTypeManager {
    private static HashMap<String, String> odataTypes = new HashMap();
    private static HashMap<String, String> teiidTypes = new HashMap();

    public static String teiidType(SingletonPrimitiveType odataType, boolean array) {
        String type = odataType.getFullQualifiedName().getFullQualifiedNameAsString();
        return ODataTypeManager.teiidType(type, array);
    }

    public static String teiidType(String odataType, boolean array) {
        String type = odataTypes.get(odataType);
        if (type == null) {
            type = "string";
        }
        if (array) {
            type = type + "[]";
        }
        return type;
    }

    public static EdmPrimitiveTypeKind odataType(Class<?> teiidRuntimeTypeClass) {
        String dataType = DataTypeManager.getDataTypeName(teiidRuntimeTypeClass);
        return ODataTypeManager.odataType(dataType);
    }

    public static EdmPrimitiveTypeKind odataType(String teiidRuntimeType) {
        String type;
        if (teiidRuntimeType.endsWith("[]")) {
            teiidRuntimeType = teiidRuntimeType.substring(0, teiidRuntimeType.length() - 2);
        }
        if ((type = teiidTypes.get(teiidRuntimeType)) == null) {
            type = "Edm.String";
        }
        return EdmPrimitiveTypeKind.valueOfFQN((String)type);
    }

    public static Object convertToTeiidRuntimeType(Class<?> type, Object value) throws TeiidException {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (type.isArray() && value instanceof List) {
            List list = (List)value;
            Class<?> expectedArrayComponentType = type.getComponentType();
            Object array = Array.newInstance(type.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object arrayItem = ODataTypeManager.convertToTeiidRuntimeType(expectedArrayComponentType, list.get(i));
                Array.set(array, i, arrayItem);
            }
            return array;
        }
        Transform transform = DataTypeManager.getTransform(value.getClass(), type);
        if (transform != null) {
            try {
                value = transform.transform(value, type);
            }
            catch (TransformationException e) {
                throw new TeiidException((Throwable)e);
            }
        }
        return value;
    }

    public static Object parseLiteral(EdmParameter edmParameter, Class<?> runtimeType, String value) throws TeiidException {
        EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)edmParameter.getType().getFullQualifiedName().getFullQualifiedNameAsString().substring(4)));
        try {
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            Object converted = primitiveType.valueOfString(value, Boolean.valueOf(edmParameter.isNullable()), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), Boolean.valueOf(true), runtimeType);
            return converted;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidException((Throwable)e);
        }
    }

    public static Object parseLiteral(EdmProperty edmProperty, Class<?> runtimeType, String value) throws TeiidException {
        EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString().substring(4)));
        try {
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            Object converted = primitiveType.valueOfString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(true), runtimeType);
            return converted;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidException((Throwable)e);
        }
    }

    public static Object parseLiteral(String odataType, String value) throws TeiidException {
        EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)odataType.substring(4)));
        int maxLength = DataTypeManager.MAX_STRING_LENGTH;
        if (primitiveType instanceof EdmBinary || primitiveType instanceof EdmStream) {
            maxLength = DataTypeManager.MAX_VARBINARY_BYTES;
        }
        int precision = 4;
        int scale = 3;
        if (primitiveType instanceof EdmDecimal) {
            precision = 38;
            scale = 9;
        }
        Class expectedClass = primitiveType.getDefaultType();
        try {
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            Object converted = primitiveType.valueOfString(value, Boolean.valueOf(false), Integer.valueOf(maxLength), Integer.valueOf(precision), Integer.valueOf(scale), Boolean.valueOf(true), expectedClass);
            if (primitiveType instanceof EdmTimeOfDay) {
                Calendar ts = (Calendar)converted;
                return new Time(ts.getTimeInMillis());
            }
            if (primitiveType instanceof EdmDate) {
                Calendar ts = (Calendar)converted;
                return new Date(ts.getTimeInMillis());
            }
            return converted;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidException((Throwable)e);
        }
    }

    static {
        odataTypes.put("Edm.String", "string");
        odataTypes.put("Edm.Boolean", "boolean");
        odataTypes.put("Edm.Byte", "short");
        odataTypes.put("Edm.SByte", "byte");
        odataTypes.put("Edm.Int16", "short");
        odataTypes.put("Edm.Int32", "integer");
        odataTypes.put("Edm.Int64", "long");
        odataTypes.put("Edm.Single", "float");
        odataTypes.put("Edm.Double", "double");
        odataTypes.put("Edm.Decimal", "bigdecimal");
        odataTypes.put("Edm.Date", "date");
        odataTypes.put("Edm.TimeOfDay", "time");
        odataTypes.put("Edm.DateTimeOffset", "timestamp");
        odataTypes.put("Edm.Stream", "blob");
        odataTypes.put("Edm.Guid", "string");
        odataTypes.put("Edm.Binary", "varbinary");
        teiidTypes.put("string", "Edm.String");
        teiidTypes.put("boolean", "Edm.Boolean");
        teiidTypes.put("short", "Edm.Byte");
        teiidTypes.put("byte", "Edm.SByte");
        teiidTypes.put("short", "Edm.Int16");
        teiidTypes.put("integer", "Edm.Int32");
        teiidTypes.put("long", "Edm.Int64");
        teiidTypes.put("float", "Edm.Single");
        teiidTypes.put("double", "Edm.Double");
        teiidTypes.put("bigdecimal", "Edm.Decimal");
        teiidTypes.put("date", "Edm.Date");
        teiidTypes.put("time", "Edm.TimeOfDay");
        teiidTypes.put("timestamp", "Edm.DateTimeOffset");
        teiidTypes.put("blob", "Edm.Stream");
        teiidTypes.put("clob", "Edm.Stream");
        teiidTypes.put("xml", "Edm.Stream");
        teiidTypes.put("varbinary", "Edm.Binary");
        teiidTypes.put("object", "Edm.Binary");
    }
}

