/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.logging.LogManager;
import org.teiid.odata.api.QueryResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.ExpandDocumentNode;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;

public class EntityCollectionResponse
extends EntityCollection
implements QueryResponse {
    private final String invalidCharacterReplacement;
    private String nextToken;
    private Entity currentEntity;
    private DocumentNode documentNode;

    public EntityCollectionResponse(String invalidCharacterReplacement, DocumentNode resource) {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
        this.documentNode = resource;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        Entity entity = null;
        boolean add = true;
        if (this.currentEntity == null) {
            this.currentEntity = entity = EntityCollectionResponse.createEntity(rs, this.documentNode, this.invalidCharacterReplacement);
        } else if (this.isSameRow(rs, this.documentNode, this.currentEntity)) {
            entity = this.currentEntity;
            add = false;
        } else {
            this.currentEntity = entity = EntityCollectionResponse.createEntity(rs, this.documentNode, this.invalidCharacterReplacement);
        }
        if (this.documentNode.getExpands() != null && !this.documentNode.getExpands().isEmpty()) {
            for (DocumentNode resource : this.documentNode.getExpands()) {
                ExpandDocumentNode expandNode = (ExpandDocumentNode)resource;
                Entity expandEntity = EntityCollectionResponse.createEntity(rs, expandNode, this.invalidCharacterReplacement);
                Link link = entity.getNavigationLink(expandNode.getNavigationName());
                if (expandNode.isCollection()) {
                    if (link.getInlineEntitySet() == null) {
                        link.setInlineEntitySet(new EntityCollection());
                    }
                    link.getInlineEntitySet().getEntities().add(expandEntity);
                    continue;
                }
                link.setInlineEntity(expandEntity);
            }
        }
        if (add) {
            this.getEntities().add(entity);
        } else {
            EntityCollectionResponse.updateEntity(rs, entity, this.documentNode, this.invalidCharacterReplacement);
        }
    }

    private boolean isSameRow(ResultSet rs, DocumentNode node, Entity other) throws SQLException {
        List<ProjectedColumn> projected = node.getAllProjectedColumns();
        EdmEntityType entityType = node.getEdmEntityType();
        for (String name : entityType.getKeyPredicateNames()) {
            ProjectedColumn pc = this.getProjectedColumn(name, projected);
            if (rs.getObject(pc.getOrdinal()).equals(other.getProperty(name).getValue())) continue;
            return false;
        }
        return true;
    }

    private ProjectedColumn getProjectedColumn(String name, List<ProjectedColumn> projected) {
        for (ProjectedColumn pc : projected) {
            String propertyName = Symbol.getShortName((Expression)pc.getExpression());
            if (!name.equals(propertyName)) continue;
            return pc;
        }
        return null;
    }

    static Entity createEntity(ResultSet rs, DocumentNode node, String invalidChar) throws SQLException {
        List<ProjectedColumn> projected = node.getAllProjectedColumns();
        EdmEntityType entityType = node.getEdmEntityType();
        LinkedHashMap<String, Link> streamProperties = new LinkedHashMap<String, Link>();
        Entity entity = new Entity();
        entity.setType(entityType.getFullQualifiedName().getFullQualifiedNameAsString());
        for (ProjectedColumn column : projected) {
            String propertyName = Symbol.getShortName((Expression)column.getExpression());
            Object value = rs.getObject(column.getOrdinal());
            try {
                SingletonPrimitiveType type = (SingletonPrimitiveType)column.getEdmType();
                if (type instanceof EdmStream) {
                    EntityCollectionResponse.buildStreamLink(streamProperties, value, propertyName);
                    continue;
                }
                Property property = EntityCollectionResponse.buildPropery(propertyName, type, column.isCollection(), value, invalidChar);
                entity.addProperty(property);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            catch (TransformationException e) {
                throw new SQLException(e);
            }
        }
        try {
            String id = EntityCollectionResponse.buildId(entity, entityType);
            entity.setId(new URI(id));
            for (String name : streamProperties.keySet()) {
                Link link = streamProperties.get(name);
                link.setHref(id + "/" + name);
                entity.getMediaEditLinks().add(link);
            }
            for (String name : entityType.getNavigationPropertyNames()) {
                Link navLink = new Link();
                navLink.setTitle(name);
                navLink.setHref(id + "/" + name);
                navLink.setRel("http://docs.oasis-open.org/odata/ns/related/" + name);
                entity.getNavigationLinks().add(navLink);
                Link assosiationLink = new Link();
                assosiationLink.setTitle(name);
                assosiationLink.setHref(id + "/" + name + "/$ref");
                assosiationLink.setRel("http://docs.oasis-open.org/odata/ns/relatedlinks/" + name);
                entity.getAssociationLinks().add(assosiationLink);
            }
        }
        catch (URISyntaxException e) {
            throw new SQLException(e);
        }
        return entity;
    }

    private static void updateEntity(ResultSet rs, Entity entity, DocumentNode node, String invalidChar) throws SQLException {
        List<ProjectedColumn> projected = node.getAllProjectedColumns();
        EdmEntityType entityType = node.getEdmEntityType();
        for (ProjectedColumn column : projected) {
            String propertyName = Symbol.getShortName((Expression)column.getExpression());
            if (entityType.getKeyPredicateNames().contains(propertyName)) continue;
            Object value = rs.getObject(propertyName);
            try {
                SingletonPrimitiveType type = (SingletonPrimitiveType)column.getEdmType();
                if (!column.isCollection()) continue;
                Property previousProperty = entity.getProperty(propertyName);
                Property property = EntityCollectionResponse.buildPropery(propertyName, type, column.isCollection(), value, invalidChar);
                property = EntityCollectionResponse.mergeProperties(propertyName, type, previousProperty, property);
                entity.getProperties().remove(previousProperty);
                entity.addProperty(property);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            catch (TransformationException e) {
                throw new SQLException(e);
            }
        }
    }

    private static Property mergeProperties(String propName, SingletonPrimitiveType type, Property one, Property two) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(one.asCollection());
        values.addAll(two.asCollection());
        return EntityCollectionResponse.createCollection(propName, (EdmPrimitiveType)type, values);
    }

    private static void buildStreamLink(LinkedHashMap<String, Link> streamProperties, Object value, String propName) {
        if (value != null) {
            Link streamLink = new Link();
            streamLink.setTitle(propName);
            if (value instanceof SQLXML) {
                streamLink.setType("application/xml");
            } else if (value instanceof Clob) {
                streamLink.setType("application/json");
            } else if (value instanceof Blob) {
                streamLink.setType("application/octet-stream");
            }
            streamLink.setRel("http://docs.oasis-open.org/odata/ns/mediaresource/" + propName);
            streamProperties.put(propName, streamLink);
        }
    }

    static Property buildPropery(String propName, SingletonPrimitiveType type, boolean isArray, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        if (value instanceof java.sql.Array) {
            value = ((java.sql.Array)value).getArray();
            int length = Array.getLength(value);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                if (o != null && o.getClass().isArray()) {
                    throw new TransformationException((BundleUtil.Event)ODataPlugin.Event.TEIID16029, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16029, new Object[]{propName}));
                }
                Object p = EntityCollectionResponse.getPropertyValue(type, isArray, o, invalidCharacterReplacement);
                values.add(p);
            }
            return EntityCollectionResponse.createCollection(propName, (EdmPrimitiveType)type, values);
        }
        if (isArray) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(EntityCollectionResponse.getPropertyValue(type, isArray, value, invalidCharacterReplacement));
            return EntityCollectionResponse.createCollection(propName, (EdmPrimitiveType)type, values);
        }
        return EntityCollectionResponse.createPrimitive(propName, (EdmPrimitiveType)type, EntityCollectionResponse.getPropertyValue(type, isArray, value, invalidCharacterReplacement));
    }

    private static Property createPrimitive(String name, EdmPrimitiveType type, Object value) {
        return new Property(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, ValueType.PRIMITIVE, value);
    }

    private static Property createCollection(String name, EdmPrimitiveType type, ArrayList<Object> values) {
        return new Property(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, ValueType.COLLECTION_PRIMITIVE, values);
    }

    static Object getPropertyValue(SingletonPrimitiveType expectedType, boolean isArray, Object value, String invalidCharacterReplacement) throws TransformationException, SQLException, IOException {
        Class targetType;
        if (value == null) {
            return null;
        }
        Class sourceType = DataTypeManager.getRuntimeType(value.getClass());
        if (sourceType.isAssignableFrom(expectedType.getDefaultType())) {
            return EntityCollectionResponse.replaceInvalidCharacters((EdmPrimitiveType)expectedType, value, invalidCharacterReplacement);
        }
        if (expectedType instanceof EdmDate && sourceType == Date.class) {
            return value;
        }
        if (expectedType instanceof EdmDateTimeOffset && sourceType == Timestamp.class) {
            return value;
        }
        if (expectedType instanceof EdmTimeOfDay && sourceType == Time.class) {
            return value;
        }
        if (expectedType instanceof EdmBinary) {
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Possible OOM when inlining the stream based values");
            if (sourceType == ClobType.class) {
                return ClobType.getString((Clob)((Clob)value)).getBytes();
            }
            if (sourceType == SQLXML.class) {
                return ((SQLXML)value).getString().getBytes();
            }
            if (sourceType == BlobType.class) {
                return ObjectConverterUtil.convertToByteArray((InputStream)((Blob)value).getBinaryStream());
            }
            if (value instanceof Serializable) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                bos.close();
                return bos.toByteArray();
            }
        }
        if (sourceType != (targetType = DataTypeManager.getDataTypeClass((String)ODataTypeManager.teiidType(expectedType, isArray)))) {
            Transform t = DataTypeManager.getTransform((Class)sourceType, (Class)targetType);
            value = t != null ? t.transform(value, targetType) : value;
        }
        value = EntityCollectionResponse.replaceInvalidCharacters((EdmPrimitiveType)expectedType, value, invalidCharacterReplacement);
        return value;
    }

    static Object replaceInvalidCharacters(EdmPrimitiveType expectedType, Object value, String invalidCharacterReplacement) {
        if (!(expectedType instanceof EdmString) || invalidCharacterReplacement == null) {
            return value;
        }
        if (value instanceof Character) {
            value = value.toString();
        }
        String s = (String)value;
        StringBuilder result = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= ' ' && c != ' ' && c != '\n' && c != '\t' && c != '\r') {
                if (result == null) {
                    result = new StringBuilder();
                    result.append(s.substring(0, i));
                }
                result.append(invalidCharacterReplacement);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        if (result == null) {
            return value;
        }
        return result.toString();
    }

    @Override
    public long size() {
        return this.getEntities().size();
    }

    @Override
    public void setCount(long count) {
        super.setCount(Integer.valueOf((int)count));
    }

    @Override
    public void setNextToken(String token) {
        this.nextToken = token;
    }

    @Override
    public String getNextToken() {
        return this.nextToken;
    }

    public static String buildId(Entity entity, EdmEntityType type) {
        String location = type.getName() + "(";
        int i = 0;
        boolean usename = type.getKeyPredicateNames().size() > 1;
        for (String key : type.getKeyPredicateNames()) {
            Property p;
            if (i > 0) {
                location = location + ",";
            }
            ++i;
            if (usename) {
                location = location + key + "=";
            }
            if ((p = entity.getProperty(key)).getType().equals("Edm.String")) {
                location = location + "'" + Encoder.encode((String)p.getValue().toString()) + "'";
                continue;
            }
            location = location + p.getValue().toString();
        }
        location = location + ")";
        return location;
    }
}

