/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.api.Client;
import org.teiid.odata.api.CountResponse;
import org.teiid.odata.api.OperationResponse;
import org.teiid.odata.api.ProcedureReturnType;
import org.teiid.odata.api.QueryResponse;
import org.teiid.odata.api.SQLParameter;
import org.teiid.odata.api.UpdateResponse;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.olingo.ODataPlugin;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.translator.CacheDirective;
import org.teiid.transport.LocalServerConnection;

public class LocalClient
implements Client {
    static final String DELIMITER = "--";
    private volatile VDBMetaData vdb;
    private final String vdbName;
    private final int vdbVersion;
    private ConnectionImpl connection;
    private Properties properties;

    public LocalClient(String vdbName, int vdbVersion, Properties properties) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.properties = properties;
    }

    private long getCacheTime() {
        return PropertiesUtils.getLongProperty((Properties)this.properties, (String)"skiptoken-cache-time", (long)300000L);
    }

    @Override
    public Connection open() throws SQLException {
        this.connection = LocalClient.buildConnection(TeiidDriver.getInstance(), this.vdbName, this.vdbVersion, this.properties);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)this.connection);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)this.connection, (Properties)this.properties);
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public static ConnectionImpl buildConnection(TeiidDriver driver, String vdbName, int version, Properties props) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:teiid:").append(vdbName).append(".").append(version).append(";");
        if (props.getProperty("PassthroughAuthentication") == null) {
            props.setProperty("PassthroughAuthentication", "true");
        }
        if (props.getProperty("transportName") == null) {
            props.setProperty("transportName", "odata");
        }
        if (props.getProperty("waitForLoad") == null) {
            props.setProperty("waitForLoad", "0");
        }
        ConnectionImpl connection = driver.connect(sb.toString(), props);
        return connection;
    }

    @Override
    public VDBMetaData getVDB() {
        if (this.vdb == null) {
            try {
                LocalServerConnection lsc = (LocalServerConnection)this.getConnection().getServerConnection();
                VDBMetaData vdb = lsc.getWorkContext().getVDB();
                if (vdb == null) {
                    throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16001, new Object[]{this.vdbName, this.vdbVersion}));
                }
                this.vdb = vdb;
            }
            catch (SQLException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        return this.vdb;
    }

    @Override
    public void executeCall(String sql, List<SQLParameter> parameters, ProcedureReturnType returnType, OperationResponse response) throws SQLException {
        boolean results;
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        CallableStatementImpl stmt = this.getConnection().prepareCall(sql);
        int i = 1;
        if (!returnType.hasResultSet()) {
            stmt.registerOutParameter(i++, (int)returnType.getSqlType());
        }
        if (!parameters.isEmpty()) {
            for (SQLParameter param : parameters) {
                stmt.setObject(i++, param.getValue(), param.getSqlType());
            }
        }
        if (results = stmt.execute()) {
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                if (returnType.hasResultSetBasedLob()) {
                    response.addPrimitive(rs.getObject(1));
                    continue;
                }
                response.addRow(rs);
            }
        }
        if (!returnType.hasResultSet()) {
            Object result = stmt.getObject(1);
            response.addPrimitive(result);
        }
    }

    @Override
    public MetadataStore getMetadataStore() {
        return ((TransformationMetadata)this.getVDB().getAttachment(TransformationMetadata.class)).getMetadataStore();
    }

    @Override
    public void executeSQL(Query query, List<SQLParameter> parameters, boolean calculateTotalSize, Integer skipOption, Integer topOption, String nextOption, int pageSize, QueryResponse response) throws SQLException {
        boolean cache;
        boolean bl = cache = pageSize > 0;
        if (cache) {
            CacheHint hint = new CacheHint();
            hint.setTtl(Long.valueOf(this.getCacheTime()));
            hint.setScope(CacheDirective.Scope.USER);
            query.setCacheHint(hint);
        }
        boolean getCount = false;
        getCount = calculateTotalSize;
        if (!(getCount || topOption == null && skipOption == null)) {
            if (topOption != null && skipOption != null) {
                query.setLimit(new Limit((Expression)new Constant((Object)skipOption), (Expression)new Constant((Object)topOption)));
            } else if (topOption != null) {
                query.setLimit(new Limit((Expression)new Constant((Object)0), (Expression)new Constant((Object)topOption)));
            }
        }
        String sessionId = this.getConnection().getServerConnection().getLogonResult().getSessionID();
        String nextToken = null;
        if (nextOption != null) {
            nextToken = nextOption;
            if (cache) {
                int idx = nextOption.indexOf(DELIMITER);
                sessionId = nextOption.substring(0, idx);
                nextToken = nextOption.substring(idx + 2);
            }
        }
        String sql = query.toString();
        if (cache) {
            sql = sql + " /* " + sessionId + " */";
        }
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        PreparedStatementImpl stmt = this.getConnection().prepareStatement(sql, cache ? 1004 : 1003, 1007);
        if (parameters != null && !parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                stmt.setObject(i + 1, parameters.get(i).getValue(), parameters.get(i).getSqlType());
            }
        }
        ResultSet rs = stmt.executeQuery();
        int count = 0;
        int skipSize = 0;
        if (getCount && skipOption != null) {
            skipSize = skipOption;
        }
        if (nextToken != null) {
            skipSize += Integer.parseInt(nextToken);
        }
        if (skipSize > 0) {
            count += this.skip(cache, rs, skipSize);
        }
        int size = pageSize;
        int top = Integer.MAX_VALUE;
        if (getCount && topOption != null) {
            size = top = topOption.intValue();
            if (pageSize > 0) {
                size = Math.min(pageSize, size);
            }
        } else if (size < 1) {
            size = Integer.MAX_VALUE;
        }
        for (int i = 0; i < size; ++i) {
            ++count;
            if (!rs.next()) break;
            response.addRow(rs);
        }
        if (getCount) {
            if (!cache) {
                while (rs.next()) {
                    ++count;
                }
            } else {
                rs.last();
                count = rs.getRow();
            }
        }
        response.setCount(count);
        if (cache && response.size() == (long)pageSize) {
            long end = (long)skipSize + response.size();
            if (getCount) {
                if (end < (long)Math.min(top, count)) {
                    response.setNextToken(this.nextToken(cache, sessionId, end));
                }
            } else if (rs.next()) {
                response.setNextToken(this.nextToken(cache, sessionId, end));
                rs.last();
            }
        }
    }

    private String nextToken(boolean cache, String sessionid, long skip) {
        if (cache) {
            return sessionid + DELIMITER + String.valueOf(skip);
        }
        return String.valueOf(skip);
    }

    private int skip(boolean cache, ResultSet rs, int skipSize) throws SQLException {
        int skipped = 0;
        if (!cache) {
            for (int i = 0; i < skipSize; ++i) {
                ++skipped;
                if (rs.next()) {
                    continue;
                }
                break;
            }
        } else {
            rs.absolute(skipSize);
        }
        return skipped;
    }

    @Override
    public CountResponse executeCount(Query query, List<SQLParameter> parameters) throws SQLException {
        String sql = query.toString();
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        PreparedStatementImpl stmt = this.getConnection().prepareStatement(sql);
        if (!parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                stmt.setObject(i + 1, parameters.get(i).getValue(), parameters.get(i).getSqlType());
            }
        }
        ResultSet rs = stmt.executeQuery();
        rs.next();
        final int count = rs.getInt(1);
        rs.close();
        stmt.close();
        return new CountResponse(){

            @Override
            public int getCount() {
                return count;
            }
        };
    }

    @Override
    public UpdateResponse executeUpdate(Command query, List<SQLParameter> parameters) throws SQLException {
        String sql = query.toString();
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        PreparedStatementImpl stmt = this.getConnection().prepareStatement(sql, 1003, 1007, 1, 1);
        if (!parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                stmt.setObject(i + 1, parameters.get(i).getValue(), parameters.get(i).getSqlType().intValue());
            }
        }
        final int count = stmt.executeUpdate();
        final Map<String, Object> keys = this.getGeneratedKeys(stmt.getGeneratedKeys());
        stmt.close();
        return new UpdateResponse(){

            @Override
            public Map<String, Object> getGeneratedKeys() {
                return keys;
            }

            @Override
            public int getUpdateCount() {
                return count;
            }
        };
    }

    private Map<String, Object> getGeneratedKeys(ResultSet result) throws SQLException {
        if (result == null) {
            return null;
        }
        HashMap<String, Object> keys = new HashMap<String, Object>();
        ResultSetMetaData metadata = result.getMetaData();
        while (result.next()) {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                String label = metadata.getColumnLabel(i + 1);
                keys.put(label, result.getObject(i + 1));
            }
        }
        return keys;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String startTransaction() throws SQLException {
        this.getConnection().setAutoCommit(false);
        return "anyid";
    }

    @Override
    public void commit(String txnId) throws SQLException {
        this.getConnection().commit();
        this.getConnection().setAutoCommit(true);
    }

    @Override
    public void rollback(String txnId) throws SQLException {
        this.getConnection().rollback();
        this.getConnection().setAutoCommit(true);
    }
}

