/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceIt;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.queryoption.expression.Alias;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.Enumeration;
import org.apache.olingo.server.api.uri.queryoption.expression.LambdaRef;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.Method;
import org.apache.olingo.server.api.uri.queryoption.expression.TypeLiteral;
import org.apache.olingo.server.api.uri.queryoption.expression.Unary;
import org.apache.olingo.server.core.RequestURLHierarchyVisitor;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.ODataExpressionVisitor;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class ODataExpressionToSQLVisitor
extends RequestURLHierarchyVisitor
implements ODataExpressionVisitor {
    private final Stack<Expression> stack = new Stack();
    private List<SQLParameter> params;
    private boolean prepared = false;
    private final List<TeiidException> exceptions = new ArrayList<TeiidException>();
    private final UriInfo uriInfo;
    private MetadataStore metadata;
    private DocumentNode ctxQuery;
    private DocumentNode ctxExpression;
    private TeiidServiceHandler.UniqueNameGenerator nameGenerator;
    private ODataSQLBuilder.URLParseService parseService;
    private ExpressionType exprType = ExpressionType.ANY;
    private String lastPropertyType;

    public ODataExpressionToSQLVisitor(DocumentNode resource, boolean prepared, UriInfo info, MetadataStore metadata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, List<SQLParameter> params, ODataSQLBuilder.URLParseService parseService) {
        this.ctxQuery = resource;
        this.prepared = prepared;
        this.uriInfo = info;
        this.metadata = metadata;
        this.nameGenerator = nameGenerator;
        this.params = params;
        this.parseService = parseService;
        this.ctxExpression = this.ctxQuery;
    }

    public Expression getExpression(org.apache.olingo.server.api.uri.queryoption.expression.Expression expr) throws TeiidException {
        this.accept(expr);
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
        return this.stack.pop();
    }

    public Expression getExpression(UriInfoResource info) throws TeiidException {
        this.visit(info);
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
        return this.stack.pop();
    }

    public DocumentNode getEntityResource() {
        return this.ctxQuery;
    }

    public DocumentNode getExpresionEntityResource() {
        return this.ctxExpression;
    }

    @Override
    public void visit(Alias expr) {
        String strValue = this.uriInfo.getValueForAlias(expr.getParameterName());
        try {
            if (strValue.startsWith("$root")) {
                this.stack.add((Expression)new ScalarSubquery((QueryCommand)this.parseService.parse(strValue)));
            } else {
                String type = "Edm.String";
                if (this.lastPropertyType != null) {
                    EdmPrimitiveTypeKind kind = ODataTypeManager.odataType(this.lastPropertyType);
                    type = kind.getFullQualifiedName().getFullQualifiedNameAsString();
                    this.lastPropertyType = null;
                }
                Object value = ODataTypeManager.parseLiteral(type, strValue);
                if (this.prepared) {
                    this.stack.add((Expression)new Reference(this.params.size()));
                    this.params.add(new SQLParameter(value, JDBCSQLTypeInfo.getSQLTypeFromClass((String)value.getClass().getName())));
                } else {
                    this.stack.add((Expression)new Constant(value));
                }
            }
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
    }

    @Override
    public void visit(Binary expr) {
        this.accept(expr.getLeftOperand());
        Expression lhs = this.stack.pop();
        this.accept(expr.getRightOperand());
        Expression rhs = this.stack.pop();
        CompoundCriteria binaryExpr = null;
        switch (expr.getOperator()) {
            case HAS: {
                this.exceptions.add(new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16036, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16036, new Object[0])));
                break;
            }
            case MUL: {
                binaryExpr = new Function("*", new Expression[]{lhs, rhs});
                break;
            }
            case DIV: {
                binaryExpr = new Function("/", new Expression[]{lhs, rhs});
                break;
            }
            case MOD: {
                binaryExpr = new Function("MOD", new Expression[]{lhs, rhs});
                break;
            }
            case ADD: {
                binaryExpr = new Function("+", new Expression[]{lhs, rhs});
                break;
            }
            case SUB: {
                binaryExpr = new Function("-", new Expression[]{lhs, rhs});
                break;
            }
            case GT: {
                if (this.exprType == ExpressionType.LAMBDAALL) {
                    binaryExpr = new SubqueryCompareCriteria(rhs, this.buildSubquery(this.ctxExpression, lhs), 3, 4);
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 4, rhs);
                break;
            }
            case GE: {
                if (this.exprType == ExpressionType.LAMBDAALL) {
                    binaryExpr = new SubqueryCompareCriteria(rhs, this.buildSubquery(this.ctxExpression, lhs), 5, 4);
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 6, rhs);
                break;
            }
            case LT: {
                if (this.exprType == ExpressionType.LAMBDAALL) {
                    binaryExpr = new SubqueryCompareCriteria(rhs, this.buildSubquery(this.ctxExpression, lhs), 4, 4);
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 3, rhs);
                break;
            }
            case LE: {
                if (this.exprType == ExpressionType.LAMBDAALL) {
                    binaryExpr = new SubqueryCompareCriteria(rhs, this.buildSubquery(this.ctxExpression, lhs), 6, 4);
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 5, rhs);
                break;
            }
            case EQ: {
                if (this.exprType == ExpressionType.LAMBDAALL) {
                    binaryExpr = new SubqueryCompareCriteria(rhs, this.buildSubquery(this.ctxExpression, lhs), 1, 4);
                    break;
                }
                if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    binaryExpr = new IsNullCriteria(lhs);
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 1, rhs);
                break;
            }
            case NE: {
                if (this.exprType == ExpressionType.LAMBDAALL) {
                    binaryExpr = new SubqueryCompareCriteria(rhs, this.buildSubquery(this.ctxExpression, lhs), 2, 4);
                    break;
                }
                if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    IsNullCriteria crit = new IsNullCriteria(lhs);
                    crit.setNegated(true);
                    binaryExpr = crit;
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 2, rhs);
                break;
            }
            case AND: {
                binaryExpr = new CompoundCriteria(0, (Criteria)lhs, (Criteria)rhs);
                break;
            }
            case OR: {
                binaryExpr = new CompoundCriteria(1, (Criteria)lhs, (Criteria)rhs);
            }
        }
        this.stack.push((Expression)binaryExpr);
    }

    @Override
    public void visit(Enumeration expr) {
        this.exceptions.add(new TeiidException("unsupported option"));
    }

    @Override
    public void visit(LambdaRef expr) {
    }

    @Override
    public void visit(Literal expr) {
        try {
            Object value = null;
            if (expr.getText() != null && !expr.getText().equalsIgnoreCase("null")) {
                String type = expr.getType().getFullQualifiedName().getFullQualifiedNameAsString();
                value = ODataTypeManager.parseLiteral(type, expr.getText());
            }
            if (this.prepared) {
                this.stack.add((Expression)new Reference(this.params.size()));
                this.params.add(new SQLParameter(value, JDBCSQLTypeInfo.getSQLTypeFromClass((String)value.getClass().getName())));
            } else {
                this.stack.add((Expression)new Constant(value));
            }
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
    }

    @Override
    public void visit(Member expr) {
        this.visit(expr.getResourcePath());
    }

    @Override
    public void visit(Method expr) {
        ArrayList<Expression> teiidExprs = new ArrayList<Expression>();
        for (org.apache.olingo.server.api.uri.queryoption.expression.Expression exp : expr.getParameters()) {
            this.accept(exp);
            teiidExprs.add(this.stack.pop());
        }
        switch (expr.getMethod()) {
            case CONTAINS: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0), new Constant((Object)1)}), 6, (Expression)new Constant((Object)1));
                this.stack.push((Expression)criteria);
                break;
            }
            case STARTSWITH: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0), new Constant((Object)1)}), 1, (Expression)new Constant((Object)1));
                this.stack.push((Expression)criteria);
                break;
            }
            case ENDSWITH: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("ENDSWITH", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0)}), 1, (Expression)new Constant((Object)Boolean.TRUE));
                this.stack.push((Expression)criteria);
                break;
            }
            case LENGTH: {
                this.stack.push((Expression)new Function("LENGTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case INDEXOF: {
                this.stack.push((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0)}));
                break;
            }
            case SUBSTRING: {
                this.stack.push((Expression)new Function("SUBSTRING", teiidExprs.toArray(new Expression[teiidExprs.size()])));
                break;
            }
            case TOLOWER: {
                this.stack.push((Expression)new Function("LCASE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case TOUPPER: {
                this.stack.push((Expression)new Function("UCASE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case TRIM: {
                this.stack.push((Expression)new Function("TRIM", new Expression[]{new Constant((Object)"BOTH"), new Constant((Object)Character.valueOf(' ')), (Expression)teiidExprs.get(0)}));
                break;
            }
            case CONCAT: {
                this.stack.push((Expression)new Function("CONCAT2", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            case YEAR: {
                this.stack.push((Expression)new Function("YEAR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case MONTH: {
                this.stack.push((Expression)new Function("MONTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case DAY: {
                this.stack.push((Expression)new Function("DAYOFMONTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case HOUR: {
                this.stack.push((Expression)new Function("HOUR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case MINUTE: {
                this.stack.push((Expression)new Function("MINUTE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case SECOND: {
                this.stack.push((Expression)new Function("SECOND", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case NOW: {
                this.stack.push((Expression)new Function("NOW", new Expression[0]));
                break;
            }
            case ROUND: {
                this.stack.push((Expression)new Function("ROUND", new Expression[]{(Expression)teiidExprs.get(0), new Constant((Object)0)}));
                break;
            }
            case FLOOR: {
                this.stack.push((Expression)new Function("FLOOR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case CEILING: {
                this.stack.push((Expression)new Function("CEILING", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case CAST: {
                this.stack.push((Expression)new Function("CONVERT", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            default: {
                this.exceptions.add(new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16027, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16027, new Object[]{expr.getMethod()})));
            }
        }
    }

    @Override
    public void visit(TypeLiteral expr) {
        this.stack.push((Expression)new Constant((Object)ODataTypeManager.teiidType((SingletonPrimitiveType)expr.getType(), false)));
    }

    @Override
    public void visit(Unary expr) {
        this.accept(expr.getOperand());
        Expression teiidExpr = this.stack.pop();
        switch (expr.getOperator()) {
            case MINUS: {
                this.stack.push((Expression)new Function("*", new Expression[]{new Constant((Object)-1), teiidExpr}));
                break;
            }
            case NOT: {
                this.stack.push((Expression)new NotCriteria((Criteria)new ExpressionCriteria(teiidExpr)));
            }
        }
    }

    private void accept(org.apache.olingo.server.api.uri.queryoption.expression.Expression expr) {
        if (expr instanceof Alias) {
            this.visit((Alias)expr);
        } else if (expr instanceof Binary) {
            this.visit((Binary)expr);
        } else if (expr instanceof Enumeration) {
            this.visit((Enumeration)expr);
        } else if (expr instanceof LambdaRef) {
            this.visit((LambdaRef)expr);
        } else if (expr instanceof Literal) {
            this.visit((Literal)expr);
        } else if (expr instanceof Member) {
            this.visit((Member)expr);
        } else if (expr instanceof Method) {
            this.visit((Method)expr);
        } else if (expr instanceof TypeLiteral) {
            this.visit((TypeLiteral)expr);
        } else if (expr instanceof Unary) {
            this.visit((Unary)expr);
        }
    }

    public void visit(UriResourcePrimitiveProperty info) {
        if (this.exprType == ExpressionType.ROOT) {
            this.stack.add((Expression)new ScalarSubquery(this.buildRootSubQuery(info.getProperty().getName(), this.ctxExpression)));
        } else {
            this.stack.add((Expression)new ElementSymbol(info.getProperty().getName(), this.ctxExpression.getGroupSymbol()));
        }
        Column c = this.ctxExpression.getTable().getColumnByName(info.getProperty().getName());
        this.lastPropertyType = c.getRuntimeType();
    }

    public void visit(UriResourceCount option) {
    }

    public void visit(UriResourceNavigation info) {
        try {
            DocumentNode navigationResource = DocumentNode.build((EdmEntityType)info.getType(), info.getKeyPredicates(), this.metadata, this.nameGenerator, true, this.getUriInfo(), this.parseService);
            Query query = new Query();
            query.setSelect(new Select(Arrays.asList(new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null))));
            query.setFrom(new From(Arrays.asList(navigationResource.getFromClause())));
            CompareCriteria criteria = null;
            ForeignKey fk = null;
            fk = info.isCollection() ? DocumentNode.joinFK(navigationResource.getTable(), this.ctxQuery.getTable()) : DocumentNode.joinFK(this.ctxQuery.getTable(), navigationResource.getTable());
            if (fk != null) {
                List<String> lhsColumns = DocumentNode.getColumnNames(fk.getColumns());
                List rhsColumns = fk.getReferenceColumns();
                for (int i = 0; i < lhsColumns.size(); ++i) {
                    if (criteria == null) {
                        criteria = new CompareCriteria((Expression)new ElementSymbol(lhsColumns.get(i), this.ctxQuery.getGroupSymbol()), 1, (Expression)new ElementSymbol((String)rhsColumns.get(i), navigationResource.getGroupSymbol()));
                        continue;
                    }
                    CompareCriteria subcriteria = new CompareCriteria((Expression)new ElementSymbol(lhsColumns.get(i), this.ctxQuery.getGroupSymbol()), 1, (Expression)new ElementSymbol((String)rhsColumns.get(i), navigationResource.getGroupSymbol()));
                    criteria = new CompoundCriteria(0, (Criteria)criteria, (Criteria)subcriteria);
                }
            } else {
                throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16037, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16037, new Object[0]));
            }
            query.setCriteria(criteria);
            this.stack.add((Expression)new ScalarSubquery((QueryCommand)query));
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(UriResourceLambdaAll resource) {
        this.exprType = ExpressionType.LAMBDAALL;
        UriResourceLambdaAll all = resource;
        this.accept(all.getExpression());
    }

    public void visit(UriResourceLambdaAny resource) {
        this.exprType = ExpressionType.LAMBDAANY;
        UriResourceLambdaAny any = resource;
        this.accept(any.getExpression());
    }

    public void visit(UriResourceLambdaVariable resource) {
        try {
            DocumentNode lambda = DocumentNode.build((EdmEntityType)resource.getType(), null, this.metadata, this.nameGenerator, false, this.uriInfo, this.parseService);
            lambda.setGroupSymbol(new GroupSymbol(resource.getVariableName(), lambda.getTable().getFullName()));
            if (this.exprType == ExpressionType.LAMBDAALL) {
                this.ctxExpression = lambda;
            } else {
                this.ctxQuery.joinTable(lambda, DocumentNode.joinFK(this.ctxQuery.getTable(), lambda.getTable()) == null, JoinType.JOIN_INNER);
                lambda.addCriteria(this.ctxQuery.getCriteria());
                lambda.setDistinct(true);
                this.ctxExpression = lambda;
                this.ctxQuery = lambda;
            }
        }
        catch (TeiidException e) {
            this.exceptions.add(e);
        }
    }

    private QueryCommand buildSubquery(DocumentNode eResource, Expression projected) {
        Select s1 = new Select();
        s1.addSymbol(projected);
        Query q = new Query();
        From from = new From();
        from.addGroup(eResource.getGroupSymbol());
        q.setFrom(from);
        q.setCriteria(DocumentNode.buildJoinCriteria(eResource, this.ctxQuery));
        q.setSelect(s1);
        return q;
    }

    public void visit(UriResourceIt info) {
        if (info.getType() instanceof SingletonPrimitiveType) {
            String group = this.nameGenerator.getNextGroup();
            GroupSymbol groupSymbol = new GroupSymbol(group);
            ElementSymbol es = new ElementSymbol("col", groupSymbol);
            String type = ODataTypeManager.teiidType((SingletonPrimitiveType)info.getType(), false);
            Function castFunction = new Function("CAST", new Expression[]{es, new Constant((Object)type)});
            this.stack.push((Expression)castFunction);
            StoredProcedure procedure = new StoredProcedure();
            procedure.setProcedureName("arrayiterate");
            ElementSymbol projectedEs = (ElementSymbol)this.ctxQuery.getProjectedColumns().get(0).getExpression();
            ArrayList<SPParameter> params = new ArrayList<SPParameter>();
            SPParameter param = new SPParameter(1, 1, "val");
            param.setExpression((Expression)projectedEs);
            params.add(param);
            procedure.setParameter(param);
            SubqueryFromClause fromClause = new SubqueryFromClause(group, (Command)procedure);
            fromClause.setTable(true);
            DocumentNode itResource = new DocumentNode();
            AliasSymbol expression = new AliasSymbol(projectedEs.getShortName(), (Expression)castFunction);
            itResource.setFromClause((FromClause)fromClause);
            itResource.setGroupSymbol(groupSymbol);
            itResource.addProjectedColumn((Expression)expression, true, info.getType(), true);
            this.ctxQuery.getProjectedColumns().remove(0);
            this.ctxQuery.addSibiling(itResource);
        } else {
            this.exceptions.add(new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16010, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16010, new Object[0])));
        }
    }

    public void visit(UriResourceRoot info) {
        this.exprType = ExpressionType.ROOT;
    }

    public void visit(UriResourceEntitySet info) {
        EdmEntityType edmEntityType = info.getEntitySet().getEntityType();
        if (this.exprType == ExpressionType.ROOT) {
            try {
                this.ctxExpression = DocumentNode.build(edmEntityType, info.getKeyPredicates(), this.metadata, this.nameGenerator, true, this.getUriInfo(), null);
            }
            catch (TeiidException e) {
                this.exceptions.add(e);
            }
        } else if (this.ctxQuery.getEdmEntityType().getFullQualifiedName().equals((Object)edmEntityType.getFullQualifiedName())) {
            this.ctxExpression = this.ctxQuery;
        } else {
            for (DocumentNode er : this.ctxQuery.getSibilings()) {
                if (!er.getEdmEntityType().getFullQualifiedName().equals((Object)edmEntityType.getFullQualifiedName())) continue;
                this.ctxExpression = er;
                break;
            }
        }
    }

    public QueryCommand buildRootSubQuery(String element, DocumentNode resource) {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol(element, resource.getGroupSymbol()));
        From f1 = new From();
        f1.addGroup(resource.getGroupSymbol());
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        q1.setCriteria(resource.getCriteria());
        return q1;
    }

    static enum ExpressionType {
        LAMBDAALL,
        LAMBDAANY,
        ROOT,
        ANY;

    }
}

