/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.LRUCache;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.logging.LogManager;
import org.teiid.odata.api.Client;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.LocalClient;
import org.teiid.olingo.service.OlingoBridge;
import org.teiid.olingo.web.ContextAwareHttpSerlvetRequest;
import org.teiid.olingo.web.ProxyHttpServletRequest;
import org.teiid.transport.LocalServerConnection;
import org.teiid.vdb.runtime.VDBKey;

public class ODataFilter
implements Filter,
VDBLifeCycleListener {
    protected String proxyBaseURI;
    protected Properties initProperties;
    protected Map<VDBKey, SoftReference<OlingoBridge>> contextMap = Collections.synchronizedMap(new LRUCache());
    private volatile boolean listenerRegistered = false;

    public void init(FilterConfig config) throws ServletException {
        String proxyURI = config.getInitParameter("proxy-base-uri");
        if (proxyURI != null && proxyURI.startsWith("${") && proxyURI.endsWith("}")) {
            proxyURI = proxyURI.substring(2, proxyURI.length() - 1);
            proxyURI = System.getProperty(proxyURI);
        }
        if (proxyURI != null) {
            this.proxyBaseURI = proxyURI;
        }
        Properties props = new Properties();
        Enumeration names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.setProperty(name, config.getInitParameter(name));
        }
        this.initProperties = props;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String proxyURI = this.proxyBaseURI;
        if (proxyURI != null) {
            httpRequest = new ProxyHttpServletRequest(httpRequest, proxyURI);
        }
        VDBKey key = null;
        String vdbName = null;
        int version = 1;
        String modelName = null;
        String uri = ((HttpServletRequest)request).getRequestURL().toString();
        int idx = uri.indexOf("/odata4/");
        if (idx != -1) {
            int endIdx;
            String contextPath = httpRequest.getContextPath();
            if (contextPath == null) {
                contextPath = "/odata4";
            }
            if ((endIdx = uri.indexOf(47, idx + 8)) == -1) {
                throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16020, new Object[0]));
            }
            vdbName = uri.substring(idx + 8, endIdx);
            int modelIdx = uri.indexOf(47, endIdx + 1);
            if (modelIdx == -1) {
                modelName = uri.substring(endIdx + 1).trim();
                if (modelName.isEmpty()) {
                    throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16019, new Object[0]));
                }
            } else {
                modelName = uri.substring(endIdx + 1, modelIdx);
            }
            contextPath = contextPath + "/" + vdbName + "/" + modelName;
            int versionIdx = vdbName.indexOf(46);
            if (versionIdx != -1) {
                version = Integer.parseInt(vdbName.substring(versionIdx + 1));
                vdbName = vdbName.substring(0, versionIdx);
            }
            if ((vdbName = vdbName.trim()).isEmpty()) {
                throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16008, new Object[0]));
            }
            ContextAwareHttpSerlvetRequest contextAwareRequest = new ContextAwareHttpSerlvetRequest(httpRequest);
            contextAwareRequest.setContextPath(contextPath);
            httpRequest = contextAwareRequest;
        } else {
            if (this.initProperties.getProperty("vdb-name") == null || this.initProperties.getProperty("vdb-version") == null) {
                throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16018, new Object[0]));
            }
            vdbName = this.initProperties.getProperty("vdb-name");
            version = Integer.parseInt(this.initProperties.getProperty("vdb-version"));
            int modelIdx = uri.indexOf(47, uri.indexOf(47));
            if (modelIdx == -1 && (modelName = uri.substring(uri.indexOf(47) + 1).trim()).isEmpty()) {
                throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16021, new Object[0]));
            }
            modelName = uri.substring(uri.indexOf(47), uri.indexOf(47, uri.indexOf(47)));
        }
        key = new VDBKey(vdbName, version);
        SoftReference<OlingoBridge> ref = this.contextMap.get(key);
        OlingoBridge context = null;
        if (ref != null) {
            context = ref.get();
        }
        if (context == null) {
            context = new OlingoBridge();
            ref = new SoftReference<OlingoBridge>(context);
            this.contextMap.put(key, ref);
        }
        Client client = this.buildClient(vdbName, version, this.initProperties);
        try {
            Connection connection = client.open();
            this.registerVDBListener(client, connection);
            ODataHttpHandler handler = context.getHandler(client, modelName);
            httpRequest.setAttribute(ODataHttpHandler.class.getName(), (Object)handler);
            httpRequest.setAttribute(Client.class.getName(), (Object)client);
            chain.doFilter((ServletRequest)httpRequest, response);
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerVDBListener(Client client, Connection conn) {
        if (!this.listenerRegistered) {
            ODataFilter oDataFilter = this;
            synchronized (oDataFilter) {
                if (!this.listenerRegistered && client instanceof LocalClient) {
                    try {
                        ConnectionImpl connection = (ConnectionImpl)conn;
                        LocalServerConnection lsc = (LocalServerConnection)connection.getServerConnection();
                        lsc.addListener((VDBLifeCycleListener)this);
                        this.listenerRegistered = true;
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16014, new Object[0]));
                    }
                }
            }
        }
    }

    public Client buildClient(String vdbName, int version, Properties props) {
        return new LocalClient(vdbName, version, props);
    }

    public void destroy() {
        this.contextMap.clear();
    }

    public void removed(String name, int version, CompositeVDB vdb) {
        this.contextMap.remove(new VDBKey(name, version));
    }

    public void finishedDeployment(String name, int version, CompositeVDB vdb, boolean reloading) {
        this.contextMap.remove(new VDBKey(name, version));
    }

    public void beforeRemove(String name, int version, CompositeVDB vdb) {
    }

    public void added(String name, int version, CompositeVDB vdb, boolean reloading) {
    }
}

