/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.core.deserializer.batch.BatchParser;

public class FixedFormatDeserializerImpl
implements FixedFormatDeserializer {
    public byte[] binary(InputStream content) throws DeserializerException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        try {
            int count;
            while ((count = content.read(buffer)) > -1) {
                result.write(buffer, 0, count);
            }
            result.flush();
        }
        catch (IOException e) {
            throw new DeserializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return result.toByteArray();
    }

    public Object primitiveValue(InputStream content, EdmProperty property) throws DeserializerException {
        if (property == null || !property.isPrimitive()) {
            throw new DeserializerException("Wrong property.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        try {
            StringWriter writer = new StringWriter();
            InputStreamReader reader = new InputStreamReader(content, "UTF-8");
            int c = -1;
            while ((c = reader.read()) != -1) {
                writer.append((char)c);
            }
            EdmPrimitiveType type = (EdmPrimitiveType)property.getType();
            return type.valueOfString(writer.toString(), Boolean.valueOf(property.isNullable()), property.getMaxLength(), property.getPrecision(), property.getScale(), Boolean.valueOf(property.isUnicode()), type.getDefaultType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("The value is not valid.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{property.getName()});
        }
        catch (IOException e) {
            throw new DeserializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    public List<BatchRequestPart> parseBatchRequest(InputStream content, String boundary, BatchOptions options) throws BatchDeserializerException {
        BatchParser parser = new BatchParser();
        return parser.parseBatchRequest(content, boundary, options);
    }
}

