/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BatchLineReader {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int EOF = -1;
    private static final int BUFFER_SIZE = 8192;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Charset CS_ISO_8859_1 = Charset.forName("iso-8859-1");
    public static final String BOUNDARY = "boundary";
    public static final String DOUBLE_DASH = "--";
    public static final String CRLF = "\r\n";
    private Charset currentCharset = DEFAULT_CHARSET;
    private String currentBoundary = null;
    private ReadState readState = new ReadState();
    private InputStream reader;
    private byte[] buffer;
    private int offset = 0;
    private int limit = 0;

    public BatchLineReader(InputStream reader) {
        this(reader, 8192);
    }

    public BatchLineReader(InputStream reader, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero.");
        }
        this.reader = reader;
        this.buffer = new byte[bufferSize];
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public List<String> toList() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String currentLine = this.readLine();
        if (currentLine != null) {
            this.currentBoundary = currentLine.trim();
            result.add(currentLine);
            while ((currentLine = this.readLine()) != null) {
                result.add(currentLine);
            }
        }
        return result;
    }

    public List<Line> toLineList() throws IOException {
        ArrayList<Line> result = new ArrayList<Line>();
        String currentLine = this.readLine();
        if (currentLine != null) {
            this.currentBoundary = currentLine.trim();
            int counter = 1;
            result.add(new Line(currentLine, counter++));
            while ((currentLine = this.readLine()) != null) {
                result.add(new Line(currentLine, counter++));
            }
        }
        return result;
    }

    private void updateCurrentCharset(String currentLine) {
        if (currentLine != null) {
            if (currentLine.startsWith("Content-Type")) {
                String clValue = currentLine.substring(13, currentLine.length() - 2).trim();
                ContentType ct = ContentType.parse((String)clValue);
                if (ct != null) {
                    String charsetString = ct.getParameter("charset");
                    this.currentCharset = charsetString != null ? Charset.forName(charsetString) : DEFAULT_CHARSET;
                    String boundary = ct.getParameter(BOUNDARY);
                    if (boundary != null) {
                        this.currentBoundary = DOUBLE_DASH + boundary;
                    }
                }
            } else if (CRLF.equals(currentLine)) {
                this.readState.foundLinebreak();
            } else if (this.isBoundary(currentLine)) {
                this.readState.foundBoundary();
            }
        }
    }

    private boolean isBoundary(String currentLine) {
        if ((this.currentBoundary + CRLF).equals(currentLine)) {
            return true;
        }
        return (this.currentBoundary + DOUBLE_DASH + CRLF).equals(currentLine);
    }

    String readLine() throws IOException {
        if (this.limit == -1) {
            return null;
        }
        ByteBuffer innerBuffer = ByteBuffer.allocate(8192);
        boolean foundLineEnd = false;
        while (!foundLineEnd) {
            if (this.limit == this.offset && this.fillBuffer() == -1) {
                foundLineEnd = true;
            }
            if (foundLineEnd) continue;
            byte currentChar = this.buffer[this.offset++];
            if (!innerBuffer.hasRemaining()) {
                innerBuffer.flip();
                ByteBuffer tmp = ByteBuffer.allocate(innerBuffer.limit() * 2);
                tmp.put(innerBuffer);
                innerBuffer = tmp;
            }
            innerBuffer.put(currentChar);
            if (currentChar == 10) {
                foundLineEnd = true;
                continue;
            }
            if (currentChar != 13) continue;
            foundLineEnd = true;
            if (this.limit == this.offset) {
                this.fillBuffer();
            }
            if (this.limit == -1 || this.buffer[this.offset] != 10) continue;
            innerBuffer.put((byte)10);
            ++this.offset;
        }
        if (innerBuffer.position() == 0) {
            return null;
        }
        String currentLine = this.readState.isReadBody() ? new String(innerBuffer.array(), 0, innerBuffer.position(), this.getCurrentCharset()) : new String(innerBuffer.array(), 0, innerBuffer.position(), CS_ISO_8859_1);
        this.updateCurrentCharset(currentLine);
        return currentLine;
    }

    private int fillBuffer() throws IOException {
        this.limit = this.reader.read(this.buffer, 0, this.buffer.length);
        this.offset = 0;
        return this.limit;
    }

    private Charset getCurrentCharset() {
        return this.currentCharset;
    }

    private static class ReadState {
        private int state = 0;

        private ReadState() {
        }

        public void foundLinebreak() {
            ++this.state;
        }

        public void foundBoundary() {
            this.state = 0;
        }

        public boolean isReadBody() {
            return this.state >= 2;
        }

        public String toString() {
            return String.valueOf(this.state);
        }
    }
}

