/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BatchParserCommon {
    private static final String PATTERN_BOUNDARY = "([a-zA-Z0-9_\\-\\.'\\+]{1,70})|\"([a-zA-Z0-9_\\-\\.'\\+\\s\\(\\),/:=\\?]{1,69}[a-zA-Z0-9_\\-\\.'\\+\\(\\),/:=\\?])\"";
    private static final Pattern PATTERN_LAST_CRLF = Pattern.compile("(.*)\\r\\n\\s*", 32);
    private static final Pattern PATTERN_HEADER_LINE = Pattern.compile("([a-zA-Z\\-]+):\\s?(.*)\\s*");
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    protected static final String BOUNDARY = "boundary";
    public static final String BINARY_ENCODING = "binary";

    private BatchParserCommon() {
    }

    public static String getBoundary(String contentType, int line) throws BatchDeserializerException {
        ContentType type = BatchParserCommon.parseContentType(contentType, ContentType.MULTIPART_MIXED, line);
        Map parameters = type.getParameters();
        for (Map.Entry entries : parameters.entrySet()) {
            if (!BOUNDARY.equalsIgnoreCase((String)entries.getKey())) continue;
            String boundary = ((String)entries.getValue()).trim();
            if (boundary.matches(PATTERN_BOUNDARY)) {
                return BatchParserCommon.trimQuotes(boundary);
            }
            throw new BatchDeserializerException("Invalid boundary format", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_BOUNDARY, new String[]{Integer.toString(line)});
        }
        throw new BatchDeserializerException("Missing boundary.", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_BOUNDARY_DELIMITER, new String[]{Integer.toString(line)});
    }

    public static ContentType parseContentType(String contentType, ContentType expected, int line) throws BatchDeserializerException {
        ContentType type;
        try {
            type = ContentType.create((String)contentType);
        }
        catch (IllegalArgumentException e) {
            if (contentType == null) {
                throw new BatchDeserializerException("Missing content type", (Throwable)e, (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TYPE, new String[]{Integer.toString(line)});
            }
            throw new BatchDeserializerException("Invalid content type.", (Throwable)e, (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TYPE, new String[]{Integer.toString(line)});
        }
        if (type.isCompatible(expected)) {
            return type;
        }
        throw new BatchDeserializerException("Content type is not the expected content type", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.UNEXPECTED_CONTENT_TYPE, new String[]{Integer.toString(line), expected.toContentTypeString(), type.toContentTypeString()});
    }

    private static String trimQuotes(String boundary) {
        if (boundary != null && boundary.length() >= 2 && boundary.startsWith("\"") && boundary.endsWith("\"")) {
            return boundary.substring(1, boundary.length() - 1);
        }
        return boundary;
    }

    public static List<List<Line>> splitMessageByBoundary(List<Line> message, String boundary) throws BatchDeserializerException {
        LinkedList<List<Line>> messageParts = new LinkedList<List<Line>>();
        LinkedList<Line> currentPart = new LinkedList<Line>();
        boolean isEndReached = false;
        String quotedBoundary = Pattern.quote(boundary);
        Pattern boundaryDelimiterPattern = Pattern.compile("--" + quotedBoundary + "--\\s*");
        Pattern boundaryPattern = Pattern.compile("--" + quotedBoundary + "\\s*");
        for (Line currentLine : message) {
            if (boundaryDelimiterPattern.matcher(currentLine.toString()).matches()) {
                BatchParserCommon.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                isEndReached = true;
            } else if (boundaryPattern.matcher(currentLine.toString()).matches()) {
                BatchParserCommon.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                currentPart = new LinkedList();
            } else {
                currentPart.add(currentLine);
            }
            if (!isEndReached) continue;
            break;
        }
        if (messageParts.size() > 0) {
            messageParts.remove(0);
        }
        if (!isEndReached) {
            int lineNumber = message.size() > 0 ? message.get(0).getLineNumber() : 0;
            throw new BatchDeserializerException("Missing close boundary delimiter", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CLOSE_DELIMITER, new String[]{Integer.toString(lineNumber)});
        }
        return messageParts;
    }

    private static void removeEndingCRLFFromList(List<Line> list) {
        if (list.size() > 0) {
            Line lastLine = list.remove(list.size() - 1);
            list.add(BatchParserCommon.removeEndingCRLF(lastLine));
        }
    }

    public static Line removeEndingCRLF(Line line) {
        Matcher matcher = PATTERN_LAST_CRLF.matcher(line.toString());
        if (matcher.matches()) {
            return new Line(matcher.group(1), line.getLineNumber());
        }
        return line;
    }

    public static Header consumeHeaders(List<Line> remainingMessage) {
        int headerLineNumber = remainingMessage.size() != 0 ? remainingMessage.get(0).getLineNumber() : 0;
        Header headers = new Header(headerLineNumber);
        Iterator<Line> iter = remainingMessage.iterator();
        boolean isHeader = true;
        while (iter.hasNext() && isHeader) {
            Line currentLine = iter.next();
            Matcher headerMatcher = PATTERN_HEADER_LINE.matcher(currentLine.toString());
            if (headerMatcher.matches() && headerMatcher.groupCount() == 2) {
                iter.remove();
                String headerName = headerMatcher.group(1).trim();
                String headerValue = headerMatcher.group(2).trim();
                headers.addHeader(headerName, Header.splitValuesByComma(headerValue), currentLine.getLineNumber());
                continue;
            }
            isHeader = false;
        }
        return headers;
    }

    public static void consumeBlankLine(List<Line> remainingMessage, boolean isStrict) throws BatchDeserializerException {
        if (remainingMessage.size() > 0 && remainingMessage.get(0).toString().matches("\\s*\r?\n\\s*")) {
            remainingMessage.remove(0);
        } else if (isStrict) {
            int lineNumber = remainingMessage.size() > 0 ? remainingMessage.get(0).getLineNumber() : 0;
            throw new BatchDeserializerException("Missing blank line", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_BLANK_LINE, new String[]{"[None]", Integer.toString(lineNumber)});
        }
    }

    public static InputStream convertLineListToInputStream(List<Line> messageList, Charset charset) {
        String message = BatchParserCommon.lineListToString(messageList);
        return new ByteArrayInputStream(message.getBytes(charset));
    }

    private static String lineListToString(List<Line> messageList) {
        StringBuilder builder = new StringBuilder();
        for (Line currentLine : messageList) {
            builder.append(currentLine.toString());
        }
        return builder.toString();
    }

    public static String trimLineListToLength(List<Line> list, int length) {
        String message = BatchParserCommon.lineListToString(list);
        int lastIndex = Math.min(length, message.length());
        return lastIndex > 0 ? message.substring(0, lastIndex) : "";
    }

    public static InputStream convertLineListToInputStream(List<Line> list, Charset charset, int length) {
        String message = BatchParserCommon.trimLineListToLength(list, length);
        return new ByteArrayInputStream(message.getBytes(charset));
    }
}

