/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.util.ArrayList;
import java.util.List;

public class HeaderField
implements Cloneable {
    private final String fieldName;
    private final List<String> values;
    private final int lineNumber;

    public HeaderField(String fieldName, int lineNumber) {
        this(fieldName, new ArrayList<String>(), lineNumber);
    }

    public HeaderField(String fieldName, List<String> values, int lineNumber) {
        this.fieldName = fieldName;
        this.values = values;
        this.lineNumber = lineNumber;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue() {
        StringBuilder result = new StringBuilder();
        for (String value : this.values) {
            result.append(value);
            result.append(", ");
        }
        if (result.length() > 0) {
            result.delete(result.length() - 2, result.length());
        }
        return result.toString();
    }

    public HeaderField clone() {
        ArrayList<String> newValues = new ArrayList<String>(this.values.size());
        newValues.addAll(this.values);
        return new HeaderField(this.fieldName, newValues, this.lineNumber);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderField other = (HeaderField)obj;
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

