/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.etag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ETagParser {
    private static final Pattern ETAG = Pattern.compile("\\s*(,\\s*)+|((?:W/)?\"[!#-~\\x80-\\xFF]*\")");

    private ETagParser() {
    }

    protected static Collection<String> parse(Collection<String> values) {
        if (values == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String value : values) {
            Collection<String> part = ETagParser.parse(value);
            if (part.size() == 1 && part.iterator().next().equals("*")) {
                return part;
            }
            result.addAll(part);
        }
        return result;
    }

    private static Collection<String> parse(String value) {
        if (value.trim().equals("*")) {
            return Collections.singleton("*");
        }
        HashSet<String> result = new HashSet<String>();
        String separator = "";
        int start = 0;
        Matcher matcher = ETAG.matcher(value.trim());
        while (matcher.find() && matcher.start() == start) {
            start = matcher.end();
            if (matcher.group(1) != null) {
                separator = matcher.group(1);
                continue;
            }
            if (separator != null) {
                result.add(matcher.group(2));
                separator = null;
                continue;
            }
            return Collections.emptySet();
        }
        return matcher.hitEnd() ? result : Collections.emptySet();
    }
}

