/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

public abstract class ExpandSelectHelper {
    public static boolean hasSelect(SelectOption select) {
        return select != null && select.getSelectItems() != null && !select.getSelectItems().isEmpty();
    }

    public static boolean isAll(SelectOption select) {
        if (ExpandSelectHelper.hasSelect(select)) {
            for (SelectItem item : select.getSelectItems()) {
                if (!item.isStar()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Set<String> getSelectedPropertyNames(List<SelectItem> selectItems) {
        HashSet<String> selected = new HashSet<String>();
        for (SelectItem item : selectItems) {
            UriResource resource = (UriResource)item.getResourcePath().getUriResourceParts().get(0);
            if (!(resource instanceof UriResourceProperty)) continue;
            selected.add(((UriResourceProperty)resource).getProperty().getName());
        }
        return selected;
    }

    public static Set<List<String>> getSelectedPaths(List<SelectItem> selectItems, String propertyName) {
        HashSet<List<String>> selectedPaths = new HashSet<List<String>>();
        for (SelectItem item : selectItems) {
            List parts = item.getResourcePath().getUriResourceParts();
            UriResource resource = (UriResource)parts.get(0);
            if (!(resource instanceof UriResourceProperty) || !propertyName.equals(((UriResourceProperty)resource).getProperty().getName())) continue;
            if (parts.size() > 1) {
                ArrayList<String> path = new ArrayList<String>();
                for (UriResource part : parts.subList(1, parts.size())) {
                    if (!(part instanceof UriResourceProperty)) continue;
                    path.add(((UriResourceProperty)part).getProperty().getName());
                }
                selectedPaths.add(path);
                continue;
            }
            return null;
        }
        return selectedPaths.isEmpty() ? null : selectedPaths;
    }

    public static boolean isSelected(Set<List<String>> selectedPaths, String propertyName) {
        for (List<String> path : selectedPaths) {
            if (!propertyName.equals(path.get(0))) continue;
            return true;
        }
        return false;
    }

    public static Set<List<String>> getReducedSelectedPaths(Set<List<String>> selectedPaths, String propertyName) {
        HashSet<List<String>> reducedPaths = new HashSet<List<String>>();
        for (List<String> path : selectedPaths) {
            if (!propertyName.equals(path.get(0))) continue;
            if (path.size() > 1) {
                reducedPaths.add(path.subList(1, path.size()));
                continue;
            }
            return null;
        }
        return reducedPaths.isEmpty() ? null : reducedPaths;
    }

    public static boolean hasExpand(ExpandOption expand) {
        return expand != null && expand.getExpandItems() != null && !expand.getExpandItems().isEmpty();
    }

    public static boolean isExpandAll(ExpandOption expand) {
        for (ExpandItem item : expand.getExpandItems()) {
            if (!item.isStar()) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getExpandedPropertyNames(List<ExpandItem> expandItems) throws SerializerException {
        HashSet<String> expanded = new HashSet<String>();
        for (ExpandItem item : expandItems) {
            List resourceParts = item.getResourcePath().getUriResourceParts();
            UriResource resource = (UriResource)resourceParts.get(0);
            if (!(resource instanceof UriResourceNavigation)) continue;
            expanded.add(((UriResourceNavigation)resource).getProperty().getName());
        }
        return expanded;
    }

    public static ExpandItem getExpandItem(List<ExpandItem> expandItems, String propertyName) {
        for (ExpandItem item : expandItems) {
            UriResource resource = (UriResource)item.getResourcePath().getUriResourceParts().get(0);
            if (!(resource instanceof UriResourceNavigation) || !propertyName.equals(((UriResourceNavigation)resource).getProperty().getName())) continue;
            return item;
        }
        return null;
    }
}

