/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.apache.olingo.server.core.requests.DataRequest;
import org.apache.olingo.server.core.requests.FunctionRequest;
import org.apache.olingo.server.core.requests.MediaRequest;
import org.apache.olingo.server.core.requests.MetadataRequest;
import org.apache.olingo.server.core.requests.ServiceDocumentRequest;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.MetadataResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;
import org.apache.olingo.server.core.responses.ServiceDocumentResponse;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.StreamResponse;

public interface ServiceHandler
extends Processor {
    public void readMetadata(MetadataRequest var1, MetadataResponse var2) throws ODataLibraryException, ODataApplicationException;

    public void readServiceDocument(ServiceDocumentRequest var1, ServiceDocumentResponse var2) throws ODataLibraryException, ODataApplicationException;

    public <T extends ServiceResponse> void read(DataRequest var1, T var2) throws ODataLibraryException, ODataApplicationException;

    public void createEntity(DataRequest var1, Entity var2, EntityResponse var3) throws ODataLibraryException, ODataApplicationException;

    public void updateEntity(DataRequest var1, Entity var2, boolean var3, String var4, EntityResponse var5) throws ODataLibraryException, ODataApplicationException;

    public void upsertEntity(DataRequest var1, Entity var2, boolean var3, String var4, EntityResponse var5) throws ODataLibraryException, ODataApplicationException;

    public void deleteEntity(DataRequest var1, String var2, EntityResponse var3) throws ODataLibraryException, ODataApplicationException;

    public void updateProperty(DataRequest var1, Property var2, boolean var3, String var4, PropertyResponse var5) throws ODataLibraryException, ODataApplicationException;

    public void upsertStreamProperty(DataRequest var1, String var2, InputStream var3, NoContentResponse var4) throws ODataLibraryException, ODataApplicationException;

    public <T extends ServiceResponse> void invoke(FunctionRequest var1, HttpMethod var2, T var3) throws ODataLibraryException, ODataApplicationException;

    public <T extends ServiceResponse> void invoke(ActionRequest var1, String var2, T var3) throws ODataLibraryException, ODataApplicationException;

    public void readMediaStream(MediaRequest var1, StreamResponse var2) throws ODataLibraryException, ODataApplicationException;

    public void upsertMediaStream(MediaRequest var1, String var2, InputStream var3, NoContentResponse var4) throws ODataLibraryException, ODataApplicationException;

    public void anyUnsupported(ODataRequest var1, ODataResponse var2) throws ODataLibraryException, ODataApplicationException;

    public void addReference(DataRequest var1, String var2, URI var3, NoContentResponse var4) throws ODataLibraryException, ODataApplicationException;

    public void updateReference(DataRequest var1, String var2, URI var3, NoContentResponse var4) throws ODataLibraryException, ODataApplicationException;

    public void deleteReference(DataRequest var1, URI var2, String var3, NoContentResponse var4) throws ODataLibraryException, ODataApplicationException;

    public String startTransaction() throws ODataLibraryException, ODataApplicationException;

    public void commit(String var1) throws ODataLibraryException, ODataApplicationException;

    public void rollback(String var1) throws ODataLibraryException, ODataApplicationException;

    public void crossJoin(DataRequest var1, List<String> var2, ODataResponse var3) throws ODataLibraryException, ODataApplicationException;
}

